/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.gcap.especie;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.app.acoes.ImportarGCAPAction;
import serpro.ppgd.irpf.gcap.ObjetoGCAP;
import serpro.ppgd.irpf.gcap.especie.ColecaoMoedaAlienada;
import serpro.ppgd.irpf.gcap.especie.MoedaAlienada;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.PainelListaAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.TableListaSumario;
import serpro.ppgd.irpf.gui.gcap.especie.PainelDadosMoedaAlienada;
import serpro.ppgd.irpf.gui.gcap.especie.TableModelMoedasEspecie;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaListaMoedasEspecie
extends PainelListaAb {
    private static final long serialVersionUID = 1L;
    public static final String TITULO = "Moedas em Esp\u00e9cie";
    public static final String NOME_ABA = "Moedas Alienadas";
    public static final String HELP_ID = "Demonstrativo de Ganhos de Capital (GCAP 2022)";
    private PainelDemonstrativoIf painelPai;

    public PainelAbaListaMoedasEspecie() {
        this.ajustarToolBarImportar();
    }

    public PainelAbaListaMoedasEspecie(Colecao<? extends ObjetoNegocio> colecao) {
        super(colecao);
        this.ajustarToolBarImportar();
    }

    public PainelAbaListaMoedasEspecie(PainelDemonstrativoIf painelPai) {
        this.painelPai = painelPai;
        this.ajustarToolBarImportar();
    }

    public void onBtnNovoClick(ActionEvent e) {
        new ImportarGCAPAction().executarAcao(null);
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            TableListaModel model = (TableListaModel)this.getTabela().getModel();
            ColecaoMoedaAlienada moedas = (ColecaoMoedaAlienada)model.getObjetoNegocio();
            MoedaAlienada moeda = (MoedaAlienada)moedas.itens().get(indiceVetor);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelDadosMoedaAlienada(moeda));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public void onBtnExcluirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        boolean temSumario = tabela instanceof TableListaSumario;
        if (!(tabela.getSelectedRowCount() <= 0 || temSumario && tabela.getSelectedRow() >= tabela.getRowCount() - 1)) {
            int[] linhasTabela = tabela.getSelectedRows();
            if (GuiUtil.mostrarConfirma((String)"gcap_excluir_cpf")) {
                ArrayList<MoedaAlienada> listaRemocao = new ArrayList<MoedaAlienada>(linhasTabela.length);
                ColecaoMoedaAlienada colecao = null;
                for (int linhaTabela : linhasTabela) {
                    int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
                    IRPFTableModelAb model = (IRPFTableModelAb)tabela.getModel();
                    colecao = (ColecaoMoedaAlienada)model.getObjetoNegocio();
                    listaRemocao.add((MoedaAlienada)colecao.itens().get(indiceVetor));
                }
                Object object = listaRemocao.iterator();
                while (object.hasNext()) {
                    MoedaAlienada alienacao = (MoedaAlienada)object.next();
                    ControladorGui.getDemonstrativoAberto().getGCAP().removerDemonstrativo((ObjetoGCAP)alienacao);
                }
                ControladorGui.getDemonstrativoAberto().getGCAP().recalcularConsolidacoes();
                ControladorGui.getDemonstrativoAberto().getGCAP().recalcularGCAPDeclaracaoIRPF();
            }
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(100);
        tcm.getColumn(1).setPreferredWidth(850);
        tcm.getColumn(2).setPreferredWidth(150);
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista.accessibleColumnHeader = new String[]{"Item", "Rela\u00e7\u00e3o de Moedas Alienadas"};
        return tableLista;
    }

    protected String getClassePainelNavegacao() {
        return PainelDadosMoedaAlienada.class.getName();
    }

    protected String getButtonHelpID() {
        return HELP_ID;
    }

    protected TableListaModel getTableModel() {
        return new TableModelMoedasEspecie((ObjetoNegocio)ControladorGui.getDemonstrativoAberto().getGCAP().getEspecie());
    }

    protected int getColunaOrdenacao() {
        return 0;
    }

    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens1";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"moedas em esp\u00e9cie"};
    }

    public String getTituloPainel() {
        return TITULO;
    }

    public boolean isTelaComFavoritos() {
        return true;
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/ME_especie.png");
    }
}

