/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui.xbeans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.PainelBotao;
import serpro.ppgd.gui.xbeans.editors.PPGDSpinner;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;

public class JEditInteiro
extends JEditCampo {
    private JSpinner componente;
    private SpinnerNumberModel model;

    public JEditInteiro() {
        super((Informacao<?>)new Inteiro("Inteiro"));
    }

    public JEditInteiro(Informacao campo) {
        super(campo);
    }

    @Override
    public int getBaseline(int width, int height) {
        if (this.componente != null) {
            return this.componente.getBaseline(width, height);
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        if (this.componente != null) {
            return this.componente.getBaselineResizeBehavior();
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    public void conteudoPropertyChange(PropertyChangeEvent evt) {
        if (evt != null && evt.getPropertyName() != null && evt.getPropertyName().equals("LIMITES")) {
            if (this.getInformacao() instanceof Inteiro) {
                int limiteMax = ((Inteiro)this.getInformacao()).getLimiteMaximo();
                int limiteMin = ((Inteiro)this.getInformacao()).getLimiteMinimo();
                if (limiteMax != -1) {
                    this.setValorMaximo(limiteMax);
                }
                if (limiteMin != -1) {
                    this.setValorMinimo(limiteMin);
                }
            }
            return;
        }
        this.getInformacao().setObservadoresAtivos(false);
        this.setObservadorAtivo(false);
        Integer newValue = new Integer(((Inteiro)this.getInformacao()).asInteger());
        Integer maxValue = (Integer)this.model.getMaximum();
        Integer minValue = (Integer)this.model.getMinimum();
        if (newValue > maxValue) {
            newValue = maxValue;
        } else if (newValue < minValue) {
            newValue = minValue;
        }
        this.componente.setValue(newValue);
        this.getInformacao().setObservadoresAtivos(true);
        this.setObservadorAtivo(true);
    }

    public void setFormatPattern(String pPattern) {
        JSpinner.NumberEditor newEditor = new JSpinner.NumberEditor(this.componente, pPattern);
        this.componente.setEditor(newEditor);
    }

    @Override
    public JComponent getComponenteEditor() {
        return this.componente;
    }

    public void setValorMinimo(int aValorMinimo) {
        this.model.setMinimum(new Integer(aValorMinimo));
        this.conteudoPropertyChange(null);
    }

    public int getValorMinimo() {
        return Integer.parseInt(this.model.getMinimum().toString());
    }

    public void setValorMaximo(int aValorMax) {
        this.model.setMaximum(new Integer(aValorMax));
        this.conteudoPropertyChange(null);
    }

    public int getValorMaximo() {
        return Integer.parseInt(this.model.getMaximum().toString());
    }

    public void setValorOffset(int aOffset) {
        this.model.setStepSize(new Integer(aOffset));
    }

    public int getValorOffset() {
        return this.model.getStepSize().intValue();
    }

    @Override
    public JComponent getComponenteFoco() {
        return this.componente;
    }

    @Override
    protected void buildComponente() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        if (this.componente == null) {
            this.model = new SpinnerNumberModel(0, 0, 10000, 1);
            this.componente = new PPGDSpinner(this.model);
            this.model.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    Integer value;
                    Integer newValue = value = (Integer)JEditInteiro.this.componente.getValue();
                    Integer maxValue = (Integer)JEditInteiro.this.model.getMaximum();
                    Integer minValue = (Integer)JEditInteiro.this.model.getMinimum();
                    if (newValue > maxValue) {
                        newValue = maxValue;
                    } else if (newValue < minValue) {
                        newValue = minValue;
                    }
                    JEditInteiro.this.getInformacao().setConteudo(newValue.toString());
                }
            });
        }
        this.add((Component)this.componente, "Center");
        JButtonMensagem btnMsg = this.getButtonMensagem();
        if (btnMsg != null) {
            this.add((Component)new PainelBotao(btnMsg), "East");
        }
    }

    @Override
    protected void informacaoModificada() {
        Inteiro inteiro = (Inteiro)this.getInformacao();
        int valor = inteiro.asInteger();
        this.componente.setValue(new Integer(valor));
        ((PPGDSpinner)this.componente).setInformacao(this.campo);
        if (this.getInformacao() instanceof Inteiro) {
            int limiteMax = ((Inteiro)this.getInformacao()).getLimiteMaximo();
            int limiteMin = ((Inteiro)this.getInformacao()).getLimiteMinimo();
            if (limiteMax != -1) {
                this.setValorMaximo(limiteMax);
            }
            if (limiteMin != -1) {
                this.setValorMinimo(limiteMin);
            }
        }
    }

    @Override
    protected void readOnlyPropertyChange(boolean readOnly) {
        if (readOnly) {
            this.componente.setEnabled(false);
        } else {
            this.componente.setEnabled(true);
        }
    }

    @Override
    protected void habilitadoPropertyChange(boolean habilitado) {
        this.getComponenteEditor().setEnabled(habilitado);
        JLabel rotulo = this.getRotulo();
        if (rotulo != null) {
            this.getRotulo().setEnabled(habilitado);
        }
    }

    @Override
    public void setEstiloFonte(int estilo) {
        Font f = this.getComponenteEditor().getFont();
        f = f.deriveFont(estilo);
        this.getComponenteEditor().setFont(f);
    }

    @Override
    public void setIncrementoTamanhoFonte(int incremento) {
        this.incrementoTamanhoFonte = incremento;
        Font f = this.getComponenteEditor().getFont();
        if (this.tamanhoOriginal == -1.0f) {
            this.tamanhoOriginal = f.getSize2D();
        }
        f = f.deriveFont(this.tamanhoOriginal + (float)incremento);
        this.getComponenteEditor().setFont(f);
    }

    @Override
    public int getIncrementoTamanhoFonte() {
        return this.incrementoTamanhoFonte;
    }
}

