/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.xmlada;

import br.gov.serpro.midas.xmlada.DocTipos;
import br.gov.serpro.midas.xmlada.TextBuffer;
import br.gov.serpro.midas.xmlada.XMLAdaJ;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class DomDocument {
    private Document domDocument;
    private Element raiz;
    private String xml;
    private boolean ok = false;
    private boolean isFileName;
    private Transformer transformer;
    private DocumentBuilder construtorDoc;

    public DomDocument(String xml) {
        this.ok = this.criaXmlDom(xml, false);
    }

    public DomDocument(String xml, boolean criarNovo) {
        this.ok = this.criaXmlDom(xml, criarNovo);
    }

    private boolean criaXmlDom(String xml, boolean criarNovo) {
        if (xml == null) {
            return false;
        }
        try {
            DocumentBuilder construtorDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            if (xml.length() == 0 || criarNovo) {
                this.domDocument = construtorDoc.newDocument();
            }
            boolean bl = xml.length() != 0 ? !xml.substring(0, 1).equals("<") : (this.isFileName = false);
            if (!criarNovo) {
                if (this.isFileName) {
                    File fileXML = new File(xml);
                    if (fileXML.exists()) {
                        this.domDocument = construtorDoc.parse(fileXML);
                        this.raiz = this.domDocument.getDocumentElement();
                    }
                } else if (xml.length() > 0) {
                    this.domDocument = construtorDoc.parse(new InputSource(new StringReader(xml)));
                    this.raiz = this.domDocument.getDocumentElement();
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        this.xml = xml;
        return true;
    }

    public Element getRaiz() {
        return this.raiz;
    }

    public void setRaiz(Element element) {
        this.raiz = element;
        this.domDocument.appendChild(this.raiz);
    }

    public Element criaElemento(String nome) {
        return this.domDocument.createElement(nome);
    }

    public Text criaNoTexto(String nome) {
        return this.domDocument.createTextNode(nome);
    }

    public boolean getOk() {
        return this.ok && this.raiz != null;
    }

    public String getXml() {
        return this.ok ? this.xml : null;
    }

    public Document getDomDoc() {
        return this.ok ? this.domDocument : null;
    }

    public Element getSingleNode(String nodeTag) {
        NodeList nodeList = this.domDocument.getElementsByTagName(nodeTag);
        return nodeList.getLength() <= 0 ? null : (Element)nodeList.item(0);
    }

    public Element getSingleNode(String nodeTag, Node noAtual) {
        NodeList nodeList = this.domDocument.getElementsByTagName(nodeTag);
        int i = 0;
        while (i < nodeList.getLength()) {
            if (nodeList.item(i).getParentNode().equals(noAtual)) {
                return (Element)nodeList.item(i);
            }
            ++i;
        }
        return null;
    }

    public Element getSingleNode(String nodeTag, Node noAtual, String atributo) {
        NodeList nosFilhos = noAtual.getChildNodes();
        int i = 0;
        while (i < nosFilhos.getLength()) {
            Element child;
            if (nosFilhos.item(i).getNodeType() == 1 && (child = (Element)nosFilhos.item(i)).getNodeName().equals(nodeTag)) {
                String atrib = atributo.substring(0, atributo.indexOf("="));
                String vlrAtrib = atributo.substring(atributo.indexOf("=") + 1);
                if (child.getAttribute(atrib).equals(vlrAtrib)) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    public String getAttributeValue(String nodeTag, String AttrTag) {
        NodeList nodeList = this.domDocument.getElementsByTagName(nodeTag);
        if (nodeList.getLength() > 0) {
            Element E = (Element)nodeList.item(0);
            return E.hasAttribute(AttrTag) ? E.getAttribute(AttrTag) : null;
        }
        return null;
    }

    public String transform(String xsl, String extensaoSaida) throws Exception {
        if (this.ok) {
            DomDocument arquivoXSL = new DomDocument(xsl);
            if (arquivoXSL.getOk()) {
                if (this.isFileName) {
                    File outTransformFile = new File(String.valueOf(this.xml.substring(0, this.xml.indexOf("."))) + extensaoSaida);
                    FileOutputStream outTransformStream = new FileOutputStream(outTransformFile);
                    Transformer transformer = TransformerFactory.newInstance().newTransformer(new SAXSource(new InputSource(new FileInputStream(xsl))));
                    transformer.setOutputProperty("encoding", "UTF-8");
                    transformer.setOutputProperty("method", "html");
                    transformer.transform(new DOMSource(this.domDocument), new StreamResult(outTransformStream));
                    return "";
                }
                Transformer transformer = TransformerFactory.newInstance().newTransformer(new StreamSource(xsl));
                transformer.setOutputProperty("encoding", "UTF-8");
                StringWriter s = new StringWriter();
                transformer.transform(new DOMSource(this.domDocument), new StreamResult(s));
                return s.toString();
            }
            XMLAdaJ.setErro(-95, "(transform) Arquivo XSL " + xsl + " n\u00e3o pode ser carregado.  Verifique se existe ou est\u00e1 bem formado.");
            return "";
        }
        XMLAdaJ.setErro(-95, "(transform) Arquivo XML " + this.xml + " n\u00e3o pode ser carregado.  Verifique se existe ou est\u00e1 bem formado.");
        return this.xml;
    }

    public void gravaDoc() {
        try {
            StreamResult result = this.isFileName ? new StreamResult(new FileOutputStream(new File(this.xml))) : new StreamResult(new StringWriter());
            this.getTransformerVazio();
            this.transformer.transform(new DOMSource(this.domDocument), result);
            this.xml = this.isFileName ? this.xml : result.getWriter().toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void gravaDoc(String elemento) {
        try {
            NodeList list = this.domDocument.getElementsByTagName(elemento);
            Node no = list.item(0) != null ? list.item(0) : this.raiz;
            StreamResult result = this.isFileName ? new StreamResult(new FileOutputStream(new File(this.xml))) : new StreamResult(new StringWriter());
            this.getTransformerVazio();
            this.transformer.transform(new DOMSource(no), result);
            this.xml = this.isFileName ? this.xml : result.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getTexto() {
        this.gravaDoc();
        return this.isFileName ? new TextBuffer(this.xml, true, true).getTexto() : this.xml;
    }

    private void getTransformerVazio() {
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("encoding", "UTF-8");
            this.transformer.setOutputProperty("method", "xml");
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "3");
            this.transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public void insereAtributos(Element elEstrutura, Element elDestino, DocTipos tipos, String linha) {
        if (elEstrutura == null) {
            return;
        }
        NodeList nosFilhos = elEstrutura.getChildNodes();
        int i = 0;
        while (i < nosFilhos.getLength()) {
            Element child;
            if (nosFilhos.item(i).getNodeType() == 1 && (child = (Element)nosFilhos.item(i)).getNodeName().equals("atributo")) {
                String nomeAtrib = child.getAttribute("nome");
                String vlrAtrib = child.getAttribute("valor");
                int inicio = child.getAttribute("ini").length() <= 0 ? 0 : Integer.parseInt(child.getAttribute("ini")) - 1;
                int tamanho = child.getAttribute("tam").length() <= 0 ? 0 : Integer.parseInt(child.getAttribute("tam"));
                String formato = child.getAttribute("formato");
                String string = vlrAtrib = tamanho <= 0 ? vlrAtrib : linha.substring(inicio, inicio + tamanho).trim();
                vlrAtrib = tipos == null ? vlrAtrib : (tipos.getOk() ? tipos.formataCampo(formato, vlrAtrib) : vlrAtrib);
                vlrAtrib = String.valueOf(this.verAfixos(child, "prefixo", tipos, linha)) + vlrAtrib + this.verAfixos(child, "sufixo", tipos, linha);
                elDestino.setAttribute(nomeAtrib, vlrAtrib);
            }
            ++i;
        }
    }

    public String verAfixos(Element e, String tipo, DocTipos tipos, String linha) {
        String vlr = "";
        String result = "";
        NodeList nosFilhos = e.getChildNodes();
        int i = 0;
        while (i < nosFilhos.getLength()) {
            Element child;
            if (nosFilhos.item(i).getNodeType() == 1 && (child = (Element)nosFilhos.item(i)).getNodeName().equals(tipo)) {
                vlr = child.getAttribute("valor");
                int inicio = child.getAttribute("ini").length() <= 0 ? 0 : Integer.parseInt(child.getAttribute("ini")) - 1;
                int tamanho = child.getAttribute("tam").length() <= 0 ? 0 : Integer.parseInt(child.getAttribute("tam"));
                String formato = child.getAttribute("formato");
                String string = vlr = tamanho <= 0 ? vlr : linha.substring(inicio, inicio + tamanho).trim();
                vlr = tipos == null ? vlr : (tipos.getOk() ? tipos.formataCampo(formato, vlr) : vlr);
                vlr = String.valueOf(this.verAfixos(child, "prefixo", tipos, linha)) + vlr + this.verAfixos(child, "sufixo", tipos, linha);
                result = String.valueOf(result) + vlr;
            }
            ++i;
        }
        return result;
    }
}

