/*
 * Decompiled with CFR 0.152.
 */
package jsignnet.crypto.icp;

import java.io.IOException;
import java.util.Date;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.crypto.icp.CertificadoICPBrasil;
import jsignnet.crypto.icp.FiltroICPNumeroSerieSujeito;

public class CertificadoICPBrasilNumeroSerieSujeito
extends CertificadoICPBrasil {
    private boolean ePessoaFisica;
    private boolean ePessoaJuridica;
    private long ni;

    public CertificadoICPBrasilNumeroSerieSujeito(X509CertificadoWrapper certificado) {
        super(certificado);
        if (!FiltroICPNumeroSerieSujeito.singleton().isCertificadoValido(certificado)) {
            throw new IllegalArgumentException("O certificado informado n\u00e3o segue a estrutura da ICP-Brasil.");
        }
        String numeroSerieSujeito = this.getNumeroSerieSujeito();
        this.ePessoaFisica = numeroSerieSujeito.length() == 11;
        this.ePessoaJuridica = numeroSerieSujeito.length() == 14;
        try {
            this.ni = Long.parseLong(numeroSerieSujeito);
        }
        catch (NumberFormatException e) {
            this.ni = -1L;
        }
    }

    @Override
    public boolean eCertificadoPessoaFisica() throws IOException {
        return this.ePessoaFisica;
    }

    @Override
    public boolean eCertificadoPessoaJuridica() throws IOException {
        return this.ePessoaJuridica;
    }

    @Override
    public long getNI() {
        return this.ni;
    }

    @Override
    public long getNIResponsavel() {
        return -1L;
    }

    @Override
    public Date getDataNascimento() {
        return null;
    }
}

