/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpf;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class RendPFHeaderCellRenderer
extends DefaultTableCellRenderer
implements UIResource {
    private static final long serialVersionUID = 1L;
    private static final Color BG_HEADER = new Color(213, 231, 245);
    private static final Color FG_HEADER = new Color(11, 56, 90);
    private boolean horizontalTextPositionSet;

    public RendPFHeaderCellRenderer() {
        this.setHorizontalAlignment(0);
    }

    @Override
    public void setHorizontalTextPosition(int textPosition) {
        this.horizontalTextPositionSet = true;
        super.setHorizontalTextPosition(textPosition);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Icon sortIcon = null;
        boolean isPaintingForPrint = false;
        if (table != null) {
            JTableHeader header = table.getTableHeader();
            if (header != null) {
                Color bgColor = null;
                if (hasFocus) {
                    bgColor = UIManager.getColor("TableHeader.focusCellBackground");
                }
                if (bgColor == null) {
                    bgColor = header.getBackground();
                }
                this.setBackground(bgColor);
                this.setFont(header.getFont());
                isPaintingForPrint = header.isPaintingForPrint();
            }
            if (!isPaintingForPrint && table.getRowSorter() != null) {
                SortOrder sortOrder;
                if (!this.horizontalTextPositionSet) {
                    this.setHorizontalTextPosition(10);
                }
                if ((sortOrder = RendPFHeaderCellRenderer.getColumnSortOrder(table, column)) != null) {
                    switch (sortOrder) {
                        case ASCENDING: {
                            sortIcon = UIManager.getIcon("Table.ascendingSortIcon");
                            break;
                        }
                        case DESCENDING: {
                            sortIcon = UIManager.getIcon("Table.descendingSortIcon");
                            break;
                        }
                        case UNSORTED: {
                            sortIcon = UIManager.getIcon("Table.naturalSortIcon");
                        }
                    }
                }
            }
        }
        this.setText(value == null ? "" : value.toString());
        this.setIcon(sortIcon);
        Border border = null;
        if (hasFocus) {
            border = UIManager.getBorder("TableHeader.focusCellBorder");
        }
        if (border == null) {
            border = UIManager.getBorder("TableHeader.cellBorder");
        }
        this.setBorder(border);
        this.setForeground(FG_HEADER);
        if (value == null || value.toString().trim().isEmpty()) {
            this.setBackground(Color.WHITE);
        } else {
            this.setBackground(BG_HEADER);
        }
        return this;
    }

    public static SortOrder getColumnSortOrder(JTable table, int column) {
        SortOrder rv = null;
        if (table.getRowSorter() == null) {
            return rv;
        }
        List<RowSorter.SortKey> sortKeys = table.getRowSorter().getSortKeys();
        if (sortKeys.size() > 0 && sortKeys.get(0).getColumn() == table.convertColumnIndexToModel(column)) {
            rv = sortKeys.get(0).getSortOrder();
        }
        return rv;
    }
}

