/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpf;

import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelEscrituracao
extends TableListaModel {
    public static final String TEXT_CPF_N\u00c3O_INFORMADO = "CPF n\u00e3o informado";
    private static final long serialVersionUID = 1L;
    ContasMes contasMes;

    public TableModelEscrituracao(ContasMes pObj) {
        super((ObjetoNegocio)pObj);
        this.contasMes = pObj;
    }

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.contasMes.itens().size();
    }

    public Informacao<?> getInformacaoAt(int row, int col) {
        Conta item = null;
        ContasMes mesEscrituracao = (ContasMes)this.getObjetoNegocio();
        if (row < mesEscrituracao.itens().size()) {
            item = (Conta)mesEscrituracao.itens().get(row);
            switch (col) {
                case 0: {
                    return item.getCpfTitularPagamento();
                }
                case 1: {
                    if (item.getIndBeneficiarioNaoPossuiCPF().naoFormatado().equals(Logico.SIM)) {
                        Alfa a = new Alfa();
                        a.setConteudo(TEXT_CPF_N\u00c3O_INFORMADO);
                        return a;
                    }
                    return item.getCpfBeneficiarioServico();
                }
                case 2: {
                    return item.getValor();
                }
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "<html><center>Titular do Pagamento</center></html>";
            }
            case 1: {
                return "<html><center>Benefici\u00e1rio do Servi\u00e7o</center></html>";
            }
            case 2: {
                return "<html><center>Rendimentos Recebidos</center></html>";
            }
        }
        return "";
    }
}

