/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.jasperreports;

import br.gov.serpro.midas.jasperreports.BackedJRXmlDataSource;
import br.gov.serpro.midas.jasperreports.MidasJasperDataSource;
import br.gov.serpro.midas.jasperreports.XPathWalker;
import br.gov.serpro.midas.negocio.MidasReportElement;
import br.gov.serpro.midas.negocio.MidasReportElementBuilder;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JRXmlDataSource
extends net.sf.jasperreports.engine.data.JRXmlDataSource
implements MidasJasperDataSource {
    private static final Logger log = LoggerFactory.getLogger(JRXmlDataSource.class);
    private MidasReportElement current;
    private MidasReportElement root;
    private List<MidasReportElement> nodes = Collections.emptyList();
    private String xPathExpression;
    int currentIndex = -1;

    public JRXmlDataSource(InputStream in) throws Exception {
        this(new MidasReportElementBuilder(in).build(), ".");
    }

    public JRXmlDataSource(MidasReportElement reportElement, String selectXPathExpression) throws JRException {
        super((Document)null);
        if (log.isDebugEnabled()) {
            log.debug("Creating DataSource for ROOT element: " + reportElement);
            log.debug("Creating DataSource for expression: " + selectXPathExpression);
        }
        this.root = reportElement;
        this.xPathExpression = selectXPathExpression;
        this.moveFirst();
    }

    public void moveFirst() throws JRException {
        this.debug("moveFirst-START");
        this.nodes = this.updateNodes(this.xPathExpression);
        this.currentIndex = -1;
        this.current = null;
        this.debug("moveFirst-END");
    }

    @Override
    public boolean next() {
        this.debug("next-INIT");
        if (log.isDebugEnabled()) {
            log.debug("CurrentNode: " + this.current);
            log.debug("CurrentNodeIndex: " + this.currentIndex);
        }
        int nodeListLength = this.nodes.size();
        if (log.isDebugEnabled()) {
            log.debug("NodeListLength: " + nodeListLength);
        }
        int max = nodeListLength - 1;
        if (log.isDebugEnabled()) {
            log.debug("Max: " + max);
        }
        if (this.currentIndex == max) {
            if (log.isDebugEnabled()) {
                log.debug("Just reached node limit. No more nodes to move next!");
            }
            return false;
        }
        ++this.currentIndex;
        if (log.isDebugEnabled()) {
            log.debug("CurrentNodeIndex updated: " + this.currentIndex);
        }
        this.current = this.nodes.get(this.currentIndex);
        this.debug("next-END");
        return true;
    }

    protected List<MidasReportElement> updateNodes(String xPathExpression) {
        return XPathWalker.nodes(this.root, xPathExpression, true);
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        this.debug("GetFieldValue-START: " + jrField);
        MidasReportElement currentNode = this.getCurrent();
        return this.getFieldValueConverted(jrField, currentNode);
    }

    protected Object getFieldValueConverted(JRField jrField, MidasReportElement currentNode) {
        Object fieldValueForNode = this.getFieldValueForNode(jrField, currentNode);
        if (fieldValueForNode == null) {
            return null;
        }
        Class valueClass = jrField.getValueClass();
        if (valueClass != null && !String.class.getName().equals(valueClass.getName())) {
            fieldValueForNode = ConvertUtils.convert((Object)fieldValueForNode, (Class)valueClass);
        }
        return fieldValueForNode;
    }

    private Object getFieldValueForNode(JRField jrField, MidasReportElement currentNode) {
        String fieldDescription = jrField.getDescription();
        if (log.isDebugEnabled()) {
            this.debug("getFieldValue -> " + fieldDescription);
        }
        if (StringUtils.isEmpty((String)fieldDescription)) {
            return null;
        }
        if (this.getCurrent() == null) {
            return null;
        }
        MidasReportElement nodeToInspect = this.getCurrent();
        boolean rootRequest = StringUtils.contains((String)fieldDescription, (String)this.getRoot().getName());
        if (rootRequest) {
            nodeToInspect = this.getRoot();
        }
        List<String> tokens = XPathWalker.getTokensForXPath(fieldDescription);
        List<MidasReportElement> reportElements = XPathWalker.nodes(nodeToInspect, fieldDescription);
        if (reportElements.isEmpty()) {
            return null;
        }
        if (reportElements.get(0).getName().equals(tokens.get(tokens.size() - 1))) {
            String value = reportElements.get(0).getValue();
            return value;
        }
        return null;
    }

    @Override
    public JRXmlDataSource subDataSource(String selectExpr) throws JRException {
        this.debug("subDataSource");
        if (log.isDebugEnabled()) {
            log.debug("Getting subDataSource for expression: [" + selectExpr + "]");
        }
        if (this.getCurrent() == null) {
            throw new JRException("No node available. Iterate or rewind the data source.");
        }
        MidasReportElement currentNode = this.getCurrent();
        BackedJRXmlDataSource subDataSource = null;
        try {
            subDataSource = new BackedJRXmlDataSource(currentNode, selectExpr);
        }
        catch (JRException e) {
            log.error(e.toString(), (Throwable)e);
        }
        subDataSource.setTextAttributes((JRAbstractTextDataSource)this);
        return subDataSource;
    }

    protected void debug(String source) {
        if (log.isDebugEnabled()) {
            log.debug("INIT - DEBUGING [" + this.getClass().getSimpleName() + "." + source + "]....");
            log.debug(this.toString());
            log.debug("END - DEBUGING [" + this.getClass().getSimpleName() + "." + source + "]....");
        }
    }

    @Override
    public JRXmlDataSource subDataSource() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Document subDocument() {
        throw new UnsupportedOperationException();
    }

    public String getText(Node node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRXmlDataSource dataSource() throws JRException {
        return this.dataSource(".");
    }

    @Override
    public JRXmlDataSource dataSource(String selectExpr) throws JRException {
        JRXmlDataSource subDataSource = new JRXmlDataSource(this.getRoot(), selectExpr);
        subDataSource.setTextAttributes((JRAbstractTextDataSource)this);
        return subDataSource;
    }

    public List<MidasReportElement> getNodes() {
        return this.nodes;
    }

    public MidasReportElement getCurrent() {
        return this.current;
    }

    public String toString() {
        String rootName = "NO_ROOT";
        if (this.root != null) {
            rootName = this.root.getName();
        }
        String ret = "\n{DataSource:\n rootName: " + rootName + ", \n xPathExpression: " + this.xPathExpression + ", \n current: " + this.current + ",\n currentIndex: " + this.currentIndex + "\n nodes: " + this.getNodes() + "\n childNodesLength: " + (this.getNodes() == null ? 0 : this.getNodes().size()) + "}";
        return ret;
    }

    public MidasReportElement getRoot() {
        return this.root;
    }

    protected String getXPathExpression() {
        return this.xPathExpression;
    }

    @Override
    public String getCurrentNodeName() {
        if (this.getCurrent() == null) {
            return null;
        }
        return this.getCurrent().getName();
    }
}

