/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.jasperreports;

import br.gov.serpro.midas.jasperreports.XPathPredicate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathUtil {
    private static final String SELECTOR_END = "\\]";
    private static final String SELECTOR_START = "\\[";
    private static final String RECORD_NUMBER_REGEX = "(.+)(\\[)(\\d+)(\\])";
    public static Pattern recordNumberPredicatePattern = Pattern.compile("(.+)(\\[)(\\d+)(\\])");
    public static final String NON_CAPTURING_GROUP_START = "(?:";
    public static final String ALFA_CHAR = ".";
    public static final String ONE_OR_MORE = "+";
    public static final String OPTIONAL = "?";
    public static final String GROUP_START = "(";
    public static final String GROUP_END = ")";
    private static final String SELECTOR_GROUP_CLASS = "[^\\]]";
    private static final String SELECTOR_EXPRESSION = "\\[[^\\]]+\\]";
    private static final String GROUP2 = "\\[[^\\]]+\\]";
    private static final String SELECTOR_REGEX = "\\[[^\\]]+\\]";
    public static Pattern selectorPredicatePattern = Pattern.compile("\\[[^\\]]+\\]");
    private static Logger log = LoggerFactory.getLogger(XPathUtil.class);

    public static List<XPathPredicate> getXPathPredicate(String token) {
        if (log.isDebugEnabled()) {
            log.debug("Token: " + token);
            log.debug("SelectorRegEx: \\[[^\\]]+\\]");
        }
        ArrayList<XPathPredicate> ret = new ArrayList<XPathPredicate>();
        Matcher recordNumberMatcher = recordNumberPredicatePattern.matcher(token);
        if (log.isDebugEnabled()) {
            log.debug("RecourdNumberMatcher.Group count: " + recordNumberMatcher.groupCount());
        }
        if (recordNumberMatcher.matches()) {
            String group3 = recordNumberMatcher.group(3);
            if (log.isDebugEnabled()) {
                log.debug("RecordNumber group: " + group3);
            }
            XPathPredicate predicate = new XPathPredicate("", group3);
            predicate.setGroup("[" + group3 + "]");
            predicate.selector = false;
            ret.add(predicate);
            return ret;
        }
        log.debug("Not a number.");
        Matcher selectorMatcher = selectorPredicatePattern.matcher(token);
        while (selectorMatcher.find()) {
            String group = selectorMatcher.group();
            if (log.isDebugEnabled()) {
                log.debug("SelectorMatcher group: " + group);
            }
            XPathPredicate predicate = new XPathPredicate(group);
            predicate.selector = true;
            ret.add(predicate);
        }
        return ret;
    }

    public static String getTokenWithoutXPathPredicates(String token) {
        List<XPathPredicate> predicates = XPathUtil.getXPathPredicate(token);
        if (log.isDebugEnabled()) {
            log.debug("CurrentToken: " + token);
            log.debug("All predicates: " + predicates);
        }
        if (predicates != null && predicates.size() > 0) {
            if (predicates.size() == 1 && !predicates.get((int)0).selector) {
                token = StringUtils.replace((String)token, (String)predicates.get(0).getGroup(), (String)"");
            } else if (predicates.size() > 0 && predicates.get((int)0).selector) {
                for (XPathPredicate predicate : predicates) {
                    if (log.isDebugEnabled()) {
                        log.debug("Current predicate: " + predicate + ", originalGroup: " + predicate.getOriginalGroup());
                        log.debug("Token before removing predicate: " + token);
                    }
                    token = StringUtils.replace((String)token, (String)predicate.getOriginalGroup(), (String)"");
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Token after group removal: " + token);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("NO predicates for this token: " + token);
        }
        if (log.isDebugEnabled()) {
            log.debug("Predicates for Token [" + token + "] processed!");
        }
        return token;
    }
}

