/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.negocio;

import br.gov.serpro.midas.negocio.MidasReportElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MidasReportElementParent
implements MidasReportElement {
    Logger log = LoggerFactory.getLogger(this.getClass());
    List<String> keys = new ArrayList<String>();
    List<MidasReportElement> values = new ArrayList<MidasReportElement>();
    MidasReportElement parent;
    String name;
    String value;

    public MidasReportElementParent(String name, String value, MidasReportElement parent) {
        if (name == null) {
            throw new IllegalArgumentException("The report element name can't be null");
        }
        this.name = name;
        this.value = value;
        this.parent = parent;
    }

    @Override
    public Collection getChildren() {
        return new ArrayList<MidasReportElement>(this.values);
    }

    @Override
    public void add(MidasReportElement child) {
        this.keys.add(child.getName());
        this.values.add(child);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public List get(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("The name must be specified.");
        }
        if (name.equals(this.getName())) {
            return Arrays.asList(this);
        }
        if (name.equals(".")) {
            return this.getAll();
        }
        if (!this.keys.contains(name)) {
            return Collections.emptyList();
        }
        ArrayList<MidasReportElement> children = new ArrayList<MidasReportElement>();
        for (int i = 0; i < this.keys.size(); ++i) {
            if (!this.keys.get(i).equals(name)) continue;
            children.add(this.values.get(i));
        }
        return children;
    }

    public List get(String name, final String value) {
        List children = this.get(name);
        CollectionUtils.filter((Collection)children, (Predicate)new Predicate(){

            public boolean evaluate(Object child) {
                return ((MidasReportElement)child).getValue().equals(value);
            }
        });
        return children;
    }

    @Override
    public List<MidasReportElement> getAll() {
        return (List)this.getChildren();
    }

    @Override
    public MidasReportElement parent() {
        return this.parent;
    }

    public String toString() {
        return "MidasReportElementParent [name=" + this.name + ", value=" + this.value + ", childrenCount:" + this.values.size() + "]";
    }
}

