/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.barcodedesigners;

import serpro.ppgd.formatosexternos.barcodedesigners.AbstractBarCode2D;
import serpro.ppgd.formatosexternos.barcodedesigners.BarCode2DRendererIf;
import serpro.ppgd.formatosexternos.barcodedesigners.DefaultBarCode2DRenderer;

public class Interleaved2of5
extends AbstractBarCode2D {
    private static final String startPattern = "NNNN";
    private static final String stopPattern = "WNN";
    private static final String[] I25Pattern = new String[]{"NNWWN", "WNNNW", "NWNNW", "WWNNN", "NNWNW", "WNWNN", "NWWNN", "NNNWW", "WNNWN", "NWNWN"};
    private BarCode2DRendererIf internalRenderer;

    public Interleaved2of5() {
        this.internalRenderer = new DefaultBarCode2DRenderer();
    }

    public Interleaved2of5(String s) {
        this.value = s;
        this.pattern = this.encodeValue(s);
        this.internalRenderer = new DefaultBarCode2DRenderer(this.pattern);
    }

    @Override
    public void setValue(String s) {
        this.value = s;
        this.pattern = this.encodeValue(s);
        if (this.internalRenderer != null) {
            this.internalRenderer.setPattern(this.pattern);
        }
    }

    @Override
    public BarCode2DRendererIf getRenderer() {
        return this.internalRenderer;
    }

    @Override
    public void setRenderer(BarCode2DRendererIf r) {
        this.internalRenderer = r;
    }

    private String encodeValue(String s) {
        if (s.length() == 0 || s.length() % 2 != 0) {
            return "";
        }
        char[] c = s.toCharArray();
        StringBuilder encoded = new StringBuilder();
        if (this.autoQuietZones) {
            encoded.append("!");
        }
        if (this.autoStartStopMarks) {
            encoded.append(startPattern);
        }
        for (int i = 0; i < c.length; i += 2) {
            if (!Character.isDigit(c[i]) || !Character.isDigit(c[i + 1])) {
                return "";
            }
            String d1 = I25Pattern[c[i] - 48];
            String d2 = I25Pattern[c[i + 1] - 48];
            for (int n = 0; n <= 4; ++n) {
                encoded.append(d1.charAt(n));
                encoded.append(d2.charAt(n));
            }
        }
        if (this.autoStartStopMarks) {
            encoded.append(stopPattern);
        }
        if (this.autoQuietZones) {
            encoded.append("!");
        }
        return encoded.toString();
    }
}

