/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.repositorio;

import java.util.List;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.IdUsuario;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.usuariodefault.IdDeclaracaoDefault;
import serpro.ppgd.negocio.usuariodefault.UsuarioIdDefault;
import serpro.ppgd.repositorio.RepositorioException;
import serpro.ppgd.repositorio.RepositorioIdDeclaracaoIf;
import serpro.ppgd.repositorio.RepositorioIdIf;
import serpro.ppgd.repositorio.RepositorioObjetoNegocioIf;

public class CadastroId {
    protected RepositorioIdIf repId;
    protected RepositorioIdDeclaracaoIf repIdDeclaracao;
    protected RepositorioObjetoNegocioIf repDeclaracao;
    protected IdDeclaracao ultimoIdDeclaracaoRecuperado;

    public CadastroId(RepositorioIdIf repId, RepositorioIdDeclaracaoIf repIdDeclaracao, RepositorioObjetoNegocioIf repDeclaracao) {
        this.repId = repId;
        this.repIdDeclaracao = repIdDeclaracao;
        this.repDeclaracao = repDeclaracao;
        this.recuperarIdDeclaracoes();
    }

    public List<IdUsuario> recuperarIds() {
        return this.repId.recuperarIds();
    }

    public IdUsuario recuperarId(IdUsuario pId) {
        return this.repId.recuperarId(pId);
    }

    public IdUsuario criarId(IdUsuario pId) throws RepositorioException {
        return this.repId.criarId(pId);
    }

    public IdUsuario criarIdNaoPersistido(String cpf) {
        return this.repId.criarIdNaoPersistido(cpf);
    }

    public List<IdDeclaracao> recuperarIdDeclaracoes() {
        return this.repIdDeclaracao.recuperarIdDeclaracoes(this.repId.recuperarIds());
    }

    public boolean existeIdDeclaracao(IdDeclaracao idDeclaracao) {
        return this.repIdDeclaracao.existeIdDeclaracao(idDeclaracao);
    }

    public IdDeclaracao retornaIdDeclaracaoPersistido(IdDeclaracao idDeclaracao) {
        return this.repIdDeclaracao.retornaIdDeclaracaoPersistido(idDeclaracao);
    }

    public IdDeclaracao criarIdDeclaracao(IdUsuario id) throws RepositorioException {
        IdDeclaracao idDeclaracao;
        this.ultimoIdDeclaracaoRecuperado = idDeclaracao = this.repIdDeclaracao.criarIdDeclaracao(id);
        this.repDeclaracao.criar(idDeclaracao);
        this.repDeclaracao.salvar(idDeclaracao);
        return idDeclaracao;
    }

    public IdDeclaracao criarIdDeclaracao(IdDeclaracao idDec) throws RepositorioException {
        this.ultimoIdDeclaracaoRecuperado = this.repIdDeclaracao.criarIdDeclaracao(idDec);
        this.repDeclaracao.criar(idDec);
        this.repDeclaracao.salvar(idDec);
        return idDec;
    }

    public IdDeclaracao criarIdDeclaracaoNaoPersistido(IdUsuario id) {
        this.ultimoIdDeclaracaoRecuperado = this.repIdDeclaracao.criarIdDeclaracaoNaoPersistido(id);
        return this.ultimoIdDeclaracaoRecuperado;
    }

    public void removerIdDeclaracao(IdDeclaracao idDeclaracao) throws RepositorioException {
        this.repDeclaracao.deletar(idDeclaracao);
        this.repIdDeclaracao.removerIdDeclaracao(idDeclaracao);
        if (this.ultimoIdDeclaracaoRecuperado != null && idDeclaracao.equals((Object)this.ultimoIdDeclaracaoRecuperado)) {
            this.ultimoIdDeclaracaoRecuperado = null;
        }
    }

    public void salvarIdDeclaracao(IdDeclaracao idDeclaracao) throws RepositorioException {
        IdUsuario id = this.repId.recuperarId(idDeclaracao.getId());
        this.repId.salvar(id);
        IdDeclaracao idDec = this.repIdDeclaracao.retornaIdDeclaracaoPersistido(idDeclaracao);
        this.repIdDeclaracao.salvar(idDec);
        this.repDeclaracao.salvar(idDec);
    }

    public ObjetoNegocio recuperarDeclaracao(IdDeclaracao idDeclaracao) throws RepositorioException {
        this.ultimoIdDeclaracaoRecuperado = this.repIdDeclaracao.retornaIdDeclaracaoPersistido(idDeclaracao);
        ObjetoNegocio retorno = this.repDeclaracao.recuperar(this.ultimoIdDeclaracaoRecuperado);
        return retorno;
    }

    public ObjetoNegocio getUltimaDeclaracaoAberta() throws RepositorioException {
        if (this.ultimoIdDeclaracaoRecuperado == null) {
            throw new RepositorioException("Ainda n\u00e3o foi aberta nenhuma declara\u00e7\u00e3o.");
        }
        return this.repDeclaracao.recuperar(this.ultimoIdDeclaracaoRecuperado);
    }

    public void salvarUltimaDeclaracaoAberta() throws RepositorioException {
        if (this.ultimoIdDeclaracaoRecuperado != null) {
            this.salvarIdDeclaracao(this.ultimoIdDeclaracaoRecuperado);
        }
    }

    public IdDeclaracao recuperarIdDeclaracao(IdDeclaracao idDeclaracao) throws RepositorioException {
        return this.repIdDeclaracao.retornaIdDeclaracaoPersistido(idDeclaracao);
    }

    public void fecharUltimaDeclaracaoAberta() throws RepositorioException {
        this.salvarUltimaDeclaracaoAberta();
        this.ultimoIdDeclaracaoRecuperado = null;
    }

    public RepositorioIdIf getRepId() {
        return this.repId;
    }

    public RepositorioIdDeclaracaoIf getRepIdDeclaracao() {
        return this.repIdDeclaracao;
    }

    public IdDeclaracao getUltimoIdDeclaracaoRecuperado() {
        return this.ultimoIdDeclaracaoRecuperado;
    }

    public ObjetoNegocio getObjetoNegocioDefault() throws RepositorioException {
        UsuarioIdDefault usuarioDefault = new UsuarioIdDefault();
        try {
            this.repId.criarId((IdUsuario)usuarioDefault);
        }
        catch (RepositorioException e) {
            usuarioDefault = (UsuarioIdDefault)this.repId.recuperarId((IdUsuario)usuarioDefault);
        }
        IdDeclaracaoDefault idDeclaracaoDefault = new IdDeclaracaoDefault(usuarioDefault);
        if (!this.existeIdDeclaracao((IdDeclaracao)idDeclaracaoDefault)) {
            this.criarIdDeclaracao((IdDeclaracao)idDeclaracaoDefault);
            this.salvarIdDeclaracao((IdDeclaracao)idDeclaracaoDefault);
        }
        return this.recuperarDeclaracao((IdDeclaracao)idDeclaracaoDefault);
    }

    public void resetObjetoNegocioDefault() {
        UsuarioIdDefault usuarioDefault = new UsuarioIdDefault();
        try {
            this.repId.criarId((IdUsuario)usuarioDefault);
        }
        catch (RepositorioException e) {
            usuarioDefault = (UsuarioIdDefault)this.repId.recuperarId((IdUsuario)usuarioDefault);
        }
        try {
            IdDeclaracaoDefault idDeclaracaoDefault = new IdDeclaracaoDefault(usuarioDefault);
            if (this.existeIdDeclaracao((IdDeclaracao)idDeclaracaoDefault)) {
                this.removerIdDeclaracao((IdDeclaracao)idDeclaracaoDefault);
            }
        }
        catch (RepositorioException repositorioException) {
            // empty catch block
        }
    }

    public void descarregarDeclaracao(IdDeclaracao idDeclaracao) {
        try {
            this.repDeclaracao.descarregar(idDeclaracao);
        }
        catch (RepositorioException repositorioException) {
            // empty catch block
        }
    }
}

