/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.export.parameters;

import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.export.XmlExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersWriterExporterOutput;

public class ParametersXmlExporterOutput
extends ParametersWriterExporterOutput
implements XmlExporterOutput {
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static final String XML_FILES_SUFFIX = "_files";
    private Boolean isEmbeddingImages = Boolean.TRUE;
    private File imagesDir;

    public ParametersXmlExporterOutput(JasperReportsContext jasperReportsContext, Map<JRExporterParameter, Object> parameters, JasperPrint jasperPrint) {
        super(jasperReportsContext, parameters, jasperPrint);
        OutputStream os;
        Writer writer;
        StringBuffer sb = (StringBuffer)parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER);
        if (sb == null && (writer = (Writer)parameters.get(JRExporterParameter.OUTPUT_WRITER)) == null && (os = (OutputStream)parameters.get(JRExporterParameter.OUTPUT_STREAM)) == null) {
            File destFile = (File)parameters.get(JRExporterParameter.OUTPUT_FILE);
            if (destFile == null) {
                String fileName = (String)parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                if (fileName != null) {
                    destFile = new File(fileName);
                } else {
                    throw new JRRuntimeException("No output specified for the exporter.");
                }
            }
            this.imagesDir = new File(destFile.getParent(), String.valueOf(destFile.getName()) + XML_FILES_SUFFIX);
            Boolean isEmbeddingImagesParameter = (Boolean)parameters.get(JRXmlExporterParameter.IS_EMBEDDING_IMAGES);
            if (isEmbeddingImagesParameter == null) {
                isEmbeddingImagesParameter = Boolean.TRUE;
            }
            this.isEmbeddingImages = (boolean)isEmbeddingImagesParameter;
        }
    }

    @Override
    protected void setEncoding() {
        this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
        if (this.encoding == null) {
            this.encoding = DEFAULT_XML_ENCODING;
        }
    }

    @Override
    public Boolean isEmbeddingImages() {
        return this.isEmbeddingImages;
    }

    public File getImagesDir() {
        return this.imagesDir;
    }
}

