/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.sqladaj;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SQLAdaErrorEnum {
    SSA600(0, "SSA600", "RESERVADO"),
    SSA601(-1, "SSA601", "ERRO NO ENVIO DA MENSAGEM"),
    SSA602(-2, "SSA602", "ERRO NO RECEBIMENTO DA MENSAGEM"),
    SSA603(-3, "SSA603", "ESTACAO SEM CONECTIVIDADE"),
    SSA604(-4, "SSA604", "IDENTIFICACAO DO SERVIDOR INVALIDA"),
    SSA605(-5, "SSA605", "EXCESSO DE CONEXOES TCP/IP"),
    SSA606(-6, "SSA606", "TAMANHO DO COMANDO EXCEDIDO"),
    SSA607(-7, "SSA607", "FALHA NA CONEXAO"),
    SSA608(-8, "SSA608", "SERVIDOR SQLADA INATIVO"),
    SSA609(-9, "SSA609", "SEQUENCIA DE ATUALIZACOES SEM COMMIT"),
    SSA610(-10, "SSA610", "NAO HA REGISTROS SELECIONADOS PARA LEITURA"),
    SSA611(-11, "SSA611", "REGISTRO INVALIDO"),
    SSA612(-12, "SSA612", "COMANDO INVALIDO"),
    SSA613(-13, "SSA613", "CONEXAO NAO INICIALIZADA"),
    SSA614(-14, "SSA614", "PARAMETROS INVALIDOS"),
    SSA615(-15, "SSA615", "MEMORIA INSUFICIENTE"),
    SSA616(-16, "SSA616", "EXCECAO INTERNA IDENTIFICADA"),
    SSA930(-930, "SSA930", "ROTINA INVALIDA OU INEXISTENTE.EXEC"),
    SSASERVER(0, "", "");

    private int returnCode;
    private String codigo;
    private String mensagem;

    private SQLAdaErrorEnum(int returnCode, String codigo, String mensagem) {
        this.returnCode = returnCode;
        this.codigo = codigo;
        this.mensagem = mensagem;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public static SQLAdaErrorEnum generateSSASERVER(int returnCode, String mensagem) {
        SQLAdaErrorEnum ssaserver = SSASERVER;
        ssaserver.mensagem = mensagem;
        ssaserver.returnCode = returnCode;
        ssaserver.codigo = "SSA" + returnCode * -1;
        return ssaserver;
    }

    public String toString() {
        return this.getCodigo() + " - " + this.getMensagem();
    }
}

