/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.styles.BalloonTipStyle;

public class CustomBalloonTip
extends BalloonTip {
    private Rectangle offset = null;
    private MouseAdapter mouseListener = new MouseAdapter(){

        public void mouseReleased(MouseEvent e) {
            CustomBalloonTip.this.setOffset(CustomBalloonTip.this.offset);
        }
    };
    private KeyAdapter keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            CustomBalloonTip.this.setOffset(CustomBalloonTip.this.offset);
        }
    };
    private static final long serialVersionUID = 2956673369456562797L;

    public CustomBalloonTip(JComponent attachedComponent, JComponent component, Rectangle offset, BalloonTipStyle style, BalloonTip.Orientation orientation, BalloonTip.AttachLocation attachLocation, int horizontalOffset, int verticalOffset, boolean useCloseButton) {
        this.offset = offset;
        this.setup(attachedComponent, component, style, this.setupPositioner(orientation, attachLocation, horizontalOffset, verticalOffset), useCloseButton ? CustomBalloonTip.getDefaultCloseButton() : null);
        this.setup();
    }

    public CustomBalloonTip(JComponent attachedComponent, JComponent component, Rectangle offset, BalloonTipStyle style, BalloonTipPositioner positioner, JButton closeButton) {
        this.offset = offset;
        this.setup(attachedComponent, component, style, positioner, closeButton);
        this.setup();
    }

    public void setOffset(Rectangle offset) {
        this.offset = offset;
        this.notifyViewportListener();
        this.refreshLocation();
        this.visibilityControl.setCriterionAndUpdate("refresh", false);
        this.visibilityControl.setCriterionAndUpdate("refresh", true);
    }

    public Rectangle getOffset() {
        return this.offset;
    }

    public Rectangle getAttachedRectangle() {
        Point location = SwingUtilities.convertPoint(this.attachedComponent, this.getLocation(), this);
        return new Rectangle(location.x + this.offset.x, location.y + this.offset.y, this.offset.width, this.offset.height);
    }

    public void closeBalloon() {
        this.attachedComponent.removeMouseListener(this.mouseListener);
        this.attachedComponent.removeKeyListener(this.keyListener);
        super.closeBalloon();
    }

    private void setup() {
        this.attachedComponent.addMouseListener(this.mouseListener);
        this.attachedComponent.addKeyListener(this.keyListener);
    }
}

