/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.dividas.Divida;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosDividas
extends Observador {
    private Dividas dividas = null;

    public CalculosDividas(Dividas dividas) {
        this.dividas = dividas;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                ((Divida)valorNovo).getValorExercicioAtual().addObservador((Observador)this);
                ((Divida)valorNovo).getValorExercicioAnterior().addObservador((Observador)this);
                ((Divida)valorNovo).getValorPgtoAnual().addObservador((Observador)this);
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                ((Divida)valorNovo).getValorExercicioAtual().removeObservador((Observador)this);
                ((Divida)valorNovo).getValorExercicioAnterior().removeObservador((Observador)this);
                ((Divida)valorNovo).getValorPgtoAnual().removeObservador((Observador)this);
            }
        }
        this.calculaTotalExercicioAtual();
        this.calculaTotalExercicioAnterior();
        this.calculaTotalPgtoAnual();
    }

    private void calculaTotalExercicioAtual() {
        Valor total = new Valor();
        for (Divida divida : this.dividas.itens()) {
            total.append('+', divida.getValorExercicioAtual());
        }
        this.dividas.getTotalExercicioAtual().setConteudo(total);
    }

    private void calculaTotalExercicioAnterior() {
        Valor total = new Valor();
        for (Divida divida : this.dividas.itens()) {
            total.append('+', divida.getValorExercicioAnterior());
        }
        this.dividas.getTotalExercicioAnterior().setConteudo(total);
    }

    private void calculaTotalPgtoAnual() {
        Valor total = new Valor();
        for (Divida divida : this.dividas.itens()) {
            total.append('+', divida.getValorPgtoAnual());
        }
        this.dividas.getTotalPgtoAnual().setConteudo(total);
    }
}

