/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import java.util.Map;
import serpro.ppgd.irpf.gcap.entidades.ValorBigDecimalGCAP;
import serpro.ppgd.irpf.gcap.entidades.ValorPositivoGCAP;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendAcmImpostoDevido
extends Observador {
    private RendAcmTitular rendAcm = null;

    public CalculosRendAcmImpostoDevido(RendAcmTitular rendAcm) {
        this.rendAcm = rendAcm;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (this.rendAcm.getOpcaoTributacao().naoFormatado().equals("E")) {
            Integer mesRecebimento = 1;
            try {
                mesRecebimento = Integer.valueOf(this.rendAcm.getMesRecebimento().getConteudoAtual(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Map tabelaProgressiva = TabelaAliquotasIRPF.obterTabelaProgressivaRRA((Integer)mesRecebimento);
            String limiteMensalFaixa1 = (String)tabelaProgressiva.get("valorAjusteLimiteMEFaixa1");
            String limiteMensalFaixa2 = (String)tabelaProgressiva.get("valorAjusteLimiteMEFaixa2");
            String limiteMensalFaixa3 = (String)tabelaProgressiva.get("valorAjusteLimiteMEFaixa3");
            String limiteMensalFaixa4 = (String)tabelaProgressiva.get("valorAjusteLimiteMEFaixa4");
            ValorPositivoGCAP numMeses = new ValorPositivoGCAP(this.rendAcm.getNumMeses().naoFormatado());
            String descontoFaixa1 = (String)tabelaProgressiva.get("valorAjusteLimiteRRAFaixa1");
            String descontoFaixa2 = (String)tabelaProgressiva.get("valorAjusteLimiteRRAFaixa2");
            String descontoFaixa3 = (String)tabelaProgressiva.get("valorAjusteLimiteRRAFaixa3");
            String descontoFaixa4 = (String)tabelaProgressiva.get("valorAjusteLimiteRRAFaixa4");
            ValorPositivoGCAP valorDescontoFaixa1 = new ValorPositivoGCAP();
            valorDescontoFaixa1.converteQtdCasasDecimais(6);
            valorDescontoFaixa1.setConteudo(descontoFaixa1);
            valorDescontoFaixa1.append('*', (ValorBigDecimalGCAP)numMeses);
            ValorPositivoGCAP valorDescontoFaixa2 = new ValorPositivoGCAP();
            valorDescontoFaixa2.converteQtdCasasDecimais(6);
            valorDescontoFaixa2.setConteudo(descontoFaixa2);
            valorDescontoFaixa2.append('*', (ValorBigDecimalGCAP)numMeses);
            ValorPositivoGCAP valorDescontoFaixa3 = new ValorPositivoGCAP();
            valorDescontoFaixa3.converteQtdCasasDecimais(6);
            valorDescontoFaixa3.setConteudo(descontoFaixa3);
            valorDescontoFaixa3.append('*', (ValorBigDecimalGCAP)numMeses);
            ValorPositivoGCAP valorDescontoFaixa4 = new ValorPositivoGCAP();
            valorDescontoFaixa4.converteQtdCasasDecimais(6);
            valorDescontoFaixa4.setConteudo(descontoFaixa4);
            valorDescontoFaixa4.append('*', (ValorBigDecimalGCAP)numMeses);
            ValorPositivoGCAP baseCalculo = new ValorPositivoGCAP();
            baseCalculo.setConteudo(this.rendAcm.getRendRecebidos().formatado());
            baseCalculo.append('-', this.rendAcm.getContribuicaoPrevOficial().formatado());
            baseCalculo.append('-', this.rendAcm.getPensaoAlimenticia().formatado());
            ValorPositivoGCAP limite1 = new ValorPositivoGCAP();
            limite1.converteQtdCasasDecimais(6);
            limite1.setConteudo(limiteMensalFaixa1);
            limite1.append('*', (ValorBigDecimalGCAP)numMeses);
            ValorPositivoGCAP limite2 = new ValorPositivoGCAP();
            limite2.converteQtdCasasDecimais(6);
            limite2.setConteudo(limiteMensalFaixa2);
            limite2.append('*', (ValorBigDecimalGCAP)numMeses);
            ValorPositivoGCAP limite3 = new ValorPositivoGCAP();
            limite3.converteQtdCasasDecimais(6);
            limite3.setConteudo(limiteMensalFaixa3);
            limite3.append('*', (ValorBigDecimalGCAP)numMeses);
            ValorPositivoGCAP limite4 = new ValorPositivoGCAP();
            limite4.converteQtdCasasDecimais(6);
            limite4.setConteudo(limiteMensalFaixa4);
            limite4.append('*', (ValorBigDecimalGCAP)numMeses);
            ValorPositivoGCAP percentualFaixa1 = new ValorPositivoGCAP();
            percentualFaixa1.converteQtdCasasDecimais(6);
            percentualFaixa1.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa1.getValor().formatado());
            percentualFaixa1.append('/', "100,00");
            ValorPositivoGCAP percentualFaixa2 = new ValorPositivoGCAP();
            percentualFaixa2.converteQtdCasasDecimais(6);
            percentualFaixa2.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa2.getValor().formatado());
            percentualFaixa2.append('/', "100,00");
            ValorPositivoGCAP percentualFaixa3 = new ValorPositivoGCAP();
            percentualFaixa3.converteQtdCasasDecimais(6);
            percentualFaixa3.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa3.getValor().formatado());
            percentualFaixa3.append('/', "100,00");
            ValorPositivoGCAP percentualFaixa4 = new ValorPositivoGCAP();
            percentualFaixa4.converteQtdCasasDecimais(6);
            percentualFaixa4.setConteudo(TabelaAliquotasIRPF.ConstantesAliquotas.percentualFaixa4.getValor().formatado());
            percentualFaixa4.append('/', "100,00");
            ValorPositivoGCAP impostoRRA = new ValorPositivoGCAP(false);
            impostoRRA.setCasasDecimais(4);
            if (baseCalculo.comparacao("<=", (ValorBigDecimalGCAP)limite1)) {
                impostoRRA.setConteudo("0,00");
            } else if (baseCalculo.comparacao("<=", (ValorBigDecimalGCAP)limite2)) {
                impostoRRA.setConteudo((ValorBigDecimalGCAP)baseCalculo);
                impostoRRA.append('*', (ValorBigDecimalGCAP)percentualFaixa1);
                impostoRRA.append('-', (ValorBigDecimalGCAP)valorDescontoFaixa1);
            } else if (baseCalculo.comparacao("<=", (ValorBigDecimalGCAP)limite3)) {
                impostoRRA.setConteudo((ValorBigDecimalGCAP)baseCalculo);
                impostoRRA.append('*', (ValorBigDecimalGCAP)percentualFaixa2);
                impostoRRA.append('-', (ValorBigDecimalGCAP)valorDescontoFaixa2);
            } else if (baseCalculo.comparacao("<=", (ValorBigDecimalGCAP)limite4)) {
                impostoRRA.setConteudo((ValorBigDecimalGCAP)baseCalculo);
                impostoRRA.append('*', (ValorBigDecimalGCAP)percentualFaixa3);
                impostoRRA.append('-', (ValorBigDecimalGCAP)valorDescontoFaixa3);
            } else {
                impostoRRA.setConteudo((ValorBigDecimalGCAP)baseCalculo);
                impostoRRA.append('*', (ValorBigDecimalGCAP)percentualFaixa4);
                impostoRRA.append('-', (ValorBigDecimalGCAP)valorDescontoFaixa4);
            }
            impostoRRA.converteQtdCasasDecimais(2, false);
            this.rendAcm.getImpostoDevidoRRA().setConteudo((Valor)impostoRRA);
        } else {
            this.rendAcm.getImpostoDevidoRRA().setConteudo(Long.valueOf(0L));
        }
    }
}

