/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmTitular;
import serpro.ppgd.irpf.rendacm.RendAcmTitular;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendAcmTitular
extends Observador {
    private ColecaoRendAcmTitular colecaoRendAcm = null;
    private DeclaracaoIRPF declaracaoIRPF;

    public CalculosRendAcmTitular(ColecaoRendAcmTitular colecao, DeclaracaoIRPF dec) {
        this.colecaoRendAcm = colecao;
        this.declaracaoIRPF = dec;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                RendAcmTitular rendPJ = (RendAcmTitular)valorNovo;
                rendPJ.addObservador((Observador)this);
                this.calculaTotaisRendRecebidos();
                this.calculaTotaisContribPrev();
                this.calculaTotaisPensaoAlimenticia();
                this.calculaTotaisImpostoRetido();
                this.calculaTotaisImpostoDevidoRRA();
                this.calculaTotaisJuros();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                RendAcmTitular rendPJ = (RendAcmTitular)valorNovo;
                rendPJ.removeObservador((Observador)this);
                this.calculaTotaisRendRecebidos();
                this.calculaTotaisContribPrev();
                this.calculaTotaisPensaoAlimenticia();
                this.calculaTotaisImpostoRetido();
                this.calculaTotaisImpostoDevidoRRA();
                this.calculaTotaisJuros();
            } else if (nomePropriedade.equals("Op\u00e7\u00e3o pela Forma de Tributa\u00e7\u00e3o")) {
                this.calculaTotaisRendRecebidos();
                this.calculaTotaisContribPrev();
                this.calculaTotaisPensaoAlimenticia();
                this.calculaTotaisImpostoRetido();
                this.calculaTotaisImpostoDevidoRRA();
            } else if (nomePropriedade.equals("Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial")) {
                this.calculaTotaisContribPrev();
                this.calculaTotaisRendRecebidos();
            } else if (nomePropriedade.equals("Pens\u00e3o Aliment\u00edcia")) {
                this.calculaTotaisPensaoAlimenticia();
                this.calculaTotaisRendRecebidos();
            } else if (nomePropriedade.equals("Imposto Retido na Fonte")) {
                this.calculaTotaisImpostoRetido();
                this.calculaTotaisRendRecebidos();
            } else if (nomePropriedade.equals("Rendimentos Tribut\u00e1veis")) {
                this.calculaTotaisRendRecebidos();
            } else if (nomePropriedade.equals("Rendimentos recebidos tribut\u00e1veis")) {
                this.calculaTotaisRendRecebidos();
            } else if (nomePropriedade.equals("Imposto Devido RRA")) {
                this.calculaTotaisImpostoDevidoRRA();
            } else if (nomePropriedade.equals("Valor recebido referente a juros")) {
                this.calculaTotaisJuros();
            }
        }
    }

    private void calculaTotaisImpostoRetido() {
        Valor total = new Valor();
        Valor totalAjuste = new Valor();
        Valor totalExclusiva = new Valor();
        for (RendAcmTitular rendAtual : this.colecaoRendAcm.itens()) {
            if ("A".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalAjuste.append('+', (Valor)rendAtual.getImpostoRetidoFonte());
            } else if ("E".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalExclusiva.append('+', (Valor)rendAtual.getImpostoRetidoFonte());
            }
            total.append('+', (Valor)rendAtual.getImpostoRetidoFonte());
        }
        this.colecaoRendAcm.getTotaisImpostoRetidoFonte().setConteudo(total);
        this.colecaoRendAcm.getTotaisImpostoRetidoFonteAjuste().setConteudo(totalAjuste);
        this.colecaoRendAcm.getTotaisImpostoRetidoFonteExclusiva().setConteudo(totalExclusiva);
    }

    private void calculaTotaisPensaoAlimenticia() {
        Valor total = new Valor();
        Valor totalAjuste = new Valor();
        Valor totalExclusiva = new Valor();
        for (RendAcmTitular rendAtual : this.colecaoRendAcm.itens()) {
            if ("A".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalAjuste.append('+', (Valor)rendAtual.getPensaoAlimenticia());
            } else if ("E".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalExclusiva.append('+', (Valor)rendAtual.getPensaoAlimenticia());
            }
            total.append('+', (Valor)rendAtual.getPensaoAlimenticia());
        }
        this.colecaoRendAcm.getTotaisPensaoAlimenticiaAjuste().setConteudo(totalAjuste);
        this.colecaoRendAcm.getTotaisPensaoAlimenticiaExclusiva().setConteudo(totalExclusiva);
        this.colecaoRendAcm.getTotaisPensaoAlimenticia().setConteudo(total);
    }

    private void calculaTotaisContribPrev() {
        Valor total = new Valor();
        Valor totalAjuste = new Valor();
        Valor totalExclusiva = new Valor();
        for (RendAcmTitular rendAtual : this.colecaoRendAcm.itens()) {
            if ("A".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalAjuste.append('+', (Valor)rendAtual.getContribuicaoPrevOficial());
            } else if ("E".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalExclusiva.append('+', (Valor)rendAtual.getContribuicaoPrevOficial());
            }
            total.append('+', (Valor)rendAtual.getContribuicaoPrevOficial());
        }
        this.colecaoRendAcm.getTotaisContribuicaoPrevOficial().setConteudo(total);
        this.colecaoRendAcm.getTotaisContribuicaoPrevOficialAjuste().setConteudo(totalAjuste);
        this.colecaoRendAcm.getTotaisContribuicaoPrevOficialExclusiva().setConteudo(totalExclusiva);
    }

    private void calculaTotaisRendRecebidos() {
        Valor total = new Valor();
        Valor totalAjuste = new Valor();
        Valor totalExclusiva = new Valor();
        Valor totalRraTitular = new Valor();
        for (RendAcmTitular rendAtual : this.colecaoRendAcm.itens()) {
            if ("A".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalAjuste.append('+', (Valor)rendAtual.getRendRecebidos());
            } else if ("E".equals(rendAtual.getOpcaoTributacao().naoFormatado())) {
                totalExclusiva.append('+', (Valor)rendAtual.getRendRecebidos());
                Valor totalRraTitularAux = new Valor();
                totalRraTitularAux.append('+', (Valor)rendAtual.getRendRecebidos());
                totalRraTitularAux.append('-', (Valor)rendAtual.getContribuicaoPrevOficial());
                totalRraTitularAux.append('-', (Valor)rendAtual.getPensaoAlimenticia());
                totalRraTitularAux.append('-', (Valor)rendAtual.getImpostoRetidoFonte());
                if (totalRraTitularAux.comparacao(">", "0,00")) {
                    totalRraTitular.append('+', totalRraTitularAux);
                }
            }
            total.append('+', (Valor)rendAtual.getRendRecebidos());
        }
        this.colecaoRendAcm.getTotaisRendRecebidos().setConteudo(total);
        this.colecaoRendAcm.getTotaisRendRecebidosAjuste().setConteudo(totalAjuste);
        this.colecaoRendAcm.getTotaisRendRecebidosExclusiva().setConteudo(totalExclusiva);
        this.declaracaoIRPF.getRendTributacaoExclusiva().getRraTitular().setConteudo(totalRraTitular);
    }

    private void calculaTotaisImpostoDevidoRRA() {
        Valor total = new Valor();
        for (RendAcmTitular rendAtual : this.colecaoRendAcm.itens()) {
            total.append('+', (Valor)rendAtual.getImpostoDevidoRRA());
        }
        this.colecaoRendAcm.getTotaisImpostoDevidoRRA().setConteudo(total);
    }

    private void calculaTotaisJuros() {
        Valor total = new Valor();
        for (RendAcmTitular rendAtual : this.colecaoRendAcm.itens()) {
            total.append('+', (Valor)rendAtual.getValorJuros());
        }
        this.colecaoRendAcm.getTotaisJuros().setConteudo(total);
    }
}

