/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import java.lang.ref.WeakReference;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosTotalRendRecebidosMaisExterior
extends Observador {
    private WeakReference<DeclaracaoIRPF> refDeclaracaoIRPF = null;

    public CalculosTotalRendRecebidosMaisExterior(DeclaracaoIRPF dec) {
        this.refDeclaracaoIRPF = new WeakReference<DeclaracaoIRPF>(dec);
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null && (nomePropriedade.equals("Totais Rend. Recebid") || nomePropriedade.equals("Totais Rend. Recebidos - Ajuste") || nomePropriedade.equals("Total Pessoa F\u00edsica") || nomePropriedade.equals("Total Exterior"))) {
            this.calculaTotalRendimentosTributaveis();
        }
    }

    private void calculaTotalRendimentosTributaveis() {
        DeclaracaoIRPF dec = (DeclaracaoIRPF)this.refDeclaracaoIRPF.get();
        Valor totalRendimentos = new Valor();
        Valor totalLimiteLivroCaixa = new Valor();
        totalRendimentos.append('+', dec.getColecaoRendPJTitular().getTotaisRendRecebidoPJ());
        totalRendimentos.append('+', dec.getColecaoRendPJDependente().getTotaisRendRecebidoPJ());
        totalRendimentos.append('+', dec.getColecaoRendAcmTitular().getTotaisRendRecebidosAjuste());
        totalRendimentos.append('+', dec.getColecaoRendAcmDependente().getTotaisRendRecebidosAjuste());
        totalRendimentos.append('+', dec.getRendPFTitular().getTotalPessoaFisica());
        totalRendimentos.append('+', dec.getRendPFTitular().getTotalAlugueis());
        totalRendimentos.append('+', dec.getRendPFTitular().getTotalOutros());
        totalRendimentos.append('+', dec.getRendPFTitular().getTotalExterior());
        totalRendimentos.append('+', dec.getRendPFDependente().getTotalPessoaFisica());
        totalRendimentos.append('+', dec.getRendPFDependente().getTotalAlugueis());
        totalRendimentos.append('+', dec.getRendPFDependente().getTotalOutros());
        totalRendimentos.append('+', dec.getRendPFDependente().getTotalExterior());
        totalLimiteLivroCaixa.append('+', dec.getColecaoRendPJTitular().getTotaisRendRecebidoPJ());
        totalLimiteLivroCaixa.append('+', dec.getColecaoRendPJDependente().getTotaisRendRecebidoPJ());
        totalLimiteLivroCaixa.append('+', dec.getColecaoRendAcmTitular().getTotaisRendRecebidosAjuste());
        totalLimiteLivroCaixa.append('+', dec.getColecaoRendAcmDependente().getTotaisRendRecebidosAjuste());
        totalLimiteLivroCaixa.append('+', dec.getRendPFTitular().getTotalPessoaFisica());
        totalLimiteLivroCaixa.append('+', dec.getRendPFTitular().getTotalExterior());
        totalLimiteLivroCaixa.append('+', dec.getRendPFDependente().getTotalPessoaFisica());
        totalLimiteLivroCaixa.append('+', dec.getRendPFDependente().getTotalExterior());
        if (dec.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel().comparacao(">", "0,00")) {
            totalRendimentos.append('+', (Valor)dec.getAtividadeRural().getBrasil().getApuracaoResultado().getResultadoTributavel());
        }
        if (dec.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel().comparacao(">", "0,00")) {
            totalRendimentos.append('+', (Valor)dec.getAtividadeRural().getExterior().getApuracaoResultado().getResultadoTributavel());
        }
        dec.getModelo().getTotalRendRecebidosMaisExterior().setConteudo(totalRendimentos);
        dec.getModelo().getTotalLimiteLivroCaixa().setConteudo(totalLimiteLivroCaixa);
        dec.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos().setConteudo(dec.getModelo().getTotalRendRecebidosMaisExterior());
    }
}

