/*
 * Decompiled with CFR 0.152.
 */
package ml.options;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import ml.options.OptionData;
import ml.options.OptionSet;

public class Options {
    private static final String CLASS = "Options";
    public static final String DEFAULT_SET = "DEFAULT_OPTION_SET";
    private HashMap<String, OptionSet> optionSets = new HashMap();
    private Prefix prefix = null;
    private Multiplicity defaultMultiplicity = null;
    private String[] arguments = null;
    private boolean ignoreUnmatched = false;
    private int defaultMinData = 0;
    private int defaultMaxData = 0;
    private StringBuffer checkErrors = null;

    public Options(String[] args, Prefix prefix, Multiplicity defaultMultiplicity, int defMinData, int defMaxData) {
        if (args == null) {
            throw new IllegalArgumentException("Options: args may not be null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("Options: prefix may not be null");
        }
        if (defaultMultiplicity == null) {
            throw new IllegalArgumentException("Options: defaultMultiplicity may not be null");
        }
        if (defMinData < 0) {
            throw new IllegalArgumentException("Options: defMinData must be >= 0");
        }
        if (defMaxData < defMinData) {
            throw new IllegalArgumentException("Options: defMaxData must be >= defMinData");
        }
        this.arguments = new String[args.length];
        int i = 0;
        for (String s : args) {
            this.arguments[i++] = s;
        }
        this.prefix = prefix;
        this.defaultMultiplicity = defaultMultiplicity;
        this.defaultMinData = defMinData;
        this.defaultMaxData = defMaxData;
    }

    public Options(String[] args, Prefix prefix, Multiplicity defaultMultiplicity, int data) {
        this(args, prefix, defaultMultiplicity, data, data);
    }

    public Options(String[] args, Prefix prefix, Multiplicity defaultMultiplicity) {
        this(args, prefix, defaultMultiplicity, 0, 0);
    }

    public Options(String[] args, Multiplicity defaultMultiplicity, int defMinData, int defMaxData) {
        this(args, Prefix.DASH, defaultMultiplicity, defMinData, defMaxData);
    }

    public Options(String[] args, Multiplicity defaultMultiplicity, int data) {
        this(args, Prefix.DASH, defaultMultiplicity, data, data);
    }

    public Options(String[] args, Multiplicity defaultMultiplicity) {
        this(args, Prefix.DASH, defaultMultiplicity, 0, 0);
    }

    public Options(String[] args) {
        this(args, Prefix.DASH, Multiplicity.ONCE);
    }

    public Options(String[] args, int data) {
        this(args, Prefix.DASH, Multiplicity.ONCE, data, data);
    }

    public Options(String[] args, int defMinData, int defMaxData) {
        this(args, Prefix.DASH, Multiplicity.ONCE, defMinData, defMaxData);
    }

    public Options(String[] args, Prefix prefix) {
        this(args, prefix, Multiplicity.ONCE, 0, 0);
    }

    public Options(String[] args, Prefix prefix, int data) {
        this(args, prefix, Multiplicity.ONCE, data, data);
    }

    public Options(String[] args, Prefix prefix, int defMinData, int defMaxData) {
        this(args, prefix, Multiplicity.ONCE, defMinData, defMaxData);
    }

    public OptionSet getMatchingSet() {
        return this.getMatchingSet(false, true);
    }

    public OptionSet getMatchingSet(boolean ignoreUnmatched, boolean requireDataLast) {
        for (String setName : this.optionSets.keySet()) {
            if (!this.check(setName, ignoreUnmatched, requireDataLast)) continue;
            return this.optionSets.get(setName);
        }
        return null;
    }

    public OptionSet addSet(String setName, int minData, int maxData) {
        if (setName == null) {
            throw new IllegalArgumentException("Options: setName may not be null");
        }
        if (this.optionSets.containsKey(setName)) {
            throw new IllegalArgumentException("Options: a set with the name " + setName + " has already been defined");
        }
        OptionSet os = new OptionSet(this.prefix, this.defaultMultiplicity, setName, minData, maxData);
        this.optionSets.put(setName, os);
        return os;
    }

    public OptionSet addSet(String setName, int data) {
        return this.addSet(setName, data, data);
    }

    public OptionSet addSet(String setName) {
        return this.addSet(setName, this.defaultMinData, this.defaultMaxData);
    }

    public OptionSet getSet(String setName) {
        return this.optionSets.get(setName);
    }

    public OptionSet getSet() {
        if (this.getSet(DEFAULT_SET) == null) {
            this.addSet(DEFAULT_SET, this.defaultMinData, this.defaultMaxData);
        }
        return this.getSet(DEFAULT_SET);
    }

    public String getCheckErrors() {
        return this.checkErrors.toString();
    }

    public boolean check() {
        return this.check(DEFAULT_SET, false, true);
    }

    public boolean check(boolean ignoreUnmatched, boolean requireDataLast) {
        return this.check(DEFAULT_SET, ignoreUnmatched, requireDataLast);
    }

    public boolean check(String setName) {
        return this.check(setName, false, true);
    }

    public boolean check(String setName, boolean ignoreUnmatched, boolean requireDataLast) {
        if (setName == null) {
            throw new IllegalArgumentException("Options: setName may not be null");
        }
        if (this.optionSets.get(setName) == null) {
            throw new IllegalArgumentException("Options: Unknown OptionSet: " + setName);
        }
        this.checkErrors = new StringBuffer();
        this.checkErrors.append("Checking set ");
        this.checkErrors.append(setName);
        this.checkErrors.append('\n');
        OptionSet set = this.optionSets.get(setName);
        ArrayList<OptionData> options = set.getOptionData();
        ArrayList<String> data = set.getData();
        ArrayList<String> unmatched = set.getUnmatched();
        if (options.size() == 0) {
            if (this.arguments.length == 0) {
                return true;
            }
            this.checkErrors.append("No options have been defined, nothing to check\n");
            return false;
        }
        if (this.arguments.length == 0) {
            return true;
        }
        int ipos = 0;
        int offset = 0;
        Matcher m = null;
        String value = null;
        String detail = null;
        String next = null;
        String key = null;
        String pre = Character.toString(this.prefix.getName());
        boolean add = true;
        boolean[] matched = new boolean[this.arguments.length];
        for (int i = 0; i < matched.length; ++i) {
            matched[i] = false;
        }
        block6: do {
            value = null;
            detail = null;
            offset = 0;
            add = true;
            key = this.arguments[ipos];
            for (OptionData optionData : options) {
                m = optionData.getPattern().matcher(key);
                if (!m.lookingAt()) continue;
                if (optionData.useValue()) {
                    if (optionData.useDetail()) {
                        detail = m.group(1);
                        offset = 2;
                    }
                    if (optionData.getSeparator() == Separator.BLANK) {
                        if (ipos + 1 == this.arguments.length) {
                            this.checkErrors.append("At end of arguments - no value found following argument ");
                            this.checkErrors.append(key);
                            this.checkErrors.append('\n');
                            add = false;
                        } else {
                            next = this.arguments[ipos + 1];
                            if (next.startsWith(pre)) {
                                this.checkErrors.append("No value found following argument ");
                                this.checkErrors.append(key);
                                this.checkErrors.append('\n');
                                add = false;
                            } else {
                                value = next;
                                matched[ipos++] = true;
                                matched[ipos] = true;
                            }
                        }
                    } else {
                        value = m.group(1 + offset);
                        matched[ipos] = true;
                    }
                } else {
                    matched[ipos] = true;
                }
                if (!add) continue block6;
                optionData.addResult(value, detail);
                continue block6;
            }
        } while (++ipos < this.arguments.length);
        int first = -1;
        for (int i = 0; i < matched.length; ++i) {
            if (matched[i]) continue;
            if (this.arguments[i].startsWith(pre)) {
                unmatched.add(this.arguments[i]);
                this.checkErrors.append("No matching option found for argument ");
                this.checkErrors.append(this.arguments[i]);
                this.checkErrors.append('\n');
                continue;
            }
            if (first < 0) {
                first = i;
            }
            data.add(this.arguments[i]);
        }
        boolean err = true;
        for (OptionData optionData : options) {
            key = optionData.getKey();
            err = false;
            switch (optionData.getMultiplicity()) {
                case ONCE: {
                    if (optionData.getResultCount() == 1) break;
                    err = true;
                    break;
                }
                case ONCE_OR_MORE: {
                    if (optionData.getResultCount() != 0) break;
                    err = true;
                    break;
                }
                case ZERO_OR_ONE: {
                    if (optionData.getResultCount() <= 1) break;
                    err = true;
                    break;
                }
            }
            if (!err) continue;
            this.checkErrors.append("Wrong number of occurences found for argument ");
            this.checkErrors.append(this.prefix.getName());
            this.checkErrors.append(key);
            this.checkErrors.append('\n');
            return false;
        }
        if (data.size() < set.getMinData() || data.size() > set.getMaxData()) {
            this.checkErrors.append("Invalid number of data arguments: ");
            this.checkErrors.append(data.size());
            this.checkErrors.append(" (allowed range: ");
            this.checkErrors.append(set.getMinData());
            this.checkErrors.append(" ... ");
            this.checkErrors.append(set.getMaxData());
            this.checkErrors.append(")\n");
            return false;
        }
        if (requireDataLast && first != -1 && first + data.size() != this.arguments.length) {
            this.checkErrors.append("Invalid data specification: data arguments are not the last ones on the command line\n");
            return false;
        }
        return ignoreUnmatched || unmatched.size() <= 0;
    }

    public void addOptionAllSets(String key) {
        for (String setName : this.optionSets.keySet()) {
            this.optionSets.get(setName).addOption(key, this.defaultMultiplicity);
        }
    }

    public void addOptionAllSets(String key, Multiplicity multiplicity) {
        for (String setName : this.optionSets.keySet()) {
            this.optionSets.get(setName).addOption(key, false, Separator.NONE, false, multiplicity);
        }
    }

    public void addOptionAllSets(String key, Separator separator) {
        for (String setName : this.optionSets.keySet()) {
            this.optionSets.get(setName).addOption(key, false, separator, true, this.defaultMultiplicity);
        }
    }

    public void addOptionAllSets(String key, Separator separator, Multiplicity multiplicity) {
        for (String setName : this.optionSets.keySet()) {
            this.optionSets.get(setName).addOption(key, false, separator, true, multiplicity);
        }
    }

    public void addOptionAllSets(String key, boolean details, Separator separator) {
        for (String setName : this.optionSets.keySet()) {
            this.optionSets.get(setName).addOption(key, details, separator, true, this.defaultMultiplicity);
        }
    }

    public void addOptionAllSets(String key, boolean details, Separator separator, Multiplicity multiplicity) {
        for (String setName : this.optionSets.keySet()) {
            this.optionSets.get(setName).addOption(key, details, separator, true, multiplicity);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (OptionSet set : this.optionSets.values()) {
            sb.append("Set: ");
            sb.append(set.getSetName());
            sb.append('\n');
            for (OptionData data : set.getOptionData()) {
                sb.append(data.toString());
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public static enum Multiplicity {
        ONCE,
        ONCE_OR_MORE,
        ZERO_OR_ONE,
        ZERO_OR_MORE;

    }

    public static enum Prefix {
        DASH('-'),
        SLASH('/');

        private char c;

        private Prefix(char c) {
            this.c = c;
        }

        char getName() {
            return this.c;
        }
    }

    public static enum Separator {
        COLON(':'),
        EQUALS('='),
        BLANK(' '),
        NONE('D');

        private char c;

        private Separator(char c) {
            this.c = c;
        }

        char getName() {
            return this.c;
        }
    }
}

