/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.Toast;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;

public abstract class ActionAb
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public ActionAb() {
    }

    public ActionAb(String pNomeAcao) {
        super(pNomeAcao);
    }

    public abstract void executarAcao(ActionEvent var1);

    public boolean isFecharDemonstrativoExigido() {
        return false;
    }

    public boolean isDesabilitadoVersaoBeta() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean ok = true;
        if (this.verificarDesabilitadoVersaoBeta()) {
            return;
        }
        if (ok) {
            ok = this.verificaExecutarEmReadOnly();
        }
        if (this.isFecharDemonstrativoExigido()) {
            ok = this.verificarDemonstrativoFechado();
        }
        if (ok) {
            this.executarAcao(e);
        }
    }

    protected boolean verificarDesabilitadoVersaoBeta() {
        boolean retorno = false;
        if (AplicacaoPropertiesUtil.isBeta() && this.isDesabilitadoVersaoBeta()) {
            GuiUtil.mostrarAviso("FuncionalidadeNaoDisponivelNessaVersao");
            retorno = true;
        }
        return retorno;
    }

    protected boolean verificarDemonstrativoFechado() {
        boolean lResultado = true;
        try {
            if (ControladorGui.isDemonstrativoAberto()) {
                PainelDemonstrativoIf painel = ControladorGui.getPainelAtualmenteExibido();
                if (painel.isPodeSair()) {
                    String texto = String.format("Informa\u00e7\u00f5es salvas \u00e0s %1$tT.", new Date());
                    Toast.makeText((JFrame)ControladorGui.getJanelaPrincipal(), texto, Toast.Style.NORMAL).display();
                    ControladorGui.getJanelaPrincipal().transferFocus();
                    ControladorGui.fecharDemonstrativo();
                    if (ControladorGui.isDemonstrativoAberto()) {
                        lResultado = false;
                    }
                } else {
                    lResultado = false;
                }
            }
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
            lResultado = false;
        }
        return lResultado;
    }

    protected String getChaveMensagemConfirmaFecharDemonstrativo() {
        return "ConfirmarFecharDeclaracao";
    }

    protected boolean podeExecutarEmReadOnly() {
        return true;
    }

    protected boolean verificaExecutarEmReadOnly() {
        boolean retorno = true;
        if (ControladorGui.isReadOnly() && !this.podeExecutarEmReadOnly()) {
            GuiUtil.mostrarAviso("declaracao_read_only");
            retorno = false;
        }
        return retorno;
    }
}

