/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.favoritos;

import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.Toast;
import serpro.ppgd.irpf.gui.listener.FavoritoEvent;
import serpro.ppgd.irpf.util.MensagemUtil;

public class Favoritos {
    public static boolean isFavorito(String nomeFicha) {
        IdentificadorDeclaracao identificadorDeclaracao = ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao();
        String cpf = identificadorDeclaracao.getCpf().naoFormatado();
        return Favoritos.isFavorito(cpf, nomeFicha);
    }

    public static void alterarFavorito(boolean isFavorito) {
        String nomeFicha = ControladorGui.getPainelAtualmenteExibido().getClass().getName();
        IdentificadorDeclaracao identificadorDeclaracao = ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao();
        String cpf = identificadorDeclaracao.getCpf().naoFormatado();
        Favoritos.alterarFavorito(cpf, nomeFicha, isFavorito);
        if (isFavorito) {
            Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem((String)"favoritos.ficha.adicionada")).display();
        } else {
            Toast.makeText(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem((String)"favoritos.ficha.removida")).display();
        }
        ControladorGui.recalcularNumeroFavoritos(new FavoritoEvent(nomeFicha, isFavorito));
    }

    public static List<String> obterFichasFavoritadas() {
        ArrayList<String> fichasFavoritadas = new ArrayList<String>();
        IdentificadorDeclaracao identificadorDeclaracao = ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao();
        String cpf = identificadorDeclaracao.getCpf().naoFormatado();
        try {
            for (String s : ControladorGui.getIRPFPreferences().node(cpf).keys()) {
                if (!Favoritos.isFavorito(s) || fichasFavoritadas.contains(s)) continue;
                fichasFavoritadas.add(s);
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        return fichasFavoritadas;
    }

    private static Boolean isFavorito(String cpf, String nomeFicha) {
        return ControladorGui.getIRPFPreferences().node(cpf).getBoolean(nomeFicha, false);
    }

    public static void alterarFavorito(String cpf, String nomeFicha, boolean isFavorito) {
        ControladorGui.getIRPFPreferences().node(cpf).putBoolean(nomeFicha, isFavorito);
    }

    public static void removerFavorito(String cpf, String nomeFicha) {
        ControladorGui.getIRPFPreferences().node(cpf).remove(nomeFicha);
    }
}

