/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.listener.CustomToolBarListener;
import serpro.ppgd.irpf.gui.listener.ToolBarListener;
import serpro.ppgd.irpf.gui.util.GuiUtil;

public class JIRPFToolbarCustom
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private List<CustomToolBarListener> listaEscutadores;
    private boolean customButtonAlwaysEnabled = false;
    private JButton jButtonAbrir;
    private JButton jButtonCustom;
    private JButton jButtonExcluir;
    private JButton jButtonNovo;

    public JIRPFToolbarCustom() {
        this.initComponents();
        this.inibirEnterNavegacaoFocoBotoes();
    }

    public JIRPFToolbarCustom(String customButtonLabel, boolean customButtonEnabled, boolean customButtonAlwaysEnabled) {
        this.initComponents();
        this.jButtonCustom.setText(customButtonLabel);
        this.jButtonCustom.setEnabled(customButtonEnabled);
        this.customButtonAlwaysEnabled = customButtonAlwaysEnabled;
        this.inibirEnterNavegacaoFocoBotoes();
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.jButtonCustom.setFocusTraversalKeys(0, set);
        this.jButtonNovo.setFocusTraversalKeys(0, set);
        this.jButtonAbrir.setFocusTraversalKeys(0, set);
        this.jButtonExcluir.setFocusTraversalKeys(0, set);
    }

    private void dispatchOnBtnAbrirClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (CustomToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnAbrirClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    private void dispatchOnBtnExcluirClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (CustomToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnExcluirClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    private void dispatchOnBtnNovoClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (CustomToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnNovoClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    private void dispatchOnBtnCustomClick(ActionEvent pEvento) {
        GuiUtil.startWaitCursor();
        if (this.listaEscutadores != null) {
            for (CustomToolBarListener lListener : this.listaEscutadores) {
                lListener.onBtnCustomClick(pEvento);
            }
        }
        GuiUtil.stopWaitCursor();
    }

    public void addToolBarListener(CustomToolBarListener pListener) {
        if (this.listaEscutadores == null) {
            this.listaEscutadores = new ArrayList<CustomToolBarListener>();
        }
        this.listaEscutadores.add(pListener);
    }

    public void removeToolBarListener(ToolBarListener pListener) {
        if (this.listaEscutadores != null) {
            this.listaEscutadores.remove(pListener);
            if (this.listaEscutadores.isEmpty()) {
                this.listaEscutadores = null;
            }
        }
    }

    public JButton getBtnCustom() {
        return this.jButtonCustom;
    }

    public JButton getBtnAbrir() {
        return this.jButtonAbrir;
    }

    public JButton getBtnNovo() {
        return this.jButtonNovo;
    }

    public JButton getBtnExcluir() {
        return this.jButtonExcluir;
    }

    private void initComponents() {
        this.jButtonCustom = new JButton();
        this.jButtonNovo = new JButton();
        this.jButtonAbrir = new JButton();
        this.jButtonExcluir = new JButton();
        this.setBorder(null);
        this.setOpaque(false);
        this.setLayout(new FlowLayout(2));
        this.jButtonCustom.setText("undefined");
        this.jButtonCustom.setPreferredSize(new Dimension(150, 25));
        this.jButtonCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIRPFToolbarCustom.this.jButtonCustomActionPerformed(evt);
            }
        });
        this.add(this.jButtonCustom);
        this.jButtonNovo.setMnemonic('n');
        this.jButtonNovo.setText("Novo");
        this.jButtonNovo.setToolTipText("Novo");
        this.jButtonNovo.setPreferredSize(new Dimension(90, 25));
        this.jButtonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIRPFToolbarCustom.this.jButtonNovoActionPerformed(evt);
            }
        });
        this.add(this.jButtonNovo);
        this.jButtonAbrir.setMnemonic('e');
        this.jButtonAbrir.setText("Editar");
        this.jButtonAbrir.setToolTipText("Editar");
        this.jButtonAbrir.setEnabled(false);
        this.jButtonAbrir.setPreferredSize(new Dimension(90, 25));
        this.jButtonAbrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIRPFToolbarCustom.this.jButtonAbrirActionPerformed(evt);
            }
        });
        this.add(this.jButtonAbrir);
        this.jButtonExcluir.setMnemonic('x');
        this.jButtonExcluir.setText("Excluir");
        this.jButtonExcluir.setToolTipText("Excluir");
        this.jButtonExcluir.setEnabled(false);
        this.jButtonExcluir.setPreferredSize(new Dimension(90, 25));
        this.jButtonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIRPFToolbarCustom.this.jButtonExcluirActionPerformed(evt);
            }
        });
        this.add(this.jButtonExcluir);
    }

    private void jButtonNovoActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnNovoClick(evt);
    }

    private void jButtonAbrirActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnAbrirClick(evt);
    }

    private void jButtonExcluirActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnExcluirClick(evt);
    }

    private void jButtonCustomActionPerformed(ActionEvent evt) {
        this.dispatchOnBtnCustomClick(evt);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (!this.customButtonAlwaysEnabled) {
            this.jButtonCustom.setEnabled(!lsm.isSelectionEmpty());
        }
        this.jButtonAbrir.setEnabled(!lsm.isSelectionEmpty() && lsm.getMinSelectionIndex() == lsm.getMaxSelectionIndex());
        if (ControladorGui.isReadOnly()) {
            this.jButtonExcluir.setEnabled(false);
        } else {
            this.jButtonExcluir.setEnabled(!lsm.isSelectionEmpty());
        }
    }

    public void setCustomButtonText(String label) {
        this.jButtonCustom.setText(label);
    }
}

