/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.app.acoes.ImprimirDarfCodBarrasAction;
import serpro.ppgd.app.acoes.ImprimirReciboAction;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelPesquisaPorNome;
import serpro.ppgd.irpf.gui.TableSelecionaDeclaracaoTransmitida;
import serpro.ppgd.irpf.gui.dialogs.PainelGravarCopiaDeclaracaoTransmitida;
import serpro.ppgd.irpf.gui.dialogs.PainelSelecaoTipoImpressaoNova;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class PainelDeclaracoesTransmitidas
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Imprimir Recibo de Entrega da Declara\u00e7\u00e3o";
    private File dirSelecionado = new File(UtilitariosArquivo.getPathTransmitidas());
    private boolean cancelou;
    private JLabel btnAbrir;
    private JLabel btnDARF;
    private JLabel btnGravar;
    private JLabel btnImprimir;
    private JLabel btnRecibo;
    private JLabel btnRetificar;
    private ButtonGroup buttonGroup1;
    private TableSelecionaDeclaracaoTransmitida edtTableDecs;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private PainelPesquisaPorNome painelPesquisaPorNome;

    public PainelDeclaracoesTransmitidas() {
        this.initComponents();
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                ControladorGui.repaintTelaBemVindos();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ControladorGui.repaintTelaBemVindos();
            }
        };
        this.btnDARF.addMouseListener(mouseListener);
        this.btnGravar.addMouseListener(mouseListener);
        this.btnImprimir.addMouseListener(mouseListener);
        this.btnRecibo.addMouseListener(mouseListener);
        this.btnRetificar.addMouseListener(mouseListener);
        this.painelPesquisaPorNome.setSorter(this.edtTableDecs.getTableRowSorter());
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        this.jScrollPane1.getViewport().setBackground(Color.WHITE);
        this.configurarBotao(this.btnAbrir, "Abrir Declara\u00e7\u00e3o");
        this.configurarBotao(this.btnRetificar, "Retificar Declara\u00e7\u00e3o");
        this.configurarBotao(this.btnImprimir, "Imprimir Declara\u00e7\u00e3o");
        this.configurarBotao(this.btnRecibo, "Imprimir Recibo de Entrega");
        this.configurarBotao(this.btnDARF, "Imprimir DARF do IRPF");
        this.configurarBotao(this.btnGravar, "Gravar C\u00f3pia de Seguran\u00e7a e Recibo");
        this.dirSelecionado.mkdirs();
        this.configurarEventosTabela();
        this.btnAbrir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesTransmitidas.this.edtTableDecs.getSelectedRow() == -1) {
                    ControladorGui.repaintTelaBemVindos();
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    PainelDeclaracoesTransmitidas.this.btnAbrirClick();
                }
            }
        });
        this.btnRetificar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesTransmitidas.this.edtTableDecs.getSelectedRow() == -1) {
                    ControladorGui.repaintTelaBemVindos();
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    String cpf = PainelDeclaracoesTransmitidas.this.getIdDeclaracaoSelecionado().getCpf().naoFormatado();
                    if (!IRPFFacade.existeDeclaracaoEmPreenchimento((String)cpf)) {
                        if (GuiUtil.mostrarConfirma(null, "Uma c\u00f3pia da declara\u00e7\u00e3o selecionada ser\u00e1 disponibilizada na aba \"Em Preenchimento\". \nDeseja continuar?")) {
                            PainelDeclaracoesTransmitidas.this.btnRetificarClick();
                        }
                    } else if (GuiUtil.mostrarConfirma(null, MensagemUtil.getMensagem((String)"ja_existe_declaracao_preenchimento"))) {
                        PainelDeclaracoesTransmitidas.this.btnRetificarClick();
                    }
                }
            }
        });
        this.btnImprimir.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesTransmitidas.this.edtTableDecs.getSelectedRow() == -1) {
                    ControladorGui.repaintTelaBemVindos();
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    PainelDeclaracoesTransmitidas.this.btnImprimirClick();
                }
            }
        });
        this.btnRecibo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesTransmitidas.this.edtTableDecs.getSelectedRow() == -1) {
                    ControladorGui.repaintTelaBemVindos();
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    PainelDeclaracoesTransmitidas.this.btnReciboClick();
                }
            }
        });
        this.btnDARF.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesTransmitidas.this.edtTableDecs.getSelectedRow() == -1) {
                    ControladorGui.repaintTelaBemVindos();
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    PainelDeclaracoesTransmitidas.this.btnDARFClick();
                }
            }
        });
        this.btnGravar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PainelDeclaracoesTransmitidas.this.edtTableDecs.getSelectedRow() == -1) {
                    ControladorGui.repaintTelaBemVindos();
                    GuiUtil.mostrarInfo(null, "Selecione uma declara\u00e7\u00e3o");
                } else {
                    PainelDeclaracoesTransmitidas.this.btnGravarClick();
                }
            }
        });
        this.edtTableDecs.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (PainelDeclaracoesTransmitidas.this.edtTableDecs.getSelectedRowCount() > 0 && e.getKeyCode() == 32) {
                    PainelDeclaracoesTransmitidas.this.btnAbrirClick();
                }
            }
        });
    }

    public int obterNumeroDeclaracoes() {
        return this.edtTableDecs.getModel().getRowCount();
    }

    private void configurarBotao(final JLabel botao, String hint) {
        botao.setToolTipText(hint);
        botao.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                botao.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                botao.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    private void configurarEventosTabela() {
        this.edtTableDecs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                PainelDeclaracoesTransmitidas.this.habilitarBotoes();
            }
        });
        this.edtTableDecs.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PainelDeclaracoesTransmitidas.this.habilitarBotoes();
                if (e.getClickCount() == 2 && PainelDeclaracoesTransmitidas.this.edtTableDecs.getSelectedRowCount() > 0) {
                    try {
                        ControladorGui.abrirDemonstrativo(PainelDeclaracoesTransmitidas.this.getIdDeclaracaoSelecionado(), true);
                    }
                    catch (HashInvalidoException ex) {
                        ControladorGui.tratarException((Exception)((Object)ex));
                    }
                }
            }
        });
        this.habilitarBotoes();
        this.painelPesquisaPorNome.setSorter(this.edtTableDecs.getTableRowSorter());
    }

    public void habilitarBotoes() {
        if (this.edtTableDecs.getSelectedRow() == -1) {
            this.btnAbrir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_abrir_PB.png")));
            this.btnRetificar.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_retif_PB.png")));
            this.btnImprimir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_decl_PB.png")));
            this.btnRecibo.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_recibo_PB.png")));
            this.btnDARF.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_darf_cb_PB.png")));
            this.btnGravar.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_gravar_PB.png")));
        } else {
            this.btnAbrir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_abrir.png")));
            this.btnRetificar.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_retif.png")));
            this.btnImprimir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_decl.png")));
            this.btnRecibo.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_recibo.png")));
            this.btnDARF.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_darf_cb.png")));
            this.btnGravar.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_gravar.png")));
        }
    }

    public void btnAcompanharClick() {
        GuiUtil.mostrarAviso(null, "Implementar opera\u00e7\u00e3o de acompanhar declara\u00e7\u00e3o...");
    }

    public void btnAbrirClick() {
        try {
            ControladorGui.abrirDemonstrativo(this.getIdDeclaracaoSelecionado(), true);
        }
        catch (HashInvalidoException ex) {
            ControladorGui.tratarException((Exception)((Object)ex));
        }
    }

    public void btnRetificarClick() {
        ControladorGui.retificarDeclaracaoTransmitida(this.getIdDeclaracaoSelecionado(), this.getNumeroReciboSelecionado());
    }

    public void btnImprimirClick() {
        ControladorGui.repaintTelaBemVindos();
        PainelSelecaoTipoImpressaoNova selTipoImpressao = new PainelSelecaoTipoImpressaoNova(this.getIdDeclaracaoSelecionado());
        GuiUtil.exibeDialog(selTipoImpressao, true, "IRPF " + ConstantesGlobais.EXERCICIO + " Impress\u00e3o", false);
    }

    public void btnReciboClick() {
        ControladorGui.repaintTelaBemVindos();
        new ImprimirReciboAction(this.getNumeroReciboSelecionado()).executarAcao(null);
    }

    public void btnDARFClick() {
        IdentificadorDeclaracao id = this.getIdDeclaracaoSelecionado();
        DeclaracaoIRPF dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(id.getCpf().naoFormatado(), id.getNumReciboTransmitido().naoFormatado());
        ImprimirDarfCodBarrasAction.imprimirDARF(dec, this.getTipoOperacao());
    }

    public void btnGravarClick() {
        ControladorGui.repaintTelaBemVindos();
        PainelGravarCopiaDeclaracaoTransmitida pnlCopiaSelecionada = new PainelGravarCopiaDeclaracaoTransmitida(this.getNumeroReciboSelecionado());
        GuiUtil.exibeDialog(pnlCopiaSelecionada, true, "Grava\u00e7\u00e3o de C\u00f3pia de Seguran\u00e7a", false);
    }

    private IdentificadorDeclaracao getIdDeclaracaoSelecionado() {
        int linha = ((TableRowSorter)this.edtTableDecs.getRowSorter()).convertRowIndexToModel(this.edtTableDecs.getSelectedRow());
        IdentificadorDeclaracao id = this.edtTableDecs.getIdentificadorDeclaracao(linha);
        return id;
    }

    public PainelDeclaracoesTransmitidas(boolean salvarImagem) {
        this();
    }

    private String getNumeroReciboSelecionado() {
        int linha = ((TableRowSorter)this.edtTableDecs.getRowSorter()).convertRowIndexToModel(this.edtTableDecs.getSelectedRow());
        return String.valueOf(this.edtTableDecs.getModel().getValueAt(linha, 0)).split("Recibo: ")[1].replaceAll("\\.", "");
    }

    public void atualizarListaDeclaracoesTransmitidas() {
        this.edtTableDecs = new TableSelecionaDeclaracaoTransmitida();
        this.jScrollPane1.setViewportView(this.edtTableDecs);
        this.configurarEventosTabela();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.edtTableDecs = new TableSelecionaDeclaracaoTransmitida();
        this.btnRetificar = new JLabel();
        this.btnImprimir = new JLabel();
        this.btnRecibo = new JLabel();
        this.btnDARF = new JLabel();
        this.btnGravar = new JLabel();
        this.painelPesquisaPorNome = new PainelPesquisaPorNome(true);
        this.btnAbrir = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel4.setBackground(new Color(255, 255, 255));
        this.jPanel4.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_completa.png")));
        this.jLabel5.setText("Completa");
        this.jLabel7.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel7.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_simplif.png")));
        this.jLabel7.setText("Simplificada");
        GroupLayout jPanel4Layout = new GroupLayout((Container)this.jPanel4);
        this.jPanel4.setLayout((LayoutManager)jPanel4Layout);
        jPanel4Layout.setHorizontalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel5, -2, 91, -2).addPreferredGap(0).add((Component)this.jLabel7).addContainerGap(536, Short.MAX_VALUE)));
        jPanel4Layout.setVerticalGroup((GroupLayout.Group)jPanel4Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel4Layout.createParallelGroup(3).add((Component)this.jLabel5, -2, 28, -2).add((Component)this.jLabel7, -2, 28, -2)));
        this.jScrollPane1.setViewportView(this.edtTableDecs);
        this.btnRetificar.setHorizontalAlignment(0);
        this.btnRetificar.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_retif_PB.png")));
        this.btnRetificar.setMaximumSize(new Dimension(26, 20));
        this.btnRetificar.setMinimumSize(new Dimension(26, 20));
        this.btnRetificar.setPreferredSize(new Dimension(26, 20));
        this.btnImprimir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_decl_PB.png")));
        this.btnRecibo.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_recibo_PB.png")));
        this.btnDARF.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/IM_darf_cb_PB.png")));
        this.btnGravar.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_gravar_PB.png")));
        this.btnGravar.setName("");
        this.btnAbrir.setIcon(new ImageIcon(this.getClass().getResource("/icones/png20px/MN_abrir_PB.png")));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel4, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jScrollPane1).add((Component)this.painelPesquisaPorNome, -1, 687, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.btnImprimir, -1, -1, Short.MAX_VALUE).add((Component)this.btnRecibo, -1, -1, Short.MAX_VALUE).add((Component)this.btnDARF, -1, -1, Short.MAX_VALUE).add((Component)this.btnGravar, -1, -1, Short.MAX_VALUE).add((Component)this.btnRetificar, -2, 26, -2)).add((Component)this.btnAbrir)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.painelPesquisaPorNome, -2, 27, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 197, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.btnAbrir).addPreferredGap(0).add((Component)this.btnRetificar, -2, -1, -2).addPreferredGap(0).add((Component)this.btnImprimir).addPreferredGap(0).add((Component)this.btnRecibo).addPreferredGap(0).add((Component)this.btnDARF).addPreferredGap(0).add((Component)this.btnGravar))).addPreferredGap(0).add((Component)this.jPanel4, -2, -1, -2)));
        this.painelPesquisaPorNome.getAccessibleContext().setAccessibleName("");
        this.painelPesquisaPorNome.getAccessibleContext().setAccessibleDescription("");
    }

    public int getTipoOperacao() {
        return 1;
    }

    public boolean isCancelou() {
        return this.cancelou;
    }
}

