/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditCodigo;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroMeacaoDissolucao;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroMeacaoDissolucao;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class PainelEdicaoItemMeacaoDissolucao
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ItemQuadroMeacaoDissolucao item = null;
    private ColecaoItemQuadroMeacaoDissolucao col = null;
    private boolean isEdicao = false;
    private String valAntigoValor = null;
    private String valAntigoCpf = null;
    private String valAntigoTipo = null;
    private JButton btnCancelar;
    private JButton btnOk;
    private JAutoCompleteEditCPF cmbBeneficiario;
    private JEditCodigo edtTipoBeneficiario;
    private JEditValor edtValor;
    private JLabel lblBeneficiario;
    private JLabel lblTipoBeneficiario;
    private JLabel lblValor;
    private JPanel pnlPrincipal;

    public PainelEdicaoItemMeacaoDissolucao(ColecaoItemQuadroMeacaoDissolucao _col, ItemQuadroMeacaoDissolucao _item, boolean _isEdicao) {
        this.item = _item;
        this.col = _col;
        this.isEdicao = _isEdicao;
        this.valAntigoValor = this.item.getValor().formatado();
        this.valAntigoCpf = this.item.getCpfBeneficiario().formatado();
        this.valAntigoTipo = this.item.getTipoBeneficiario().formatado();
        this.initComponents();
        this.edtTipoBeneficiario.setInformacao((Informacao)this.item.getTipoBeneficiario());
        this.cmbBeneficiario.setInformacao((Informacao)this.item.getCpfBeneficiario());
        this.edtValor.setInformacao((Informacao)this.item.getValor());
        this.edtTipoBeneficiario.getInformacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorAntigo != null && !valorAntigo.equals(valorNovo)) {
                    PainelEdicaoItemMeacaoDissolucao.this.atualizaGui();
                }
            }
        });
        this.inibirEnterNavegacaoFocoBotoes();
        this.atualizaGui();
    }

    private void atualizaGui() {
        String tipoBeneficiario = this.edtTipoBeneficiario.getInformacao().naoFormatado();
        if (tipoBeneficiario.equals("Titular")) {
            this.cmbBeneficiario.setDados(CadastroTabelasIRPF.recuperarTitular());
            this.cmbBeneficiario.getComponenteEditor().setEnabled(false);
        } else if (tipoBeneficiario.equals("Dependente")) {
            this.cmbBeneficiario.setDados(CadastroTabelasIRPF.recuperarDependentes());
            this.cmbBeneficiario.getComponenteEditor().setEnabled(true);
            this.cmbBeneficiario.getInformacao().sinalizaValidoEdit();
        } else {
            this.cmbBeneficiario.getComponenteEditor().setEnabled(false);
        }
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.btnOk.setFocusTraversalKeys(0, set);
        this.btnCancelar.setFocusTraversalKeys(0, set);
    }

    private void initComponents() {
        this.pnlPrincipal = new JPanel();
        this.lblTipoBeneficiario = new JLabel();
        this.edtTipoBeneficiario = new JEditCodigo();
        this.lblBeneficiario = new JLabel();
        this.cmbBeneficiario = new JAutoCompleteEditCPF();
        this.lblValor = new JLabel();
        this.edtValor = new JEditValor();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.setBackground(new Color(241, 245, 249));
        this.pnlPrincipal.setBackground(new Color(255, 255, 255));
        this.pnlPrincipal.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblTipoBeneficiario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipoBeneficiario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblTipoBeneficiario.setText("Tipo de Benefici\u00e1rio");
        this.lblBeneficiario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBeneficiario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBeneficiario.setText("Benefici\u00e1rio");
        this.lblValor.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValor.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValor.setText("Valor");
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("<HTML>OK</HTML>");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelEdicaoItemMeacaoDissolucao.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("<HTML>Cancelar</HTML>");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelEdicaoItemMeacaoDissolucao.this.btnCancelarActionPerformed(evt);
            }
        });
        GroupLayout pnlPrincipalLayout = new GroupLayout((Container)this.pnlPrincipal);
        this.pnlPrincipal.setLayout((LayoutManager)pnlPrincipalLayout);
        pnlPrincipalLayout.setHorizontalGroup((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPrincipalLayout.createSequentialGroup().add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPrincipalLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add((Component)this.lblTipoBeneficiario).add((Component)this.lblBeneficiario).add((Component)this.lblValor)).add(60, 60, 60).add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(2).add((Component)this.cmbBeneficiario, -2, 376, -2).add((Component)this.edtTipoBeneficiario, -1, -1, Short.MAX_VALUE).add((Component)this.edtValor, -2, 190, -2))).add((GroupLayout.Group)pnlPrincipalLayout.createSequentialGroup().add(203, 203, 203).add((Component)this.btnOk, -2, -1, -2).addPreferredGap(0).add((Component)this.btnCancelar, -2, -1, -2))).addContainerGap()));
        pnlPrincipalLayout.linkSize(new Component[]{this.btnCancelar, this.btnOk}, 1);
        pnlPrincipalLayout.setVerticalGroup((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPrincipalLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(4).add((Component)this.lblTipoBeneficiario).add((Component)this.edtTipoBeneficiario, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(4).add((Component)this.lblBeneficiario).add((Component)this.cmbBeneficiario, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(1).add((Component)this.lblValor).add((Component)this.edtValor, -2, -1, -2)).add(23, 23, 23).add((GroupLayout.Group)pnlPrincipalLayout.createParallelGroup(4).add((Component)this.btnOk, -2, -1, -2).add((Component)this.btnCancelar, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlPrincipalLayout.linkSize(new Component[]{this.btnCancelar, this.btnOk}, 2);
        pnlPrincipalLayout.linkSize(new Component[]{this.edtTipoBeneficiario, this.lblTipoBeneficiario}, 2);
        pnlPrincipalLayout.linkSize(new Component[]{this.cmbBeneficiario, this.lblBeneficiario}, 2);
        pnlPrincipalLayout.linkSize(new Component[]{this.edtValor, this.lblValor}, 2);
        this.edtTipoBeneficiario.getAccessibleContext().setAccessibleName("Benefici\u00e1rio");
        this.edtValor.getAccessibleContext().setAccessibleName("Valor");
        this.btnOk.getAccessibleContext().setAccessibleName("OK");
        this.btnCancelar.getAccessibleContext().setAccessibleName("Cancelar");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.pnlPrincipal, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.pnlPrincipal, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.edtTipoBeneficiario.getInformacao().validar();
        this.cmbBeneficiario.getInformacao().validar();
        this.edtValor.getInformacao().validar();
        if (!this.edtTipoBeneficiario.getInformacao().isValido()) {
            String msg = this.edtTipoBeneficiario.getInformacao().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao();
            JOptionPane.showMessageDialog(this, msg, "Aten\u00e7\u00e3o", 1);
            this.edtTipoBeneficiario.getComponenteFoco().requestFocusInWindow();
        } else if (!this.cmbBeneficiario.getInformacao().isValido()) {
            String msg = this.cmbBeneficiario.getInformacao().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao();
            JOptionPane.showMessageDialog(this, msg, "Aten\u00e7\u00e3o", 1);
            this.cmbBeneficiario.getComponenteFoco().requestFocusInWindow();
        } else if (!this.edtValor.getInformacao().isValido()) {
            String msg = this.edtValor.getInformacao().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao();
            JOptionPane.showMessageDialog(this, msg, "Aten\u00e7\u00e3o", 1);
            this.edtValor.getComponenteFoco().requestFocusInWindow();
        } else {
            ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
            if (!this.isEdicao && !this.item.getValor().isVazio()) {
                ItemQuadroMeacaoDissolucao itemEdit = this.col.obterPorCPF(this.item.getCpfBeneficiario().naoFormatado());
                if (itemEdit != null) {
                    itemEdit.getValor().append('+', this.item.getValor());
                } else {
                    this.col.itens().add(this.item);
                }
            }
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        if (this.isEdicao) {
            this.item.getValor().setConteudo(this.valAntigoValor);
            this.item.getCpfBeneficiario().setConteudo(this.valAntigoCpf);
            this.item.getTipoBeneficiario().setConteudo(this.valAntigoTipo);
        }
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }
}

