/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditCodigo;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.rendIsentos.ColecaoItemQuadroTransferenciaPatrimonial;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransferenciaPatrimonial;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class PainelEdicaoItemTransferenciaPatrimonial
extends JPanel {
    private static final long serialVersionUID = 1L;
    private ItemQuadroTransferenciaPatrimonial item = null;
    private ColecaoItemQuadroTransferenciaPatrimonial col = null;
    private boolean isEdicao = false;
    private String valAntigoNomeFonte = null;
    private String valAntigoValor = null;
    private String valAntigoCpf = null;
    private String valAntigoNi = null;
    private String valAntigoTipo = null;
    private JButton btnCancelar;
    private JButton btnOk;
    private JAutoCompleteEditCPF cmbBeneficiario;
    private JEditNI edtNi;
    private JEditAlfa edtNome;
    private JEditCodigo edtTipo;
    private JEditValor edtValor;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;

    public PainelEdicaoItemTransferenciaPatrimonial(ColecaoItemQuadroTransferenciaPatrimonial _col, ItemQuadroTransferenciaPatrimonial _item, boolean _isEdicao) {
        this.item = _item;
        this.col = _col;
        this.isEdicao = _isEdicao;
        this.valAntigoNomeFonte = this.item.getNomeDoadorEspolio().formatado();
        this.valAntigoValor = this.item.getValor().formatado();
        this.valAntigoCpf = this.item.getCpfBeneficiario().formatado();
        this.valAntigoNi = this.item.getNiDoadorEspolio().formatado();
        this.valAntigoTipo = this.item.getTipoBeneficiario().formatado();
        this.initComponents();
        this.edtTipo.setInformacao((Informacao)this.item.getTipoBeneficiario());
        this.cmbBeneficiario.setInformacao((Informacao)this.item.getCpfBeneficiario());
        this.edtNi.setInformacao((Informacao)this.item.getNiDoadorEspolio());
        this.edtNome.setInformacao((Informacao)this.item.getNomeDoadorEspolio());
        this.edtValor.setInformacao((Informacao)this.item.getValor());
        this.edtTipo.getInformacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (valorAntigo != null && !valorAntigo.equals(valorNovo)) {
                    PainelEdicaoItemTransferenciaPatrimonial.this.atualizaGui();
                }
            }
        });
        this.inibirEnterNavegacaoFocoBotoes();
        this.atualizaGui();
    }

    private void atualizaGui() {
        String tipoBeneficiario = this.edtTipo.getInformacao().naoFormatado();
        if (tipoBeneficiario.equals("Titular")) {
            this.cmbBeneficiario.setDados(CadastroTabelasIRPF.recuperarTitular());
            this.cmbBeneficiario.getComponenteEditor().setEnabled(false);
        } else if (tipoBeneficiario.equals("Dependente")) {
            this.cmbBeneficiario.setDados(CadastroTabelasIRPF.recuperarDependentes());
            this.cmbBeneficiario.getComponenteEditor().setEnabled(true);
            this.cmbBeneficiario.getInformacao().sinalizaValidoEdit();
        } else {
            this.cmbBeneficiario.getComponenteEditor().setEnabled(false);
        }
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.btnOk.setFocusTraversalKeys(0, set);
        this.btnCancelar.setFocusTraversalKeys(0, set);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.edtTipo = new JEditCodigo();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.edtNi = new JEditNI();
        this.jLabel3 = new JLabel();
        this.edtNome = new JEditAlfa();
        this.jLabel1 = new JLabel();
        this.edtValor = new JEditValor();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.cmbBeneficiario = new JAutoCompleteEditCPF();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.setBackground(new Color(241, 245, 249));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel4.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel4.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel4.setText("Tipo de Benefici\u00e1rio");
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel5.setText("Benefici\u00e1rio");
        this.jLabel3.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel3.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel3.setText("CPF/CNPJ do Doador/Esp\u00f3lio");
        this.edtNome.setMaxChars(60);
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel1.setText("Nome do Doador/Esp\u00f3lio");
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel2.setText("Valor");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 166, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(0, 53, Short.MAX_VALUE));
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("<HTML>OK</HTML>");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelEdicaoItemTransferenciaPatrimonial.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("<HTML>Cancelar</HTML>");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelEdicaoItemTransferenciaPatrimonial.this.btnCancelarActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel4).add((Component)this.jLabel5).add((Component)this.jLabel3).add((Component)this.jLabel1).add((Component)this.jLabel2)).add(34, 34, 34).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.cmbBeneficiario, -2, 376, -2).add(2, (Component)this.edtNi, -1, 169, Short.MAX_VALUE).add(2, (Component)this.edtNome, -1, 169, Short.MAX_VALUE).add(2, (Component)this.edtValor, -1, 169, Short.MAX_VALUE).add(2, (Component)this.edtTipo, -2, 376, -2))).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add(12, 12, 12).add((Component)this.jPanel1, -2, -1, -2).add(18, 18, 18).add((Component)this.btnOk, -2, -1, -2).addPreferredGap(0).add((Component)this.btnCancelar, -2, -1, -2))).addContainerGap()));
        jPanel2Layout.linkSize(new Component[]{this.btnCancelar, this.btnOk}, 1);
        jPanel2Layout.linkSize(new Component[]{this.edtNi, this.edtNome, this.edtValor}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(4).add((Component)this.jLabel4).add((Component)this.edtTipo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(4).add((Component)this.jLabel5).add((Component)this.cmbBeneficiario, -2, -1, -2)).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(4).add((Component)this.jLabel3).add((Component)this.edtNi, -2, 21, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(4).add((Component)this.jLabel1).add((Component)this.edtNome, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(4).add((Component)this.jLabel2).add((Component)this.edtValor, -2, -1, -2)).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnCancelar, -2, -1, -2).add((Component)this.btnOk, -2, -1, -2)).add(26, 26, 26)))));
        jPanel2Layout.linkSize(new Component[]{this.btnCancelar, this.btnOk}, 2);
        jPanel2Layout.linkSize(new Component[]{this.edtTipo, this.jLabel4}, 2);
        jPanel2Layout.linkSize(new Component[]{this.cmbBeneficiario, this.jLabel5}, 2);
        jPanel2Layout.linkSize(new Component[]{this.edtNi, this.jLabel3}, 2);
        jPanel2Layout.linkSize(new Component[]{this.edtNome, this.jLabel1}, 2);
        jPanel2Layout.linkSize(new Component[]{this.edtValor, this.jLabel2}, 2);
        this.edtTipo.getAccessibleContext().setAccessibleName("Benefici\u00e1rio");
        this.edtNi.getAccessibleContext().setAccessibleName("CPF ou CNPJ");
        this.edtNome.getAccessibleContext().setAccessibleName("Fonte pagadora");
        this.edtValor.getAccessibleContext().setAccessibleName("Valor");
        this.btnOk.getAccessibleContext().setAccessibleName("OK");
        this.btnCancelar.getAccessibleContext().setAccessibleName("Cancelar");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -2, -1, -2).addContainerGap(16, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.edtTipo.getInformacao().validar();
        this.cmbBeneficiario.getInformacao().validar();
        this.edtNi.getInformacao().validar();
        this.edtValor.getInformacao().validar();
        if (!this.edtTipo.getInformacao().isValido()) {
            String msg = this.edtTipo.getInformacao().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao();
            JOptionPane.showMessageDialog(this, msg, "Aten\u00e7\u00e3o", 1);
            this.edtTipo.getComponenteFoco().requestFocusInWindow();
        } else if (!this.cmbBeneficiario.getInformacao().isValido()) {
            String msg = this.cmbBeneficiario.getInformacao().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao();
            JOptionPane.showMessageDialog(this, msg, "Aten\u00e7\u00e3o", 1);
            this.cmbBeneficiario.getComponenteFoco().requestFocusInWindow();
        } else if (!this.edtNi.getInformacao().isValido()) {
            String msg = this.edtNi.getInformacao().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao();
            JOptionPane.showMessageDialog(this, msg, "Aten\u00e7\u00e3o", 1);
            this.edtNi.getComponenteFoco().requestFocusInWindow();
        } else if (!this.edtValor.getInformacao().isValido()) {
            String msg = this.edtValor.getInformacao().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao();
            JOptionPane.showMessageDialog(this, msg, "Aten\u00e7\u00e3o", 1);
            this.edtValor.getComponenteFoco().requestFocusInWindow();
        } else {
            ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
            if (!this.isEdicao && !this.item.getValor().isVazio()) {
                this.col.itens().add(this.item);
            }
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        if (this.isEdicao) {
            this.item.getNomeDoadorEspolio().setConteudo(this.valAntigoNomeFonte);
            this.item.getValor().setConteudo(this.valAntigoValor);
            this.item.getCpfBeneficiario().setConteudo(this.valAntigoCpf);
            this.item.getNiDoadorEspolio().setConteudo(this.valAntigoNi);
            this.item.getTipoBeneficiario().setConteudo(this.valAntigoTipo);
        }
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }
}

