/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.JIRPFToolbar;
import serpro.ppgd.irpf.gui.PainelPrincipalAb;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.TableListaSumario;
import serpro.ppgd.irpf.gui.TableListaSumarioModel;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.IRPFTableDecorator;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class PainelListaAb
extends PainelPrincipalAb {
    private static final long serialVersionUID = 1L;
    protected Colecao<? extends ObjetoNegocio> colecao;
    private JIRPFToolbar irpfToolbar;
    private JScrollPane jScrollPane1;
    private TableLista tableLista;

    public PainelListaAb(boolean construir, boolean exibirBotoesToolbar) {
        if (construir) {
            this.construirUI();
        }
        if (this.irpfToolbar != null) {
            this.irpfToolbar.setVisible(exibirBotoesToolbar);
        }
    }

    public void ajustarToolBarImportar() {
        this.getIrpfToolbar().getBtnNovo().setText("Importar");
        this.getIrpfToolbar().getBtnAbrir().setText("Abrir");
        this.getIrpfToolbar().getBtnNovo().setMnemonic(73);
        this.getIrpfToolbar().getBtnAbrir().setMnemonic(66);
    }

    public void ocultarToolBar() {
        if (this.getIrpfToolbar() != null) {
            this.getIrpfToolbar().setVisible(false);
        }
    }

    public PainelListaAb() {
        this.colecao = null;
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, this.getButtonHelpID());
        this.initComponents();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        IRPFTableDecorator.decorate(this.getTabela(), this);
        this.getTabela().getSelectionModel().addListSelectionListener(this.irpfToolbar);
    }

    public PainelListaAb(Colecao<? extends ObjetoNegocio> colecao) {
        this.construirUI();
    }

    public void construirUI() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, this.getButtonHelpID());
        this.initComponents();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        IRPFTableDecorator.decorate(this.getTabela(), this);
        this.getTabela().getSelectionModel().addListSelectionListener(this.irpfToolbar);
    }

    private void initComponents() {
        this.irpfToolbar = new JIRPFToolbar();
        this.jScrollPane1 = new JScrollPane();
        this.tableLista = this.instanciarTabela(this.getTableModel(), this.getColunaOrdenacao(), this.getColunasOrdenaveis());
        this.setBackground(new Color(241, 245, 249));
        this.irpfToolbar.addToolBarListener(this);
        this.jScrollPane1.setViewportView(this.tableLista);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 578, Short.MAX_VALUE).add(2, (Component)this.irpfToolbar, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 285, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.irpfToolbar, -2, -1, -2)));
    }

    @Override
    public IRPFTableAb getTabela() {
        return this.tableLista;
    }

    protected abstract void configurarTamanhoColunas();

    protected abstract TableLista instanciarTabela(TableListaModel var1, int var2, Integer[] var3);

    protected abstract String getClassePainelNavegacao();

    protected abstract String getButtonHelpID();

    protected abstract TableListaModel getTableModel();

    protected abstract int getColunaOrdenacao();

    protected abstract Integer[] getColunasOrdenaveis();

    @Override
    public void preExibir() {
        if (((IRPFTableModelAb)this.getTabela().getModel()).getObjetoNegocio() instanceof Colecao) {
            ((Colecao)((IRPFTableModelAb)this.getTabela().getModel()).getObjetoNegocio()).excluirRegistrosEmBranco();
        }
        ((IRPFTableModelAb)this.getTabela().getModel()).refresh();
    }

    @Override
    public void onBtnExcluirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        boolean temSumario = tabela instanceof TableListaSumario;
        if (!(tabela.getSelectedRowCount() <= 0 || temSumario && tabela.getSelectedRow() >= tabela.getRowCount() - 1)) {
            int[] linhasTabela = tabela.getSelectedRows();
            if (GuiUtil.mostrarConfirmaNaoPadrao(this.getMensagemExclusao(), this.getParametrosMensagemExclusao())) {
                TableListaModel model = (TableListaModel)tabela.getModel();
                ArrayList<Integer> linhasExcluidas = new ArrayList<Integer>();
                for (int linhaTabela : linhasTabela) {
                    int indiceVetor;
                    ObjetoNegocio objetoNegocio;
                    if (temSumario && linhaTabela >= tabela.getRowCount() - 1 || !this.validarExclusao(objetoNegocio = model.getObjetoNegocio(indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela)))) continue;
                    linhasExcluidas.add(new Integer(indiceVetor));
                }
                model.removeObjetoNegocio(linhasExcluidas.toArray(new Integer[linhasExcluidas.size()]));
            }
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
    }

    public boolean validarExclusao(ObjetoNegocio objetoNegocio) {
        return true;
    }

    public abstract String getMensagemExclusao();

    public abstract String[] getParametrosMensagemExclusao();

    @Override
    public JComponent getDefaultFocus() {
        if (!(this.getTabela().getModel().getRowCount() <= 0 || TableListaSumarioModel.class.isAssignableFrom(this.getTabela().getModel().getClass()) && this.getTabela().getModel().getRowCount() <= 1)) {
            return this.getTabela();
        }
        return this.getIrpfToolbar().getBtnNovo();
    }

    public JIRPFToolbar getIrpfToolbar() {
        return this.irpfToolbar;
    }

    public Colecao<? extends ObjetoNegocio> getColecao() {
        return this.colecao;
    }

    @Override
    public String getHelpID() {
        return this.getButtonHelpID();
    }
}

