/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import serpro.ppgd.irpf.gui.dialogs.PainelSplash;
import serpro.ppgd.negocio.util.LogPPGD;

public class SplashScreen
extends JWindow {
    private static final long serialVersionUID = 1L;
    boolean showing = true;

    public SplashScreen(URL filename, Frame f, int waitTime) {
        super(f);
        PainelSplash painelSplash = PainelSplash.getInstance();
        this.setPreferredSize(new Dimension(512, 178));
        this.getContentPane().add((Component)painelSplash, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = painelSplash.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SplashScreen.this.setVisible(false);
                SplashScreen.this.dispose();
                SplashScreen.this.showing = false;
            }
        });
        final int pause = waitTime;
        final Runnable closerRunner = new Runnable(){

            @Override
            public void run() {
                SplashScreen.this.setVisible(false);
                SplashScreen.this.dispose();
                SplashScreen.this.showing = false;
            }
        };
        Runnable waitRunner = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(pause);
                    SwingUtilities.invokeAndWait(closerRunner);
                }
                catch (Exception e) {
                    LogPPGD.erro((String)e.getMessage());
                }
            }
        };
        this.setVisible(true);
        Thread splashThread = new Thread(waitRunner, "SplashThread");
        splashThread.start();
    }

    public void waitForFinish() {
        while (this.isShowing()) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                LogPPGD.erro((String)e.getMessage());
            }
        }
    }

    @Override
    public boolean isShowing() {
        return this.showing;
    }

    public void setShowing(boolean status) {
        this.showing = status;
    }
}

