/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.componente;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class DashedBorder
implements Border {
    private static final int DEFAULT_THICKNESS = 2;
    private static final int DEFAULT_HEIGHT = 2;
    private static final int DEFAULT_WIDTH = 2;
    private int thickness;
    private Color color;
    private int dashWidth;
    private int dashHeight;

    public DashedBorder() {
        this(Color.black, 2, 2, 2);
    }

    public DashedBorder(Color pColor, int pWidth, int pHeight) {
        this(Color.black, pWidth, pHeight, 2);
    }

    public DashedBorder(Color pColor, int pWidth, int pHeight, int pThickness) {
        if (pWidth < 1) {
            throw new IllegalArgumentException("Invalid width: " + pWidth);
        }
        if (pHeight < 1) {
            throw new IllegalArgumentException("Invalid height: " + pHeight);
        }
        this.color = pColor;
        this.dashWidth = pWidth;
        this.dashHeight = pHeight;
        this.thickness = pThickness;
    }

    @Override
    public void paintBorder(Component pComponent, Graphics pGraphics, int pPosX, int pPosY, int pWidth, int pHeight) {
        int startPoint;
        int i;
        Insets insets = this.getBorderInsets(pComponent);
        pGraphics.setColor(this.color);
        int numWide = Math.round((float)pWidth / (float)this.dashWidth);
        int numHigh = Math.round((float)pHeight / (float)this.dashHeight);
        for (i = 0; i <= numWide; i += 2) {
            startPoint = pPosX + this.dashWidth * i;
            pGraphics.fillRect(startPoint, pPosY, this.dashWidth, this.thickness);
            pGraphics.fillRect(startPoint, pPosY + pHeight - insets.bottom, this.dashWidth, this.thickness);
        }
        for (i = 0; i <= numHigh; i += 2) {
            startPoint = pPosX + this.dashHeight * i;
            pGraphics.fillRect(pPosX, startPoint, this.thickness, this.dashHeight);
            pGraphics.fillRect(pPosX + pWidth - insets.right, startPoint, this.thickness, this.dashHeight);
        }
    }

    @Override
    public Insets getBorderInsets(Component pComponent) {
        return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

