/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRMapArrayDataSource;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.formatosexternos.PPGDJasperViewer;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesPreenchimento;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesTransmitidas;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.txt.util.IRPFTxtUtil;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosArquivo;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class PainelAbrirDeclaracao
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Abrir uma declara\u00e7\u00e3o";
    private static final int INDICE_COLUNA_TIPO = 1;
    private static final int INDICE_COLUNA_AJUSTE_ESPOLIO_SAIDA = 2;
    private static final int INDICE_COLUNA_CPF = 3;
    private static final int INDICE_COLUNA_NOME = 4;
    private SubpainelDeclaracoesPreenchimento subpainelDeclaracoesPreenchimento;
    private SubpainelDeclaracoesTransmitidas subpainelDeclaracoesTransmitidas;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnImprimir;
    private JButton btnOk;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JTabbedPane tabPaneDeclaracoes;

    public PainelAbrirDeclaracao() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.subpainelDeclaracoesPreenchimento = new SubpainelDeclaracoesPreenchimento();
        this.subpainelDeclaracoesTransmitidas = new SubpainelDeclaracoesTransmitidas();
        this.tabPaneDeclaracoes.addTab("Em Preenchimento", new ImageIcon(this.getClass().getResource("/icones/png16px/Icon_barraTitulo_16px.png")), this.subpainelDeclaracoesPreenchimento);
        this.tabPaneDeclaracoes.addTab("Transmitidas", new ImageIcon(this.getClass().getResource("/icones/png16px/AB_transmitido.png")), this.subpainelDeclaracoesTransmitidas);
        this.tabPaneDeclaracoes.setMnemonicAt(0, 69);
        this.tabPaneDeclaracoes.setMnemonicAt(1, 82);
        this.configurarBotaoOK();
        this.configurarPainelComAbas();
    }

    private void configurarPainelComAbas() {
        this.tabPaneDeclaracoes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PainelAbrirDeclaracao.this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
                    PainelAbrirDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectionModel().clearSelection();
                    if (PainelAbrirDeclaracao.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                        PainelAbrirDeclaracao.this.btnOk.setEnabled(true);
                    } else {
                        PainelAbrirDeclaracao.this.btnOk.setEnabled(false);
                    }
                } else {
                    PainelAbrirDeclaracao.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectionModel().clearSelection();
                    if (PainelAbrirDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                        PainelAbrirDeclaracao.this.btnOk.setEnabled(true);
                    } else {
                        PainelAbrirDeclaracao.this.btnOk.setEnabled(false);
                    }
                }
            }
        });
        this.subpainelDeclaracoesPreenchimento.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelAbrirDeclaracao.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelAbrirDeclaracao.this.btnOkActionPerformed(null);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelAbrirDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelAbrirDeclaracao.this.btnOkActionPerformed(null);
                }
            }
        });
    }

    private void configurarBotaoOK() {
        this.subpainelDeclaracoesPreenchimento.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelAbrirDeclaracao.this.tabPaneDeclaracoes.getSelectedIndex() == 0 && PainelAbrirDeclaracao.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelAbrirDeclaracao.this.btnOk.setEnabled(true);
                } else {
                    PainelAbrirDeclaracao.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesPreenchimento.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelAbrirDeclaracao.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelAbrirDeclaracao.this.btnOkActionPerformed(null);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelAbrirDeclaracao.this.tabPaneDeclaracoes.getSelectedIndex() == 1 && PainelAbrirDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelAbrirDeclaracao.this.btnOk.setEnabled(true);
                } else {
                    PainelAbrirDeclaracao.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelAbrirDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelAbrirDeclaracao.this.btnOkActionPerformed(null);
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.btnImprimir = new JButton();
        this.tabPaneDeclaracoes = new JTabbedPane();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione a declara\u00e7\u00e3o que deseja abrir");
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAbrirDeclaracao.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAbrirDeclaracao.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.btnImprimir.setMnemonic('I');
        this.btnImprimir.setText("Imprimir");
        this.btnImprimir.setToolTipText("Imprimir rela\u00e7\u00e3o de declara\u00e7\u00f5es");
        this.btnImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAbrirDeclaracao.this.btnImprimirActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnOk, -1, 90, Short.MAX_VALUE).add((Component)this.btnCancelar, -1, 90, Short.MAX_VALUE).add((Component)this.btnAjuda, -1, -1, Short.MAX_VALUE).add((Component)this.btnImprimir, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnImprimir, this.btnOk}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addPreferredGap(0).add((Component)this.btnImprimir).addContainerGap(131, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 2);
        this.btnOk.getAccessibleContext().setAccessibleName("OK");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tabPaneDeclaracoes, -1, 717, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2))).add(6, 6, 6)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(36, 36, 36)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tabPaneDeclaracoes).addContainerGap()))));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione a declara\u00e7\u00e3o que deseja abrir. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnImprimirActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        String pathDados = IRPFUtil.DIR_DADOS + "/iddeclaracoes.xml";
        ArrayList parametros = new ArrayList();
        ColecaoIdDeclaracao colIdDeclaracoes = IRPFFacade.getListaIdDeclaracoesEmPrenchimento();
        for (ObjetoNegocio objNegocio : colIdDeclaracoes.itens()) {
            IdentificadorDeclaracao idDeclaracao = (IdentificadorDeclaracao)objNegocio;
            DeclaracaoIRPF declaracao = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(idDeclaracao.getCpf().naoFormatado(), "0000000000");
            Valor impostoRestituir = declaracao.getResumo().getCalculoImposto().getImpostoRestituir();
            Valor impostoPagar = declaracao.getResumo().getCalculoImposto().getSaldoImpostoPagar();
            int resultCompare = impostoPagar.compareTo(impostoRestituir);
            String resultadoDeclaracao = "";
            resultadoDeclaracao = resultCompare == 0 ? "SSI" : (resultCompare < 0 ? "IAR" : "IAP");
            String pathTransmitidas = UtilitariosArquivo.getPathGravadas();
            String numRecibo = IRPFTxtUtil.declaracaoFoiTransmitida((IdentificadorDeclaracao)idDeclaracao, (String)pathTransmitidas);
            boolean foiTransmitida = numRecibo != null;
            HashMap<String, String> registro = new HashMap<String, String>();
            registro.put("tipodeclaracao", idDeclaracao.isCompleta() ? "0" : "1");
            registro.put("transmitida", foiTransmitida ? "1" : "0");
            if (foiTransmitida) {
                registro.put("numerorecibo", IRPFTxtUtil.formataNumeroRecibo((String)numRecibo));
            } else {
                registro.put("numerorecibo", "");
            }
            registro.put("cpf", idDeclaracao.getCpf().formatado());
            registro.put("nome", idDeclaracao.getNome().naoFormatado());
            registro.put("tipodeclaracaoAES", idDeclaracao.isAjuste() ? "A" : (idDeclaracao.isEspolio() ? "E" : (idDeclaracao.isSaida() ? "S" : "")));
            registro.put("declaracaoretificadora", idDeclaracao.getDeclaracaoRetificadora().naoFormatado());
            registro.put("resultado", resultadoDeclaracao);
            parametros.add(registro);
        }
        Collections.sort(parametros, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> registro1, Map<String, String> registro2) {
                TableRowSorter ts = (TableRowSorter)PainelAbrirDeclaracao.this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter();
                List<RowSorter.SortKey> sortKeys = ts.getSortKeys();
                for (RowSorter.SortKey sk : sortKeys) {
                    SortOrder ordem;
                    if (sk.getColumn() == 1 && (ordem = sk.getSortOrder()) != SortOrder.UNSORTED) {
                        return registro1.get("declaracaoretificadora").compareToIgnoreCase(registro2.get("declaracaoretificadora")) * IRPFUtil.converterSortOrderParaInteiro((SortOrder)ordem);
                    }
                    if (sk.getColumn() == 2 && (ordem = sk.getSortOrder()) != SortOrder.UNSORTED) {
                        return registro1.get("tipodeclaracaoAES").compareToIgnoreCase(registro2.get("tipodeclaracaoAES")) * IRPFUtil.converterSortOrderParaInteiro((SortOrder)ordem);
                    }
                    if (sk.getColumn() == 3 && (ordem = sk.getSortOrder()) != SortOrder.UNSORTED) {
                        return registro1.get("cpf").compareToIgnoreCase(registro2.get("cpf")) * IRPFUtil.converterSortOrderParaInteiro((SortOrder)ordem);
                    }
                    if (sk.getColumn() != 4 || (ordem = sk.getSortOrder()) == SortOrder.UNSORTED) continue;
                    return registro1.get("nome").compareToIgnoreCase(registro2.get("nome")) * IRPFUtil.converterSortOrderParaInteiro((SortOrder)ordem);
                }
                return 0;
            }
        });
        try {
            InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream("relDeclaracoes.jasper");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("exercicio", ConstantesGlobais.EXERCICIO);
            JasperPrint print = JasperFillManager.fillReport((InputStream)streamRel, params, (JRDataSource)new JRMapArrayDataSource(parametros.toArray()));
            print.setName(IRPFUtil.obterNomeArquivoPDF(null, null, (String)"relacaodecl", null));
            PPGDJasperViewer viewer = new PPGDJasperViewer(print, false, new Locale("pt", "BR"));
            viewer.setTitle("Declara\u00e7\u00e3o");
            viewer.setIconImage(Frame.getFrames()[0].getIconImage());
            viewer.addWindowFocusListener(new WindowFocusListener(){
                private boolean firstLost = true;

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (this.firstLost) {
                        e.getWindow().toFront();
                        this.firstLost = false;
                    }
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }
            });
            viewer.setVisible(true);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        GuiUtil.fecharDialog(this);
        if (this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
            int linha = ((TableRowSorter)this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToModel(this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRow());
            IdentificadorDeclaracao id = this.subpainelDeclaracoesPreenchimento.getTabela().getIdentificadorDeclaracao(linha);
            try {
                ControladorGui.abrirDemonstrativo(id, true);
            }
            catch (HashInvalidoException e) {
                ControladorGui.tratarException((Exception)((Object)e));
            }
        } else {
            int linha = ((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToModel(this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRow());
            IdentificadorDeclaracao id = this.subpainelDeclaracoesTransmitidas.getTabela().getIdentificadorDeclaracao(linha);
            try {
                ControladorGui.abrirDemonstrativo(id, true);
            }
            catch (HashInvalidoException e) {
                ControladorGui.tratarException((Exception)((Object)e));
            }
        }
    }
}

