/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.concurrent.ExecutionException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.text.PlainDocument;
import org.jdesktop.swingx.JXBusyLabel;
import serpro.ppgd.app.acoes.HabilitarAvaliacaoAction;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegadorHtml;
import serpro.ppgd.irpf.gui.nuvem.CaptchaDocumentFilter;
import serpro.ppgd.irpf.gui.nuvem.PainelCaptchaAb;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.RetornoBarramento;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;

public class PainelAvisoAvaliacao
extends PainelCaptchaAb
implements WindowListener {
    private boolean usuarioLogado;
    private boolean exibirCaptcha;
    private String protocolo;
    private SwingWorker<RetornoBarramento, Void> sw;
    private JButton btnAtualizarCaptcha;
    private JButton btnAvaliar;
    private JButton btnOuvirCaptcha;
    private JCheckBox chkDesabilitaAvaliacao;
    private JEditAlfa edtCaptcha;
    private JLabel jLabel2;
    private JLabel lblAvisoAvaliacao;
    private JLabel lblCaptcha;
    private JLabel lblOcupado;
    private JPanel pnlCaptcha;

    public PainelAvisoAvaliacao(String protocolo, boolean usuarioLogado, boolean exibirCaptcha) {
        this.usuarioLogado = usuarioLogado;
        this.exibirCaptcha = exibirCaptcha;
        this.protocolo = protocolo;
        this.sw = null;
        this.initComponents();
        this.lblOcupado.setVisible(false);
        this.iniciarPainel(usuarioLogado, exibirCaptcha);
    }

    public void iniciarPainel(boolean usuarioLogado, boolean exibirCaptcha) {
        if (usuarioLogado || !exibirCaptcha) {
            this.pnlCaptcha.setVisible(false);
        } else {
            this.obterCaptcha();
        }
    }

    public void obterLinkAvaliacao(final boolean usuarioLogado, final boolean exibirCaptcha) {
        this.sw = new SwingWorker<RetornoBarramento, Void>(){

            @Override
            protected RetornoBarramento doInBackground() throws Exception {
                if (usuarioLogado) {
                    return BarramentoIRPFService.obterLinkAvaliacaoUsuarioLogado((String)PainelAvisoAvaliacao.this.protocolo);
                }
                return BarramentoIRPFService.obterLinkAvaliacaoUsuarioAnonimo((String)PainelAvisoAvaliacao.this.protocolo);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                boolean captchaIncorreto = false;
                try {
                    RetornoBarramento retorno = (RetornoBarramento)this.get();
                    if ("00".equals(retorno.getCodigoRetorno())) {
                        NavegadorHtml.executarNavegadorComMsgErro(retorno.getConteudo());
                    }
                }
                catch (ExecutionException e) {
                    String ex;
                    e.printStackTrace();
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof BarramentoException) {
                        if ("90".equals(((BarramentoException)cause).getCodigoRetorno())) {
                            captchaIncorreto = true;
                        }
                        ex = cause.getMessage();
                    } else {
                        ex = "N\u00e3o foi poss\u00edvel iniciar a avalia\u00e7\u00e3o.";
                    }
                    GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), ex);
                }
                catch (Throwable e) {
                    System.err.println("Opera\u00e7\u00e3o cancelada pelo usu\u00e1rio...");
                    e.printStackTrace();
                }
                finally {
                    PainelAvisoAvaliacao.this.configurarPainel(false);
                    if (captchaIncorreto && exibirCaptcha) {
                        PainelAvisoAvaliacao.this.obterCaptcha();
                    } else {
                        GuiUtil.fecharDialog(PainelAvisoAvaliacao.this);
                    }
                }
            }
        };
        this.configurarPainel(true);
        this.sw.execute();
    }

    public void configurarPainel(boolean ocupado) {
        this.getLabelOcupado().setVisible(ocupado);
        this.getLabelOcupado().setBusy(ocupado);
        this.getBtnOk().setEnabled(!ocupado);
        this.getBtnAtualizar().setEnabled(!ocupado);
        this.getBtnAudio().setEnabled(!ocupado);
        this.getRespostaCaptcha().setHabilitado(!ocupado);
    }

    private void cancelarAvaliacao() {
        if (this.sw != null && !this.sw.isDone()) {
            this.sw.cancel(true);
        }
    }

    private void initComponents() {
        this.lblAvisoAvaliacao = new JLabel();
        this.chkDesabilitaAvaliacao = new JCheckBox();
        this.btnAvaliar = new JButton();
        this.pnlCaptcha = new JPanel();
        this.lblCaptcha = new JLabel();
        this.jLabel2 = new JLabel();
        this.btnAtualizarCaptcha = new JButton();
        this.btnOuvirCaptcha = new JButton();
        this.edtCaptcha = new JEditAlfa();
        this.lblOcupado = new JXBusyLabel();
        this.lblAvisoAvaliacao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblAvisoAvaliacao.setForeground(new Color(0, 74, 106));
        this.lblAvisoAvaliacao.setText("Agora voc\u00ea ser\u00e1 direcionado para a p\u00e1gina de avalia\u00e7\u00e3o do IRPF " + ConstantesGlobais.EXERCICIO + ".");
        this.chkDesabilitaAvaliacao.setBackground(new Color(241, 245, 249));
        this.chkDesabilitaAvaliacao.setFont(FontesUtil.FONTE_NORMAL);
        this.chkDesabilitaAvaliacao.setForeground(new Color(0, 74, 106));
        this.chkDesabilitaAvaliacao.setText("N\u00e3o exibir mais este aviso");
        this.chkDesabilitaAvaliacao.setOpaque(true);
        this.chkDesabilitaAvaliacao.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PainelAvisoAvaliacao.this.chkDesabilitaAvaliacaoItemStateChanged(evt);
            }
        });
        this.btnAvaliar.setText("Avaliar o IRPF");
        this.btnAvaliar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAvisoAvaliacao.this.btnAvaliarActionPerformed(evt);
            }
        });
        this.lblCaptcha.setText("");
        this.jLabel2.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel2.setForeground(new Color(0, 74, 106));
        this.jLabel2.setText("Para prosseguir, digite os caracteres ao lado");
        this.btnAtualizarCaptcha.setIcon(GuiUtil.getImage("/icones/reload.png"));
        this.btnAtualizarCaptcha.setText("");
        this.btnAtualizarCaptcha.setToolTipText("Atualizar Imagem");
        this.btnAtualizarCaptcha.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAvisoAvaliacao.this.btnAtualizarCaptchaActionPerformed(evt);
            }
        });
        this.btnOuvirCaptcha.setIcon(GuiUtil.getImage("/icones/audio.png"));
        this.btnOuvirCaptcha.setText("");
        this.btnOuvirCaptcha.setToolTipText("Ouvir Caracteres");
        this.btnOuvirCaptcha.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAvisoAvaliacao.this.btnOuvirCaptchaActionPerformed(evt);
            }
        });
        ((PlainDocument)((JTextField)this.edtCaptcha.getComponenteEditor()).getDocument()).setDocumentFilter(new CaptchaDocumentFilter());
        GroupLayout pnlCaptchaLayout = new GroupLayout(this.pnlCaptcha);
        this.pnlCaptcha.setLayout(pnlCaptchaLayout);
        pnlCaptchaLayout.setHorizontalGroup(pnlCaptchaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCaptchaLayout.createSequentialGroup().addGroup(pnlCaptchaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCaptchaLayout.createSequentialGroup().addComponent(this.btnAtualizarCaptcha).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOuvirCaptcha)).addComponent(this.lblCaptcha, -2, 225, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlCaptchaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent((Component)this.edtCaptcha, -2, 206, -2)).addGap(0, 0, Short.MAX_VALUE)));
        pnlCaptchaLayout.setVerticalGroup(pnlCaptchaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCaptchaLayout.createSequentialGroup().addGroup(pnlCaptchaLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCaptcha, -2, 60, -2).addGroup(pnlCaptchaLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtCaptcha, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlCaptchaLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAtualizarCaptcha).addComponent(this.btnOuvirCaptcha))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlCaptcha, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.chkDesabilitaAvaliacao).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblOcupado, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAvaliar)).addComponent(this.lblAvisoAvaliacao, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblAvisoAvaliacao).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pnlCaptcha, -2, -1, -2).addGap(35, 35, 35).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblOcupado, GroupLayout.Alignment.TRAILING, -2, 30, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkDesabilitaAvaliacao).addComponent(this.btnAvaliar))).addContainerGap()));
    }

    private void btnAvaliarActionPerformed(ActionEvent evt) {
        this.obterLinkAvaliacao(this.usuarioLogado, this.exibirCaptcha);
    }

    private void btnAtualizarCaptchaActionPerformed(ActionEvent evt) {
        this.obterCaptcha();
    }

    private void btnOuvirCaptchaActionPerformed(ActionEvent evt) {
        this.obterAudioCaptcha();
    }

    private void chkDesabilitaAvaliacaoItemStateChanged(ItemEvent evt) {
        new HabilitarAvaliacaoAction().naoExibirAvaliacaoMarcado(evt.getStateChange() == 1);
    }

    @Override
    protected JLabel getImagemCaptcha() {
        return this.lblCaptcha;
    }

    @Override
    protected Informacao getRespostaCaptcha() {
        return this.edtCaptcha.getInformacao();
    }

    @Override
    public JXBusyLabel getLabelOcupado() {
        return (JXBusyLabel)this.lblOcupado;
    }

    @Override
    public JButton getBtnOk() {
        return this.btnAvaliar;
    }

    @Override
    public JButton getBtnAtualizar() {
        return this.btnAtualizarCaptcha;
    }

    @Override
    public JButton getBtnAudio() {
        return this.btnOuvirCaptcha;
    }

    @Override
    public JComponent getComponenteResposta() {
        return this.edtCaptcha;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.cancelar();
        this.cancelarAvaliacao();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

