/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.app.acoes.ImprimirDarfCodBarrasAction;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesPreenchimento;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesTransmitidas;

public class PainelImprimirDARFCodigoBarras
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Imprimir Darf do IRPF";
    private boolean cancelou = false;
    private SubpainelDeclaracoesPreenchimento subpainelDeclaracoesPreenchimento;
    private SubpainelDeclaracoesTransmitidas subpainelDeclaracoesTransmitidas;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel6;
    private JPanel jPanel2;
    private JRadioButton rbImprimir;
    private JRadioButton rbVisualizar;
    private JTabbedPane tabPaneDeclaracoes;

    public PainelImprimirDARFCodigoBarras() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.subpainelDeclaracoesPreenchimento = new SubpainelDeclaracoesPreenchimento();
        this.subpainelDeclaracoesPreenchimento.setSelectionMode(0);
        this.subpainelDeclaracoesTransmitidas = new SubpainelDeclaracoesTransmitidas();
        this.subpainelDeclaracoesTransmitidas.setSelectionMode(0);
        this.tabPaneDeclaracoes.addTab("Em Preenchimento", new ImageIcon(this.getClass().getResource("/icones/png16px/Icon_barraTitulo_16px.png")), this.subpainelDeclaracoesPreenchimento);
        this.tabPaneDeclaracoes.addTab("Transmitidas", new ImageIcon(this.getClass().getResource("/icones/png16px/AB_transmitido.png")), this.subpainelDeclaracoesTransmitidas);
        this.tabPaneDeclaracoes.setMnemonicAt(0, 69);
        this.tabPaneDeclaracoes.setMnemonicAt(1, 82);
        this.configurarBotaoOK();
        this.configurarPainelComAbas();
    }

    private void configurarPainelComAbas() {
        this.tabPaneDeclaracoes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PainelImprimirDARFCodigoBarras.this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
                    PainelImprimirDARFCodigoBarras.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectionModel().clearSelection();
                    if (PainelImprimirDARFCodigoBarras.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                        PainelImprimirDARFCodigoBarras.this.btnOk.setEnabled(true);
                    } else {
                        PainelImprimirDARFCodigoBarras.this.btnOk.setEnabled(false);
                    }
                } else {
                    PainelImprimirDARFCodigoBarras.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectionModel().clearSelection();
                    if (PainelImprimirDARFCodigoBarras.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                        PainelImprimirDARFCodigoBarras.this.btnOk.setEnabled(true);
                    } else {
                        PainelImprimirDARFCodigoBarras.this.btnOk.setEnabled(false);
                    }
                }
            }
        });
    }

    private void configurarBotaoOK() {
        this.subpainelDeclaracoesPreenchimento.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelImprimirDARFCodigoBarras.this.tabPaneDeclaracoes.getSelectedIndex() == 0 && PainelImprimirDARFCodigoBarras.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDARFCodigoBarras.this.btnOk.setEnabled(true);
                } else {
                    PainelImprimirDARFCodigoBarras.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesPreenchimento.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelImprimirDARFCodigoBarras.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDARFCodigoBarras.this.btnOkActionPerformed(null);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelImprimirDARFCodigoBarras.this.tabPaneDeclaracoes.getSelectedIndex() == 1 && PainelImprimirDARFCodigoBarras.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDARFCodigoBarras.this.btnOk.setEnabled(true);
                } else {
                    PainelImprimirDARFCodigoBarras.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelImprimirDARFCodigoBarras.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDARFCodigoBarras.this.btnOkActionPerformed(null);
                }
            }
        });
    }

    public PainelImprimirDARFCodigoBarras(boolean salvarImagem) {
        this();
        if (salvarImagem) {
            this.jLabel1.setText("<HTML>Selecione o contribuinte cujos dados deseja salvar:</HTML>");
            this.rbImprimir.setVisible(false);
            this.rbVisualizar.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.rbImprimir = new JRadioButton();
        this.rbVisualizar = new JRadioButton();
        this.jLabel6 = new JLabel();
        this.tabPaneDeclaracoes = new JTabbedPane();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione o contribuinte cujos dados deseja imprimir:");
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDARFCodigoBarras.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDARFCodigoBarras.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.rbImprimir.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbImprimir);
        this.rbImprimir.setFont(FontesUtil.FONTE_NORMAL);
        this.rbImprimir.setText("Imprimir");
        this.rbVisualizar.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbVisualizar);
        this.rbVisualizar.setFont(FontesUtil.FONTE_NORMAL);
        this.rbVisualizar.setSelected(true);
        this.rbVisualizar.setText("Visualizar");
        this.jLabel6.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel6.setForeground(new Color(0, 74, 106));
        this.jLabel6.setText("Selecione a op\u00e7\u00e3o desejada:");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (Component)this.jLabel6, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnCancelar).add((Component)this.btnAjuda).add((Component)this.btnOk, -2, 104, -2))).add((Component)this.rbImprimir).add((Component)this.rbVisualizar)).add(75, 75, 75)));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel6, -2, 20, -2).addPreferredGap(0).add((Component)this.rbVisualizar).addPreferredGap(0).add((Component)this.rbImprimir).addPreferredGap(0, 35, Short.MAX_VALUE).add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).add(111, 111, 111)));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tabPaneDeclaracoes).addPreferredGap(1).add((Component)this.jPanel2, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 501, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(9, 9, 9).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add((Component)this.tabPaneDeclaracoes)).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione os contribuintes cujos dados deseja imprimir. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        this.cancelou = true;
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        if (this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
            int[] linhasSelecionadas = this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRows();
            int[] linhas = new int[linhasSelecionadas.length];
            for (int a = 0; a < linhas.length; ++a) {
                linhas[a] = ((TableRowSorter)this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
            }
            int[] rows = linhas;
            if (rows.length > 0) {
                IdentificadorDeclaracao id = this.subpainelDeclaracoesPreenchimento.getTabela().getIdentificadorDeclaracao(rows[0]);
                DeclaracaoIRPF dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(id.getCpf().naoFormatado(), id.getNumReciboTransmitido().naoFormatado());
                ImprimirDarfCodBarrasAction.imprimirDARF(dec, this.getTipoOperacao());
            }
        } else {
            int[] linhasSelecionadas = this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRows();
            int[] linhas = new int[linhasSelecionadas.length];
            for (int a = 0; a < linhas.length; ++a) {
                linhas[a] = ((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
            }
            int[] rows = linhas;
            if (rows.length > 0) {
                IdentificadorDeclaracao id = this.subpainelDeclaracoesTransmitidas.getTabela().getIdentificadorDeclaracao(rows[0]);
                DeclaracaoIRPF dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(id.getCpf().naoFormatado(), id.getNumReciboTransmitido().naoFormatado());
                ImprimirDarfCodBarrasAction.imprimirDARF(dec, this.getTipoOperacao());
            }
        }
    }

    public int getTipoOperacao() {
        if (this.rbVisualizar.isSelected()) {
            return 1;
        }
        if (this.rbImprimir.isSelected()) {
            return 3;
        }
        return 0;
    }

    public boolean isCancelou() {
        return this.cancelou;
    }
}

