/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoCriancaAdolescente;
import serpro.ppgd.irpf.doacaodeclaracao.EstatutoCriancaAdolescente;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesPreenchimento;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesTransmitidas;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.PainelDownloads;
import serpro.ppgd.irpf.gui.util.PdfUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.tabelas.TabelaDatasIRPF;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.util.LogPPGD;

public class PainelImprimirDarfECA
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Imprimir Darf - Doa\u00e7\u00f5es Diretamente na Declara\u00e7\u00e3o - ECA";
    private boolean cancelou = false;
    private SubpainelDeclaracoesPreenchimento subpainelDeclaracoesPreenchimento;
    private SubpainelDeclaracoesTransmitidas subpainelDeclaracoesTransmitidas;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel1;
    private JLabel jLabel6;
    private JPanel jPanel2;
    private JRadioButton rbImprimir;
    private JRadioButton rbVisualizar;
    private JTabbedPane tabPaneDeclaracoes;

    public PainelImprimirDarfECA() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.subpainelDeclaracoesPreenchimento = new SubpainelDeclaracoesPreenchimento();
        this.subpainelDeclaracoesPreenchimento.setSelectionMode(0);
        this.subpainelDeclaracoesTransmitidas = new SubpainelDeclaracoesTransmitidas();
        this.subpainelDeclaracoesTransmitidas.setSelectionMode(0);
        this.tabPaneDeclaracoes.addTab("Em Preenchimento", new ImageIcon(this.getClass().getResource("/icones/png16px/Icon_barraTitulo_16px.png")), this.subpainelDeclaracoesPreenchimento);
        this.tabPaneDeclaracoes.addTab("Transmitidas", new ImageIcon(this.getClass().getResource("/icones/png16px/AB_transmitido.png")), this.subpainelDeclaracoesTransmitidas);
        this.tabPaneDeclaracoes.setMnemonicAt(0, 69);
        this.tabPaneDeclaracoes.setMnemonicAt(1, 82);
        this.configurarBotaoOK();
        this.configurarPainelComAbas();
    }

    private void configurarPainelComAbas() {
        this.tabPaneDeclaracoes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PainelImprimirDarfECA.this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
                    PainelImprimirDarfECA.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectionModel().clearSelection();
                    if (PainelImprimirDarfECA.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                        PainelImprimirDarfECA.this.btnOk.setEnabled(true);
                    } else {
                        PainelImprimirDarfECA.this.btnOk.setEnabled(false);
                    }
                } else {
                    PainelImprimirDarfECA.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectionModel().clearSelection();
                    if (PainelImprimirDarfECA.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                        PainelImprimirDarfECA.this.btnOk.setEnabled(true);
                    } else {
                        PainelImprimirDarfECA.this.btnOk.setEnabled(false);
                    }
                }
            }
        });
    }

    private void configurarBotaoOK() {
        this.subpainelDeclaracoesPreenchimento.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelImprimirDarfECA.this.tabPaneDeclaracoes.getSelectedIndex() == 0 && PainelImprimirDarfECA.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDarfECA.this.btnOk.setEnabled(true);
                } else {
                    PainelImprimirDarfECA.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesPreenchimento.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelImprimirDarfECA.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDarfECA.this.btnOkActionPerformed(null);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelImprimirDarfECA.this.tabPaneDeclaracoes.getSelectedIndex() == 1 && PainelImprimirDarfECA.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDarfECA.this.btnOk.setEnabled(true);
                } else {
                    PainelImprimirDarfECA.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelImprimirDarfECA.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelImprimirDarfECA.this.btnOkActionPerformed(null);
                }
            }
        });
    }

    public PainelImprimirDarfECA(boolean salvarImagem) {
        this();
        if (salvarImagem) {
            this.jLabel1.setText("<HTML>Selecione o contribuinte cujos dados deseja salvar:</HTML>");
            this.rbImprimir.setVisible(false);
            this.rbVisualizar.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.rbImprimir = new JRadioButton();
        this.rbVisualizar = new JRadioButton();
        this.jLabel6 = new JLabel();
        this.tabPaneDeclaracoes = new JTabbedPane();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione o contribuinte cujos dados deseja imprimir:");
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDarfECA.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDarfECA.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.rbImprimir.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbImprimir);
        this.rbImprimir.setFont(FontesUtil.FONTE_NORMAL);
        this.rbImprimir.setText("Imprimir");
        this.rbVisualizar.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbVisualizar);
        this.rbVisualizar.setFont(FontesUtil.FONTE_NORMAL);
        this.rbVisualizar.setSelected(true);
        this.rbVisualizar.setText("Visualizar");
        this.jLabel6.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel6.setForeground(new Color(0, 74, 106));
        this.jLabel6.setText("Selecione a op\u00e7\u00e3o desejada:");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnCancelar).add((Component)this.btnAjuda).add((Component)this.btnOk, -2, 104, -2))).add((Component)this.rbImprimir).add((Component)this.rbVisualizar).add((Component)this.jLabel6)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel6, -2, 20, -2).addPreferredGap(0).add((Component)this.rbVisualizar).addPreferredGap(0).add((Component)this.rbImprimir).addPreferredGap(0, 39, Short.MAX_VALUE).add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).add(111, 111, 111)));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tabPaneDeclaracoes).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 502, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(9, 9, 9).add((Component)this.jPanel2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((Component)this.tabPaneDeclaracoes).addContainerGap()))));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione os contribuintes cujos dados deseja imprimir. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        this.cancelou = true;
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        if (this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
            int[] linhasSelecionadas = this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRows();
            int[] linhas = new int[linhasSelecionadas.length];
            for (int a = 0; a < linhas.length; ++a) {
                linhas[a] = ((TableRowSorter)this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
            }
            IdentificadorDeclaracao id = this.subpainelDeclaracoesPreenchimento.getTabela().getIdentificadorDeclaracao(linhas[0]);
            this.imprimirDarfsSelecionados(linhas, id);
        } else {
            int[] linhasSelecionadas = this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRows();
            int[] linhas = new int[linhasSelecionadas.length];
            for (int a = 0; a < linhas.length; ++a) {
                linhas[a] = ((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
            }
            IdentificadorDeclaracao id = this.subpainelDeclaracoesTransmitidas.getTabela().getIdentificadorDeclaracao(linhas[0]);
            this.imprimirDarfsSelecionados(linhas, id);
        }
    }

    private void imprimirDarfsSelecionados(int[] rows, final IdentificadorDeclaracao id) {
        if (rows.length > 0) {
            final DeclaracaoIRPF dec = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(id.getCpf().naoFormatado(), id.getNumReciboTransmitido().naoFormatado());
            try {
                if (dec == null) {
                    throw new AplicacaoException("Declara\u00e7\u00e3o n\u00e3o encontrada.", false);
                }
                if (!dec.getIdentificadorDeclaracao().isCompleta()) {
                    throw new AplicacaoException("darf_sem_info");
                }
                if (dec.getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoBruto().comparacao(">", dec.getColecaoEstatutoCriancaAdolescente().getTotalDeducaoIncentivoLiquido())) {
                    throw new AplicacaoException("darf_nao_gerado_doacao_diretamente_dec_excedeu_limite");
                }
                if (dec.getColecaoEstatutoCriancaAdolescente().existeMaisDeUmaDoacaoParaMesmoFundo()) {
                    throw new AplicacaoException("doacoes_diretamente_dec_mais_de_uma_doacao_mesmo_fundo");
                }
                if (dec.getColecaoEstatutoCriancaAdolescente().existeDoacaoComDadosIncompletos()) {
                    throw new AplicacaoException("darf_nao_gerado_doacao_diretamente_dec_informacoes_incompletas");
                }
                if (!ControladorGui.emFaseEntrega(dec.getEmCalamidade())) {
                    String dataFimEntrega = TabelaDatasIRPF.ConstantesDatas.dataFimRecepcao.getDataFormatada();
                    if (dec.getEmCalamidade().booleanValue()) {
                        dataFimEntrega = TabelaDatasIRPF.ConstantesDatas.dataFimRecepcaoCalamidade.getDataFormatada();
                    }
                    GuiUtil.mostrarInfo("doacao_eca_fora_prazo_entrega", new String[]{dataFimEntrega});
                    return;
                }
                final Data dataPAAux = new Data();
                dataPAAux.setConteudo("31/12/" + ConstantesGlobais.ANO_BASE);
                ColecaoEstatutoCriancaAdolescente colecaoEstatutoCriancaAdolescente = dec.getColecaoEstatutoCriancaAdolescente();
                if (colecaoEstatutoCriancaAdolescente.itens().isEmpty() || colecaoEstatutoCriancaAdolescente.todasDoacoesZeradas()) {
                    throw new AplicacaoException("darf_sem_info");
                }
                final PainelDownloads painelDownlodas = new PainelDownloads("Darf - ECA", null);
                final List itens = colecaoEstatutoCriancaAdolescente.itens();
                final SwingWorker<Map<String, byte[]>, Integer> sw = new SwingWorker<Map<String, byte[]>, Integer>(){

                    @Override
                    protected Map<String, byte[]> doInBackground() throws Exception {
                        HashMap<String, byte[]> darfs = new HashMap<String, byte[]>();
                        for (int i = 0; i < itens.size() && !this.isCancelled(); ++i) {
                            try {
                                this.publish(i + 1);
                                EstatutoCriancaAdolescente eca = (EstatutoCriancaAdolescente)itens.get(i);
                                byte[] pdf = PainelImprimirDarfECA.this.obterPdfDarfECA(dec, id.getCpf().naoFormatado(), id.getNome().naoFormatado(), dataPAAux, eca);
                                darfs.put(eca.getCnpjFundo().naoFormatado(), pdf);
                                continue;
                            }
                            catch (AplicacaoException e) {
                                throw e;
                            }
                            catch (BarramentoException e) {
                                throw new AplicacaoException(e.getMessage(), (Throwable)e, false);
                            }
                            catch (Throwable e) {
                                LogPPGD.erro((String)e.getMessage());
                                throw new AplicacaoException("Ocorreu um erro durante a gera\u00e7\u00e3o do Darf ECA.", e, false);
                            }
                        }
                        return darfs;
                    }

                    @Override
                    protected void process(List<Integer> chunks) {
                        for (Integer item : chunks) {
                            painelDownlodas.getLblDescricao().setText("Obtendo Darf " + item + " de " + itens.size());
                        }
                    }

                    @Override
                    protected void done() {
                        if (this.isCancelled()) {
                            GuiUtil.mostrarAviso(GuiUtil.getParent(PainelImprimirDarfECA.this), "OperacaoCancelada pelo usu\u00e1rio");
                        } else {
                            try {
                                GuiUtil.fecharDialog(painelDownlodas);
                                Map darfs = (Map)this.get();
                                String tipo = dec.getContribuinte().getDeclaracaoRetificadora().formatado().equals("1") ? "retif" : "origi";
                                PainelImprimirDarfECA.this.exibirPdfsDarfsECA(darfs, id.getCpf().naoFormatado(), tipo);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                Throwable cause = e.getCause();
                                if (cause != null && cause instanceof AplicacaoException) {
                                    GuiUtil.mostrarErro(GuiUtil.getParent(PainelImprimirDarfECA.this), cause.getMessage());
                                }
                                GuiUtil.mostrarErro(GuiUtil.getParent(PainelImprimirDarfECA.this), "Ocorreu um erro durante a gera\u00e7\u00e3o do Darf");
                            }
                        }
                    }
                };
                painelDownlodas.getBtnCancelar().setAction(new AbstractAction("Cancelar"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        sw.cancel(true);
                        GuiUtil.fecharDialog(painelDownlodas);
                    }
                });
                sw.execute();
                GuiUtil.exibeDialog(painelDownlodas, true, "Imprimir Darf", false);
            }
            catch (AplicacaoException e) {
                e.printStackTrace();
                GuiUtil.mostrarErro(GuiUtil.getParent(this), e.getMessage());
            }
            catch (Throwable e) {
                e.printStackTrace();
                GuiUtil.mostrarErro(GuiUtil.getParent(this), "Ocorreu um erro durante a gera\u00e7\u00e3o do Darf");
            }
        }
    }

    private void exibirPdfsDarfsECA(Map<String, byte[]> darfs, String cpfContribuinte, String tipoDec) {
        for (String cnpjFundo : darfs.keySet()) {
            byte[] pdf = darfs.get(cnpjFundo);
            String nomeArq = IRPFUtil.obterNomeArquivoPDF((String)cpfContribuinte, (String)tipoDec, (String)"darfeca", (String)cnpjFundo);
            String path = new File(FileSystemView.getFileSystemView().getDefaultDirectory(), nomeArq).getAbsolutePath();
            PdfUtil.exibirPdf(pdf, "Darf - Doa\u00e7\u00f5es Diretamente na Declara\u00e7\u00e3o - ECA", path);
        }
    }

    private byte[] obterPdfDarfECA(DeclaracaoIRPF dec, String cpf, String nomeContribuinte, Data periodoApuracao, EstatutoCriancaAdolescente doacao) throws BarramentoException, AplicacaoException {
        try {
            Object descricoesAdicionais;
            String descricaoPrincipal;
            String observacoes = "Caso seja feriado local, antecipe o pagamento||Imposto sobre a Renda da Pessoa F\u00edsica " + ConstantesGlobais.EXERCICIO;
            if ("N".equals(doacao.getTipoFundo().naoFormatado())) {
                descricaoPrincipal = "Doa\u00e7\u00f5es a Fundos ECA";
                descricoesAdicionais = "Fundo Nacional - CNPJ " + doacao.getCnpjFundo().formatado() + "|";
            } else if ("E".equals(doacao.getTipoFundo().naoFormatado())) {
                if ("DF".equals(doacao.getUf().naoFormatado())) {
                    descricaoPrincipal = "Doa\u00e7\u00f5es a Fundos ECA";
                    descricoesAdicionais = "Fundo do Distrito Federal - CNPJ " + doacao.getCnpjFundo().formatado() + "|";
                } else {
                    descricaoPrincipal = "Doa\u00e7\u00f5es a Fundos ECA";
                    descricoesAdicionais = "Fundo Estadual - " + doacao.getUf().naoFormatado() + " - CNPJ " + doacao.getCnpjFundo().formatado() + "|";
                }
            } else if ("M".equals(doacao.getTipoFundo().naoFormatado())) {
                descricaoPrincipal = "Doa\u00e7\u00f5es a Fundos ECA";
                descricoesAdicionais = "Fundo Municipal - " + doacao.getNomeMunicipio() + " - " + doacao.getUf().naoFormatado() + " - CNPJ " + doacao.getCnpjFundo().formatado() + "|";
            } else {
                descricaoPrincipal = "";
                descricoesAdicionais = "|";
            }
            Data dataVencimento = new Data();
            dataVencimento.setConteudo(TabelaDatasIRPF.obterVencimentosQuotas((boolean)dec.getEmCalamidade())[0]);
            return BarramentoIRPFService.obterPdfDarfECA((String)cpf, (String)nomeContribuinte, (String)observacoes, (String)descricaoPrincipal, (String)descricoesAdicionais, (Date)periodoApuracao.asDate(), (Date)dataVencimento.asDate(), (Date)dataVencimento.asDate(), (Double)Double.valueOf(doacao.getValor().getParteInteira() + "." + doacao.getValor().getParteDecimal()), (String)doacao.getCnpjFundo().naoFormatado(), (String)dec.getContribuinte().getMunicipio().naoFormatado());
        }
        catch (Throwable e) {
            throw new AplicacaoException("Ocorreu um erro durante gera\u00e7\u00e3o do Darf.", e);
        }
    }

    public int getTipoOperacao() {
        if (this.rbVisualizar.isSelected()) {
            return 1;
        }
        if (this.rbImprimir.isSelected()) {
            return 3;
        }
        return 0;
    }

    public boolean isCancelou() {
        return this.cancelou;
    }
}

