/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesTransmitidas;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.util.MensagemUtil;

public class PainelRetificarDeclaracao
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Declara\u00e7\u00e3o de Ajuste Anual/Retifica\u00e7\u00e3o da Declara\u00e7\u00e3o";
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private SubpainelDeclaracoesTransmitidas subpainelDeclaracoesTransmitidas;

    public PainelRetificarDeclaracao() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.configurarPainelDeclaracoes();
    }

    private void configurarPainelDeclaracoes() {
        this.subpainelDeclaracoesTransmitidas.getTabela().setSelectionMode(0);
        this.subpainelDeclaracoesTransmitidas.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelRetificarDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelRetificarDeclaracao.this.btnOk.setEnabled(true);
                } else {
                    PainelRetificarDeclaracao.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelRetificarDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelRetificarDeclaracao.this.btnOkActionPerformed(null);
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.subpainelDeclaracoesTransmitidas = new SubpainelDeclaracoesTransmitidas();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione a declara\u00e7\u00e3o que deseja retificar");
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelRetificarDeclaracao.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelRetificarDeclaracao.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnOk, -1, 90, Short.MAX_VALUE).add((Component)this.btnCancelar, -1, 90, Short.MAX_VALUE).add((Component)this.btnAjuda, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk}, 2);
        this.btnOk.getAccessibleContext().setAccessibleName("OK");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subpainelDeclaracoesTransmitidas, -1, 782, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2))).add(6, 6, 6)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(36, 36, 36)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subpainelDeclaracoesTransmitidas, -1, 326, Short.MAX_VALUE).addContainerGap()))));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione a declara\u00e7\u00e3o que deseja abrir. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        GuiUtil.fecharDialog(this);
        int linha = ((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToModel(this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRow());
        IdentificadorDeclaracao id = this.subpainelDeclaracoesTransmitidas.getTabela().getIdentificadorDeclaracao(linha);
        String cpf = id.getCpf().naoFormatado();
        if (id.getTpTransmitida().naoFormatado().equals("10") || id.getTpTransmitida().naoFormatado().equals("11") || id.getTpTransmitida().naoFormatado().equals("12")) {
            String mensagemTpTransmitida = CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00519);
            if (mensagemTpTransmitida.isEmpty()) {
                mensagemTpTransmitida = "A declara\u00e7\u00e3o anterior foi transmitida pelo MIR. Se voc\u00ea prosseguir com a retifica\u00e7\u00e3o, haver\u00e1 perda de dados.";
            }
            GuiUtil.mostrarAviso(mensagemTpTransmitida);
        }
        if (!IRPFFacade.existeDeclaracaoEmPreenchimento((String)cpf)) {
            if (GuiUtil.mostrarConfirma(null, "Uma c\u00f3pia da declara\u00e7\u00e3o selecionada ser\u00e1 disponibilizada na aba \"Em Preenchimento\". \nDeseja continuar?")) {
                ControladorGui.retificarDeclaracaoTransmitida(id, this.subpainelDeclaracoesTransmitidas.getNumeroReciboSelecionado());
            }
        } else if (GuiUtil.mostrarConfirma(null, MensagemUtil.getMensagem((String)"ja_existe_declaracao_preenchimento"))) {
            ControladorGui.retificarDeclaracaoTransmitida(id, this.subpainelDeclaracoesTransmitidas.getNumeroReciboSelecionado());
        }
    }
}

