/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import serpro.ppgd.app.acoes.LoginGovAction;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileFilter;
import serpro.ppgd.gui.xbeans.JEditCPF;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.dialogs.PainelCriarNovaDeclaracao;
import serpro.ppgd.irpf.gui.dialogs.PainelResultadoImportacao;
import serpro.ppgd.irpf.gui.update.PainelDownloadAtualizacoes;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.ProgressMonitor;
import serpro.ppgd.irpf.gui.util.ProgressUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.RetornoBarramento;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.irpf.txt.gravacaorestauracao.GravadorTXT;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ImportadorPrePreenchida;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ImportadorTxt;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;

public class SubPainelDeclaracaoPrePreenchida
extends JPanel {
    private PainelCriarNovaDeclaracao painelPai;
    private static final long serialVersionUID = 1L;
    private JButton btnOk;
    private ButtonGroup buttonGroup1;
    private JEditCPF edtCpf;
    private IRPFLabelInfo iRPFLabelInfo1;
    private JPanel jPanel1;
    private JLabel lblAcaoIniciarDeclaracao;
    private JLabel lblCpf;
    private JPanel pnlCPF;
    private JPanel pntTitulo;
    private JRadioButton rdbComProcuracao;
    private JRadioButton rdbSemProcuracao;

    public SubPainelDeclaracaoPrePreenchida(PainelCriarNovaDeclaracao painelPai) {
        this.initComponents();
        this.painelPai = painelPai;
        final CPF cpf = new CPF(null, "CPF do declarante");
        cpf.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        cpf.addValidador((ValidadorIf)new ValidadorCPF(3){

            public RetornoValidacao validarImplementado() {
                super.setMensagemValidacao(MensagemUtil.getMensagem((String)"campo_invalido", (String[])new String[]{cpf.getNomeCampo()}));
                return super.validarImplementado();
            }
        });
        this.edtCpf.setInformacao((Informacao)cpf);
        this.limparTela();
    }

    public void obterFoco() {
        this.rdbSemProcuracao.requestFocusInWindow();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.pntTitulo = new JPanel();
        this.lblAcaoIniciarDeclaracao = new JLabel();
        this.iRPFLabelInfo1 = new IRPFLabelInfo(CadastroTabelasIRPF.recuperarMensagemComQuebra((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00510));
        this.jPanel1 = new JPanel();
        this.rdbSemProcuracao = new JRadioButton();
        this.rdbComProcuracao = new JRadioButton();
        this.pnlCPF = new JPanel();
        this.edtCpf = new JEditCPF();
        this.lblCpf = new JLabel();
        this.btnOk = new JButton();
        this.setBackground(new Color(254, 254, 254));
        this.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.pntTitulo.setBackground(new Color(205, 224, 239));
        this.lblAcaoIniciarDeclaracao.setFont(FontesUtil.FONTE_MAIOR);
        this.lblAcaoIniciarDeclaracao.setForeground(new Color(0, 74, 106));
        this.lblAcaoIniciarDeclaracao.setText("Obter Declara\u00e7\u00e3o Pr\u00e9-Preenchida");
        GroupLayout pntTituloLayout = new GroupLayout(this.pntTitulo);
        this.pntTitulo.setLayout(pntTituloLayout);
        pntTituloLayout.setHorizontalGroup(pntTituloLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pntTituloLayout.createSequentialGroup().addContainerGap().addComponent(this.lblAcaoIniciarDeclaracao).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 504, Short.MAX_VALUE).addComponent(this.iRPFLabelInfo1, -2, -1, -2).addContainerGap()));
        pntTituloLayout.setVerticalGroup(pntTituloLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAcaoIniciarDeclaracao, -1, 28, Short.MAX_VALUE).addComponent(this.iRPFLabelInfo1, -1, -1, Short.MAX_VALUE));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.rdbSemProcuracao.setBackground(new Color(255, 255, 255));
        this.buttonGroup1.add(this.rdbSemProcuracao);
        this.rdbSemProcuracao.setText("Declara\u00e7\u00e3o pr\u00f3pria");
        this.rdbSemProcuracao.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SubPainelDeclaracaoPrePreenchida.this.rdbSemProcuracaoItemStateChanged(evt);
            }
        });
        this.rdbComProcuracao.setBackground(new Color(255, 255, 255));
        this.buttonGroup1.add(this.rdbComProcuracao);
        this.rdbComProcuracao.setText("Declara\u00e7\u00e3o por procura\u00e7\u00e3o");
        this.rdbComProcuracao.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SubPainelDeclaracaoPrePreenchida.this.rdbComProcuracaoItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.rdbSemProcuracao).addGap(28, 28, 28).addComponent(this.rdbComProcuracao).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rdbSemProcuracao).addComponent(this.rdbComProcuracao)).addGap(20, 20, 20)));
        this.pnlCPF.setBackground(new Color(255, 255, 255));
        this.lblCpf.setForeground(new Color(0, 74, 106));
        this.lblCpf.setText("CPF do declarante");
        GroupLayout pnlCPFLayout = new GroupLayout(this.pnlCPF);
        this.pnlCPF.setLayout(pnlCPFLayout);
        pnlCPFLayout.setHorizontalGroup(pnlCPFLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCPFLayout.createSequentialGroup().addContainerGap().addGroup(pnlCPFLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblCpf).addComponent((Component)this.edtCpf, -2, 147, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlCPFLayout.setVerticalGroup(pnlCPFLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCPFLayout.createSequentialGroup().addContainerGap().addComponent(this.lblCpf).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtCpf, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.btnOk.setMnemonic('o');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SubPainelDeclaracaoPrePreenchida.this.btnOkActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pntTitulo, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(49, 49, 49).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.pnlCPF, -2, -1, -2).addGap(18, 18, 18).addComponent(this.btnOk, -2, 63, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pntTitulo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pnlCPF, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btnOk, -2, 27, -2).addContainerGap()).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))));
        this.getAccessibleContext().setAccessibleName("Obter declara\u00e7\u00e3o pr\u00e9-preenchida");
    }

    private void rdbSemProcuracaoItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.pnlCPF.setVisible(false);
            this.edtCpf.getInformacao().clear();
        }
    }

    private void rdbComProcuracaoItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.pnlCPF.setVisible(true);
        }
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        this.importarPrePreenchida();
    }

    public void limparTela() {
        this.rdbSemProcuracao.setSelected(true);
    }

    public void importarPrePreenchida() {
        String cpf;
        if (this.painelPai.getTipoDeclaracao() == null) {
            return;
        }
        this.edtCpf.getInformacao().validar();
        if (this.rdbComProcuracao.isSelected()) {
            if (!this.edtCpf.getInformacao().isValido()) {
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), new JLabel(this.edtCpf.getInformacao().getPrimeiroRetornoValidacaoMaisSevero().getMensagemValidacao()), "Erro", 0);
                this.edtCpf.getComponenteFoco().requestFocusInWindow();
                return;
            }
            cpf = this.edtCpf.getInformacao().naoFormatado();
        } else {
            cpf = null;
        }
        this.iniciar(cpf, this.painelPai.getTipoDeclaracao());
    }

    @Deprecated
    public void iniciar(TipoDeclaracaoAES tipoDeclaracao) {
        this.importar(tipoDeclaracao);
        ControladorGui.atualizarNumeroDemonstrativos();
    }

    public void iniciar(String cpfDeclaracao, TipoDeclaracaoAES tipoDeclaracao) {
        this.importar(cpfDeclaracao, tipoDeclaracao);
        ControladorGui.atualizarNumeroDemonstrativos();
    }

    public void executarImportar(File[] selectedFiles, TipoDeclaracaoAES tipoDeclaracaoAES) {
        new TarefaImportar(selectedFiles, tipoDeclaracaoAES).start();
    }

    @Deprecated
    public void importar(TipoDeclaracaoAES tipoDeclaracaoAES) {
        FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
        fc.setDialogTitle("Importa\u00e7\u00e3o da Declara\u00e7\u00e3o Pr\u00e9-preenchida do IRPF " + ConstantesGlobais.EXERCICIO);
        fc.setApproveButtonText("OK");
        fc.setApproveButtonToolTipText("Importa dados da declara\u00e7\u00e3o pr\u00e9-preenchida do IRPF " + ConstantesGlobais.EXERCICIO);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter((FileFilter)new ImportadorPrePreenchida.DECFilter());
        fc.setMultiSelectionEnabled(true);
        FileChooserResponse ret = fc.showOpenDialog((Component)ControladorGui.getJanelaPrincipal());
        if (ret == FileChooserResponse.APPROVE_OPTION) {
            File[] selectedFiles = fc.getSelectedFiles();
            this.executarImportar(selectedFiles, tipoDeclaracaoAES);
        }
    }

    public void importar(String cpfDeclaracao, TipoDeclaracaoAES tipoDeclaracaoAES) {
        UsuarioLogado usuarioGov = BarramentoIRPFService.getUsuarioLogado();
        if (usuarioGov == null) {
            try {
                new LoginGovAction().iniciarLogon(usuarioLogado -> this.obterArquivoPrePreenchida(cpfDeclaracao, tipoDeclaracaoAES, usuarioLogado));
            }
            catch (AplicacaoException e) {
                GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), e.getMessage());
                return;
            }
        } else {
            this.obterArquivoPrePreenchida(cpfDeclaracao, tipoDeclaracaoAES, usuarioGov);
        }
    }

    public void obterArquivoPrePreenchida(final String cpfDeclaracao, final TipoDeclaracaoAES tipoDeclaracaoAES, UsuarioLogado usuarioGov) {
        if (!"ouro".equals(usuarioGov.getNivelAcessoGov()) && !"prata".equals(usuarioGov.getNivelAcessoGov())) {
            String msg = CadastroTabelasIRPF.recuperarMensagemHTML((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00505);
            GuiUtil.mostrarErroHTML(msg);
            return;
        }
        final PainelDownloadAtualizacoes painelDownload = new PainelDownloadAtualizacoes("Importando Declara\u00e7\u00e3o Pr\u00e9-Preenchida", GuiUtil.getImage("/icones/png20px/MN_prepreenchida.png"));
        painelDownload.getLblDescricao().setText("Importando...");
        painelDownload.getLblPercentual().setText("");
        painelDownload.getProgressBar().setIndeterminate(true);
        final SwingWorker<RetornoBarramento, Void> sw = new SwingWorker<RetornoBarramento, Void>(){

            @Override
            protected RetornoBarramento doInBackground() throws Exception {
                String cpf = cpfDeclaracao;
                if (cpf == null) {
                    cpf = BarramentoIRPFService.getUsuarioLogado().getCpf();
                }
                return BarramentoIRPFService.obterPrePreenchida((String)cpf);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                String ex = null;
                RetornoBarramento retorno = null;
                try {
                    retorno = (RetornoBarramento)this.get();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    Throwable cause = e.getCause();
                    ex = cause != null && (cause instanceof BarramentoException || cause instanceof AplicacaoException) ? (cause instanceof BarramentoException && "99".equals(((BarramentoException)cause).getCodigoRetorno()) ? CadastroTabelasIRPF.recuperarMensagemComQuebra((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00508) : (cause instanceof BarramentoException && "58".equals(((BarramentoException)cause).getCodigoRetorno()) ? CadastroTabelasIRPF.recuperarMensagemComQuebra((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00112) : cause.getMessage())) : "Ocorreu um erro durante importacao da declara\u00e7\u00e3o Pre-Preenchida.";
                }
                catch (Exception e) {
                    ex = "A opera\u00e7\u00e3o foi cancelada.";
                }
                finally {
                    GuiUtil.fecharDialog(painelDownload);
                }
                if (ex != null) {
                    GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), ex);
                } else {
                    try {
                        byte[] conteudo = Base64.decodeBase64((byte[])retorno.getConteudo().getBytes(StandardCharsets.UTF_8));
                        File arquivo = GravadorTXT.salvarArquivoTemporario((String)new String(conteudo, StandardCharsets.UTF_8));
                        SubPainelDeclaracaoPrePreenchida.this.executarImportar(new File[]{arquivo}, tipoDeclaracaoAES);
                    }
                    catch (GeracaoTxtException e) {
                        GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), "Ocorreu um erro durante importa\u00e7\u00e3o da declara\u00e7\u00e3o Pre-Preenchida. N\u00e3o foi poss\u00edvel salvar a declara\u00e7\u00e3o.");
                    }
                }
            }
        };
        painelDownload.getBtnCancelar().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sw.cancel(true);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painelDownload, true, "Obter Declara\u00e7\u00e3o Pr\u00e9-Preenchida", false, null, null, false, 2, false, true);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                sw.execute();
            }
        });
    }

    public class TarefaImportar
    extends Thread {
        private File[] selectedFiles;
        private TipoDeclaracaoAES tipoDeclaracaoAES;

        public TarefaImportar(File[] selectedFiles, TipoDeclaracaoAES tipoDeclaracaoAES) {
            this.selectedFiles = selectedFiles;
            this.tipoDeclaracaoAES = tipoDeclaracaoAES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuffer arquivosComSucesso = new StringBuffer();
            StringBuffer arquivosComErro = new StringBuffer();
            boolean concluiuImportacao = false;
            ProgressMonitor monitor = null;
            int qtdTotal = 0;
            try {
                String msgConfirmacao = null;
                IRPFFacade.setCacheIdDeclaracao((boolean)true);
                qtdTotal = this.selectedFiles.length;
                monitor = ProgressUtil.createProgressMonitor(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), qtdTotal, false, 1000, "Importando");
                boolean confirmacao = true;
                IdentificadorDeclaracao idDeclaracao = null;
                try {
                    for (int i = 0; i < qtdTotal; ++i) {
                        confirmacao = true;
                        try {
                            if (i == 0) {
                                monitor.start("Importando " + (i + 1) + " de " + qtdTotal);
                                Thread.sleep(1000L);
                            } else {
                                monitor.setCurrent("Importando " + (i + 1) + " de " + qtdTotal, i + 1);
                            }
                            ImportadorTxt importador = new ImportadorTxt();
                            idDeclaracao = importador.restaurarIdDeclaracao(this.selectedFiles[i], false);
                            if (IRPFFacade.existeDeclaracao((String)idDeclaracao.getCpf().naoFormatado(), (String)"0000000000")) {
                                msgConfirmacao = "<html>J\u00e1 existe declara\u00e7\u00e3o do exerc\u00edcio de " + ConstantesGlobais.EXERCICIO + " para o CPF " + idDeclaracao.getCpf().formatado() + " em sua base de dados. <br>Se importar os dados da pr\u00e9-preenchida de " + ConstantesGlobais.EXERCICIO + ", as informa\u00e7\u00f5es existentes ser\u00e3o substitu\u00eddas<br>integralmente. <br><br>Deseja importar os dados da declara\u00e7\u00e3o pr\u00e9-preenchida de " + ConstantesGlobais.EXERCICIO + "?</html>";
                                if (!GuiUtil.mostrarConfirma(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), msgConfirmacao)) {
                                    confirmacao = false;
                                } else {
                                    ArrayList<IdentificadorDeclaracao> listaIds = new ArrayList<IdentificadorDeclaracao>(1);
                                    listaIds.add(idDeclaracao);
                                    ControladorGui.excluirDemonstrativo(listaIds);
                                }
                            }
                            if (!confirmacao) continue;
                            DeclaracaoIRPF dec = importador.restaurarDeclaracao(this.selectedFiles[i], false, true);
                            idDeclaracao = dec.getIdentificadorDeclaracao();
                            idDeclaracao.getTipoDeclaracaoAES().setConteudo(this.tipoDeclaracaoAES.getTipo());
                            idDeclaracao.getPrepreenchida().setConteudo(Logico.SIM);
                            idDeclaracao.getInNovaDeclaracao().setConteudo(Logico.NAO);
                            idDeclaracao.getTpIniciada().setConteudo("01");
                            idDeclaracao.getPrepreenchida().setConteudo(Logico.SIM);
                            idDeclaracao.getInUtilizouAPP().setConteudo(Logico.NAO);
                            idDeclaracao.getInUtilizouOnLine().setConteudo(Logico.NAO);
                            idDeclaracao.getInUtilizouRascunho().setConteudo(Logico.NAO);
                            idDeclaracao.getInUtilizouAssistidaFontePagadora().setConteudo(Logico.NAO);
                            idDeclaracao.getInUtilizouAssistidaPlanoSaude().setConteudo(Logico.NAO);
                            idDeclaracao.getInUtilizouSalvarRecuperarOnLine().setConteudo(Logico.NAO);
                            idDeclaracao.getDataCriacao().clear();
                            if (idDeclaracao.isEspolio()) {
                                dec.getContribuinte().getNaturezaOcupacao().setConteudo("81");
                                dec.getContribuinte().getNaturezaOcupacao().setHabilitado(false);
                            }
                            ControladorGui.salvarDemonstrativo(dec);
                            CacheNI.getInstancia().importarNIs((ObjetoNegocio)dec, true);
                            IRPFFacade.limpaCacheDeclaracoes();
                            concluiuImportacao = true;
                            arquivosComSucesso.append(this.selectedFiles[i].getName() + "\n");
                            continue;
                        }
                        catch (Throwable e) {
                            arquivosComErro.append(this.selectedFiles[i].getName() + "\n");
                            e.printStackTrace();
                            LogPPGD.erro((String)e.getMessage());
                            IRPFFacade.excluirDeclaracao(idDeclaracao);
                        }
                    }
                }
                finally {
                    if (monitor != null) {
                        monitor.setCurrent("Importando " + qtdTotal + " de " + qtdTotal, qtdTotal);
                    }
                    FileUtils.deleteDirectory((File)new File(ImportadorPrePreenchida.CAMINHO_TEMP_PREPREENCHIDA));
                }
                if (this.selectedFiles.length == 1) {
                    if (concluiuImportacao) {
                        String msg = CadastroTabelasIRPF.recuperarMensagemComQuebra((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00501);
                        GuiUtil.mostrarInfo(GuiUtil.getParent(), msg);
                        ControladorGui.abrirDemonstrativo(idDeclaracao, true);
                    } else if (!confirmacao) {
                        GuiUtil.mostrarInfo("importar_prepreenchida_cancelado");
                    } else {
                        GuiUtil.mostrarInfo("importar_prepreenchida_erro");
                    }
                } else {
                    PainelResultadoImportacao painelResultadoImportacaoAnoAnterior = new PainelResultadoImportacao();
                    if (arquivosComSucesso.toString().length() > 0) {
                        painelResultadoImportacaoAnoAnterior.setListaDeclaracoesImportadasOK(arquivosComSucesso.toString());
                    }
                    if (arquivosComErro.toString().length() > 0) {
                        painelResultadoImportacaoAnoAnterior.setListaDeclaracoesImportadasErro(arquivosComErro.toString());
                    }
                    GuiUtil.exibeDialog(painelResultadoImportacaoAnoAnterior, true, MensagemUtil.getMensagem((String)"importar_prepreenchida_titulo", (String[])new String[]{ConstantesGlobais.EXERCICIO}), false, 460, 300);
                }
            }
            catch (Exception e) {
                ControladorGui.tratarException(e);
            }
            finally {
                IRPFFacade.setCacheIdDeclaracao((boolean)false);
            }
        }
    }
}

