/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.nuvem;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import serpro.ppgd.negocio.util.LogPPGD;

public final class CaptchaUtil {
    private CaptchaUtil() {
    }

    public static ImageIcon obterCaptcha(String captchaBase64) {
        try {
            byte[] btDataFile = Base64.decodeBase64((String)captchaBase64);
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(btDataFile));
            return new ImageIcon(image);
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
            return null;
        }
    }

    public static void ouvirAudioCaptcha(byte[] som) {
        try {
            final Clip clip = (Clip)AudioSystem.getLine(new Line.Info(Clip.class));
            clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent event) {
                    if (event.getType() == LineEvent.Type.STOP) {
                        clip.close();
                    }
                }
            });
            clip.open(AudioSystem.getAudioInputStream(new ByteArrayInputStream(som)));
            clip.start();
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }
}

