/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.util;

import javax.swing.JLabel;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.resumo.CalculoImposto;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;

public class GuiContas {
    public static String definirMensagemConta(Codigo banco, int digitos, Codigo tipoConta, boolean isRestituicao) {
        String mensagem = "";
        String[] mensagem_parametros = GuiContas.obterParametroMensagem(digitos, isRestituicao);
        String codBanco = banco.naoFormatado();
        if (CalculoImposto.getBancosDebito().contains(codBanco)) {
            mensagem = "104".equals(codBanco) ? (isRestituicao ? MensagemUtil.getMensagem((String)"msg_informacao_conta_caixa_credito", (String[])mensagem_parametros) : MensagemUtil.getMensagem((String)"msg_informacao_conta_caixa_debito", (String[])mensagem_parametros)) : ("399".equals(codBanco) ? MensagemUtil.getMensagem((String)"msg_informacao_conta_hsbc", (String[])mensagem_parametros) : ("070".equals(codBanco) ? MensagemUtil.getMensagem((String)"msg_informacao_conta_caixa_brb", (String[])mensagem_parametros) : ("001".equals(codBanco) && "2".equals(tipoConta.naoFormatado()) ? MensagemUtil.getMensagem((String)"msg_informacao_conta_bb", (String[])mensagem_parametros) : MensagemUtil.getMensagem((String)"msg_informacao_digitos_conta", (String[])mensagem_parametros))));
        }
        return mensagem;
    }

    private static String[] obterParametroMensagem(int digitos, boolean isRestituicao) {
        if (isRestituicao) {
            return new String[]{"cr\u00e9dito", String.valueOf(digitos)};
        }
        return new String[]{"debito", String.valueOf(digitos)};
    }

    public static String definirMensagemContaCredito(Codigo banco, int digitos) {
        String codBanco = banco.naoFormatado();
        String mensagem = "";
        return mensagem;
    }

    public String definirMensagemContaDebito(Codigo banco, int digitos) {
        String codBanco = banco.naoFormatado();
        String mensagem = "";
        mensagem = "104".equals(codBanco) ? MensagemUtil.getMensagem((String)"msg_informacao_conta_caixa_debito", (String[])new String[]{"d\u00e9bito"}) : ("399".equals(codBanco) ? MensagemUtil.getMensagem((String)"msg_informacao_conta_hsbc", (String[])new String[]{"d\u00e9bito"}) : ("070".equals(codBanco) ? MensagemUtil.getMensagem((String)"msg_informacao_conta_caixa_brb", (String[])new String[]{"d\u00e9bito"}) : ("001".equals(codBanco) ? MensagemUtil.getMensagem((String)"msg_informacao_conta_bb", (String[])new String[]{"d\u00e9bito"}) : MensagemUtil.getMensagem((String)"msg_informacao_digitos_conta", (String[])new String[]{"d\u00e9bito", String.valueOf(digitos)}))));
        return mensagem;
    }

    public static int definirDigitosConta(Codigo banco, Codigo tipoConta, Boolean temOperacao) {
        int digitos;
        String codBanco = banco.naoFormatado();
        String codTipoConta = tipoConta.naoFormatado();
        try {
            digitos = "3".equals(tipoConta.naoFormatado()) ? 20 : Integer.parseInt(banco.getConteudoAtual(6));
        }
        catch (Exception e) {
            digitos = "3".equals(tipoConta.naoFormatado()) ? 20 : 13;
        }
        if ("3".equals(codTipoConta)) {
            digitos = 20;
        } else if ("001".equals(codBanco) && "2".equals(codTipoConta)) {
            digitos = 9;
        } else if ("104".equals(codBanco)) {
            digitos = temOperacao != false ? 8 : 12;
        }
        return digitos;
    }

    public static int definirDigitosContaCorrente(Codigo banco, Codigo tipoConta, Boolean temOperacao) {
        Codigo lTipoConta = new Codigo("1");
        if (!tipoConta.isVazio()) {
            lTipoConta.setConteudo(tipoConta);
        }
        return GuiContas.definirDigitosConta(banco, lTipoConta, temOperacao);
    }

    public static void configurarExibicaoInfoConta(Informacao banco, IRPFLabelInfo lblInfo, JLabel lblInfoCEF) {
        if (banco.isVazio()) {
            lblInfo.setVisible(false);
            lblInfoCEF.setVisible(false);
        } else {
            lblInfoCEF.setVisible(banco.naoFormatado().equals("104"));
            if (lblInfo.getMensagem().isBlank()) {
                lblInfo.setVisible(false);
            } else {
                lblInfo.setVisible(!banco.naoFormatado().equals("104"));
            }
        }
    }

    public static boolean isContaPagamentoComCEF(DeclaracaoIRPF dec) {
        boolean retorno = false;
        if (dec.temImpostoARestituir() && CadastroTabelasIRPF.TIPO_CONTA_PAGAMENTO.equals(dec.getResumo().getCalculoImposto().getTipoConta().naoFormatado()) && "104".equals(dec.getResumo().getCalculoImposto().getBanco().naoFormatado())) {
            retorno = true;
        }
        return retorno;
    }
}

