/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.util.tabs;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.basic.BasicButtonUI;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.tabs.JTaskTabs;

public class ButtonTabComponent
extends JPanel {
    private final JTaskTabs taskTabs;
    private static final MouseListener buttonMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public ButtonTabComponent(final JTaskTabs taskTabs, boolean abaFixa) {
        super(new FlowLayout(0, 0, 0));
        if (taskTabs == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.taskTabs = taskTabs;
        this.setOpaque(false);
        JLabel label = new JLabel(){

            @Override
            public String getText() {
                int i = taskTabs.getTabbedPane().indexOfTabComponent(ButtonTabComponent.this);
                if (i != -1) {
                    return taskTabs.getTabbedPane().getTitleAt(i);
                }
                return null;
            }
        };
        if (abaFixa) {
            this.add(new JLabel(GuiUtil.getImage("/icones/png16px/Icon_barraTitulo_16px.png")));
            this.add(new JLabel("  "));
        } else {
            this.add(new JLabel(" "));
        }
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        if (!abaFixa) {
            TabButton button = new TabButton();
            this.add(button);
        } else {
            this.add(new JLabel("   "));
        }
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private class TabButton
    extends JButton
    implements ActionListener {
        public TabButton() {
            int size = 17;
            this.setPreferredSize(new Dimension(size, size));
            this.setToolTipText("Fechar");
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.addMouseListener(buttonMouseListener);
            this.setRolloverEnabled(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ButtonTabComponent.this.taskTabs.getTabbedPane().indexOfTabComponent(ButtonTabComponent.this);
            if (i != -1) {
                ButtonTabComponent.this.taskTabs.removeAba(i);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            g2.setStroke(new BasicStroke(1.0f));
            g2.setColor(Color.BLACK);
            if (this.getModel().isRollover()) {
                // empty if block
            }
            int delta = 6;
            g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
            g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
            g2.dispose();
        }
    }
}

