/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.eventos;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import serpro.ppgd.infraestrutura.eventos.Evento;
import serpro.ppgd.infraestrutura.eventos.EventoOutput;

public class BarramentoEventos {
    protected static BarramentoEventos instancia = null;
    private ArrayList<WeakReference<Object>> objsOutput = new ArrayList();

    public void registraOutput(Object out) {
        this.objsOutput.add(new WeakReference<Object>(out));
    }

    public boolean input(String nomeEvento) {
        return this.input(nomeEvento, null);
    }

    public boolean input(String nomeEvento, Object dados) {
        boolean eventoTeveOutput = false;
        ArrayList<WeakReference<Object>> copyObjsOutput = new ArrayList<WeakReference<Object>>(this.objsOutput);
        Iterator<WeakReference<Object>> it = copyObjsOutput.iterator();
        while (it.hasNext()) {
            WeakReference<Object> ref = it.next();
            Object obj = ref.get();
            if (obj == null) {
                it.remove();
                this.objsOutput.remove(ref);
                continue;
            }
            for (Method method : obj.getClass().getDeclaredMethods()) {
                if (!method.isAnnotationPresent(EventoOutput.class)) continue;
                EventoOutput annotation = method.getAnnotation(EventoOutput.class);
                for (String tipoEvento : annotation.evento()) {
                    if (tipoEvento.trim().equals("") || !tipoEvento.trim().equals(nomeEvento)) continue;
                    Class<?>[] parametros = method.getParameterTypes();
                    try {
                        if (parametros.length == 0) {
                            method.invoke(obj, new Object[0]);
                            eventoTeveOutput = true;
                            continue;
                        }
                        if (parametros.length == 1 && parametros[0].isAssignableFrom(Evento.class)) {
                            method.invoke(obj, new Evento(nomeEvento, dados));
                            eventoTeveOutput = true;
                            continue;
                        }
                        System.err.println("BarramentoEventos: tentou invocar output ('" + method.getName() + "') mas o m\u00c3\u00a9todo deve receber Evento como par\u00c3\u00a2metro, ou n\u00c3\u00a3o possuir par\u00c3\u00a2metros.");
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return eventoTeveOutput;
    }

    public static BarramentoEventos getInstancia() {
        if (instancia == null) {
            instancia = new BarramentoEventos();
        }
        return instancia;
    }
}

