/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import java.awt.Component;
import java.awt.MenuItem;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import serpro.ppgd.negocio.util.LogPPGD;

public class HelpUtil {
    private JRootPane rootpane = null;
    private HelpSet helpSet;
    private HelpBroker helpBroker;
    private String defaultHelpID;

    public HelpUtil() {
        this(null, null);
    }

    public HelpUtil(String pDefaultHelpID) {
        this(null, pDefaultHelpID);
    }

    public HelpUtil(JRootPane pRootpane) {
        this(pRootpane, null);
    }

    public HelpUtil(JRootPane pRootpane, String pDefaultHelpID) {
        this.rootpane = pRootpane;
        this.setDefaultID(pDefaultHelpID);
    }

    public void setDefaultID(String pDefaultHelpID) {
        this.defaultHelpID = pDefaultHelpID;
    }

    public String getDefaultID(String pDefaultHelpID) {
        return pDefaultHelpID;
    }

    public void setHelpSet(String pHelpSetName) {
        this.helpSet = null;
        String name = pHelpSetName;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = HelpSet.findHelpSet((ClassLoader)cl, (String)name);
        if (url == null) {
            LogPPGD.erro((String)("HelpSet n\u00e3o encontrado: " + url));
            return;
        }
        try {
            this.helpSet = new HelpSet(cl, url);
        }
        catch (HelpSetException ex) {
            LogPPGD.erro((String)("N\u00e3o foi poss\u00edvel criar um HelpSet para: " + url));
        }
        this.helpBroker = this.helpSet.createHelpBroker();
        if (this.rootpane != null) {
            this.helpBroker.enableHelpKey((Component)this.rootpane, this.defaultHelpID, this.helpSet);
        }
    }

    public void setHelpID(Component c, String id) {
        if (c instanceof JButton || c instanceof JMenuItem) {
            this.helpBroker.enableHelpOnButton(c, id, this.helpSet);
        } else {
            this.enableHelpKey(c, id);
        }
    }

    public void setHelpID(MenuItem j, String id) {
        this.helpBroker.enableHelpOnButton(j, id, this.helpSet);
    }

    public void enableHelpKey(JRootPane root, String id) {
        this.helpBroker.enableHelpKey((Component)root, id, this.helpSet);
    }

    public void enableHelpKey(Component c, String id) {
        this.helpBroker.enableHelpKey(c, id, this.helpSet);
    }

    public void exibeAjuda() {
        this.helpBroker.setDisplayed(true);
    }

    public HelpSet getHelpSet() {
        return this.helpSet;
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public void setNavigatorVisible(boolean flag) {
        this.helpBroker.setViewDisplayed(flag);
    }

    public ActionListener displayFromSource() {
        return new CSH.DisplayHelpFromSource(this.helpBroker);
    }

    public ActionListener displayFromFocus() {
        return new CSH.DisplayHelpFromFocus(this.helpBroker);
    }
}

