/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.RepositorioXMLIRPF;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.atividaderural.AtividadeRural;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.comparativo.Comparativo;
import serpro.ppgd.irpf.contribuinte.Contribuinte;
import serpro.ppgd.irpf.dependentes.Dependentes;
import serpro.ppgd.irpf.dividas.Dividas;
import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoCriancaAdolescente;
import serpro.ppgd.irpf.doacaodeclaracao.ColecaoEstatutoIdoso;
import serpro.ppgd.irpf.doacoes.Doacoes;
import serpro.ppgd.irpf.eleicoes.DoacoesEleitorais;
import serpro.ppgd.irpf.espolio.Espolio;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.gcap.GCAP;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.herdeiros.Herdeiros;
import serpro.ppgd.irpf.impostopago.ImpostoPago;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.rendTributacaoExclusiva.RendTributacaoExclusiva;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmDependente;
import serpro.ppgd.irpf.rendacm.ColecaoRendAcmTitular;
import serpro.ppgd.irpf.rendacm.RendAcm;
import serpro.ppgd.irpf.rendavariavel.ColecaoFundosInvestimentosDependente;
import serpro.ppgd.irpf.rendavariavel.ColecaoRendaVariavelDependente;
import serpro.ppgd.irpf.rendavariavel.FundosInvestimentos;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJDependente;
import serpro.ppgd.irpf.rendpj.ColecaoRendPJTitular;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeDependente;
import serpro.ppgd.irpf.rendpjexigibilidade.ColecaoRendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.resumo.ModeloDeclaracao;
import serpro.ppgd.irpf.resumo.Resumo;
import serpro.ppgd.irpf.saida.Saida;
import serpro.ppgd.irpf.util.DataUtil;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.PPGDFacade;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.persistenciagenerica.BackupInexistenteException;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class IRPFFacade
implements PPGDFacade {
    private WeakReference<DeclaracaoIRPF> declaracaoEmGravacao = null;
    private static IRPFFacade instancia = null;
    private RepositorioXMLIRPF repositorioXMLIRPF = new RepositorioXMLIRPF();
    public static final String HASH_ALGORITMO_MD5 = "MD5";

    private IRPFFacade() {
    }

    public static IRPFFacade getInstancia() {
        if (instancia == null) {
            instancia = new IRPFFacade();
        }
        return instancia;
    }

    public static void abreDeclaracao(IdentificadorDeclaracao id) throws HashInvalidoException {
        try {
            IRPFFacade.getInstancia().repositorioXMLIRPF.abreDeclaracao(id);
        }
        catch (RepositorioXMLException e) {
            LogPPGD.erro((String)e.getMessage());
            GuiUtil.mostrarErro((String)"excecao_inesperada");
            System.exit(1);
        }
    }

    public void restaurarBackup(IdentificadorDeclaracao id) throws BackupInexistenteException {
        IRPFFacade.getInstancia().repositorioXMLIRPF.restaurarBackup(id);
    }

    public void restaurarBackup(String pathArquivo) throws BackupInexistenteException {
        IRPFFacade.getInstancia().repositorioXMLIRPF.restaurarBackup(pathArquivo);
    }

    public void fazerBackup(IdentificadorDeclaracao id) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.fazerBackup(id);
    }

    public void fazerBackup(String pathArquivo) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.fazerBackup(pathArquivo);
    }

    public static void abreDeclaracao(DeclaracaoIRPF dec) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.abreDeclaracao(dec);
    }

    public static boolean existeDeclaracao(String cpf, String recibo) {
        return ((ColecaoIdDeclaracao)IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes()).itens().contains(new IdentificadorDeclaracao(cpf, recibo));
    }

    public static boolean existeDeclaracaoTransmitida(String cpf, boolean retificadora) {
        boolean existe = false;
        for (IdentificadorDeclaracao id : ((ColecaoIdDeclaracao)IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes()).itens()) {
            if (!id.getCpf().naoFormatado().equals(cpf) || id.getNumReciboTransmitido().naoFormatado().equals("0000000000") || id.isRetificadora() != retificadora) continue;
            existe = true;
            break;
        }
        return existe;
    }

    public static boolean existeDeclaracaoEmPreenchimento(String cpf) {
        boolean existe = false;
        for (IdentificadorDeclaracao id : ((ColecaoIdDeclaracao)IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes()).itens()) {
            if (!id.getCpf().naoFormatado().equals(cpf) || !id.getNumReciboTransmitido().naoFormatado().equals("0000000000")) continue;
            existe = true;
            break;
        }
        return existe;
    }

    public static IdentificadorDeclaracao obterIdDeclaracaoTransmitida(String cpf, boolean original, boolean heTransmitida) {
        IdentificadorDeclaracao idDec = new IdentificadorDeclaracao();
        for (IdentificadorDeclaracao id : ((ColecaoIdDeclaracao)IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes()).itens()) {
            if (!id.getCpf().naoFormatado().equals(cpf) || (id.getNumReciboTransmitido().naoFormatado().equals("0000000000") || !heTransmitida || id.isOriginal() != original) && (!id.getNumReciboTransmitido().naoFormatado().equals("0000000000") || heTransmitida)) continue;
            idDec = id;
            break;
        }
        return idDec;
    }

    public static ColecaoIdDeclaracao getListaIdDeclaracoes() {
        return (ColecaoIdDeclaracao)IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes();
    }

    public static ColecaoIdDeclaracao getListaIdDeclaracoesEmPrenchimento() {
        ColecaoIdDeclaracao colecaoEmPreenchimento = new ColecaoIdDeclaracao();
        ColecaoIdDeclaracao colecao = (ColecaoIdDeclaracao)IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes();
        for (IdentificadorDeclaracao id : colecao.itens()) {
            if (!id.getNumReciboTransmitido().naoFormatado().equals("0000000000")) continue;
            colecaoEmPreenchimento.itens().add(id);
        }
        return colecaoEmPreenchimento;
    }

    public static ColecaoIdDeclaracao getListaIdDeclaracoesTransmitidas() {
        ColecaoIdDeclaracao colecaoTransmitidas = new ColecaoIdDeclaracao();
        ColecaoIdDeclaracao colecao = (ColecaoIdDeclaracao)IRPFFacade.getInstancia().repositorioXMLIRPF.getListaIdDeclaracoes();
        for (IdentificadorDeclaracao id : colecao.itens()) {
            if (id.getNumReciboTransmitido().naoFormatado().equals("0000000000")) continue;
            colecaoTransmitidas.itens().add(id);
        }
        return colecaoTransmitidas;
    }

    public static void setCacheIdDeclaracao(boolean status) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.setCacheIdDeclaracao(status);
    }

    public static void criarDeclaracao(IdentificadorDeclaracao id) {
        id.getDataUltimoAcesso().setConteudo(DataUtil.obterDataAtual());
        IRPFFacade.getInstancia().repositorioXMLIRPF.criarDeclaracao(id);
    }

    public static void excluirDeclaracao(String cpf, String recibo) {
        IdentificadorDeclaracao id = IRPFFacade.getInstancia().recuperarIdDeclaracao(cpf, recibo);
        IRPFFacade.excluirDeclaracao(id);
    }

    public static void excluirDeclaracao(IdentificadorDeclaracao id) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.excluirDeclaracao(id);
    }

    public static void excluirDeclaracao(List<IdentificadorDeclaracaoXML> ids) {
        IRPFFacade.getInstancia().repositorioXMLIRPF.excluirDeclaracao(ids);
    }

    public void salvarDeclaracaoAberta() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.salvaDeclaracaoAberta();
    }

    public static void limpaCacheDeclaracoes() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.fechaDeclaracao();
    }

    public Contribuinte getContribuinte() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getContribuinte();
    }

    public Espolio getEspolio() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getEspolio();
    }

    public Resumo getResumo() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getResumo();
    }

    public boolean isDeclaracaoAberta() {
        return IRPFFacade.getInstancia().repositorioXMLIRPF != null && IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta() != null;
    }

    public ImpostoPago getImpostoPago() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getImpostoPago();
    }

    public Dependentes getDependentes() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getDependentes();
    }

    public RendaVariavel getRendaVariavel() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendaVariavel();
    }

    public ColecaoRendaVariavelDependente getRendaVariavelDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendaVariavelDependente();
    }

    public FundosInvestimentos getFundosInvestimentos() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getFundosInvestimentos();
    }

    public ColecaoFundosInvestimentosDependente getFundosInvestimentosDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getFundosInvestimentosDependente();
    }

    public ColecaoRendPJDependente getColecaoRendPJDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendPJDependente();
    }

    public ColecaoRendPJTitular getColecaoRendPJTitular() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendPJTitular();
    }

    public RendAcm getRendAcm() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendAcm();
    }

    public ColecaoRendAcmTitular getColecaoRendAcmTitular() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendAcmTitular();
    }

    public ColecaoRendAcmDependente getColecaoRendAcmDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendAcmDependente();
    }

    public ColecaoRendPJComExigibilidadeDependente getColecaoRendPJComExigibilidadeDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendPJComExigibilidadeDependente();
    }

    public ColecaoRendPJComExigibilidadeTitular getColecaoRendPJComExigibilidadeTitular() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoRendPJComExigibilidadeTitular();
    }

    public Herdeiros getHerdeiros() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getHerdeiros();
    }

    public Alimentandos getAlimentandos() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getAlimentandos();
    }

    public Pagamentos getPagamentos() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getPagamentos();
    }

    public Doacoes getDoacoes() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getDoacoes();
    }

    public Bens getBens() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getBens();
    }

    public Dividas getDividas() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getDividas();
    }

    public AtividadeRural getAtividadeRural() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getAtividadeRural();
    }

    public RendPF getRendPFTitular() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendPFTitular();
    }

    public Comparativo getComparativo() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getComparativo();
    }

    public ColecaoRendPFDependente getRendPFDependente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendPFDependente();
    }

    public RendIsentos getRendIsentos() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendIsentos();
    }

    public RendTributacaoExclusiva getRendTributacaoExclusiva() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getRendTributacaoExclusiva();
    }

    public DoacoesEleitorais getDoacoesEleitorais() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getDoacoesEleitorais();
    }

    public Saida getSaida() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getSaida();
    }

    public ColecaoEstatutoCriancaAdolescente getColecaoEstatutoCriancaAdolescente() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoEstatutoCriancaAdolescente();
    }

    public ColecaoEstatutoIdoso getColecaoEstatutoIdoso() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getColecaoEstatutoIdoso();
    }

    public GCAP getGCAP() {
        return ((DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta()).getGCAP();
    }

    public ModeloDeclaracao getModelo() {
        return this.getDeclaracao().getModelo();
    }

    public IdentificadorDeclaracao getIdDeclaracaoAberto() {
        return (IdentificadorDeclaracao)this.repositorioXMLIRPF.getIdDeclaracaoAberto();
    }

    public IdentificadorDeclaracao recuperarIdDeclaracao(String cpf, String recibo) {
        return (IdentificadorDeclaracao)this.repositorioXMLIRPF.obterIdentificador(IRPFFacade.getListaIdDeclaracoes(), new IdentificadorDeclaracao(cpf, recibo).obterIdentificador());
    }

    public DeclaracaoIRPF recuperarDeclaracaoIRPF(String cpf, String recibo) {
        try {
            return (DeclaracaoIRPF)this.repositorioXMLIRPF.recuperarDeclaracao(new IdentificadorDeclaracao(cpf, recibo).obterIdentificador());
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public void salvarDeclaracao(String cpf, String recibo) {
        try {
            DeclaracaoIRPF dec = (DeclaracaoIRPF)this.repositorioXMLIRPF.recuperarDeclaracao(new IdentificadorDeclaracao(cpf, recibo).obterIdentificador());
            this.salvarDeclaracao(dec);
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    private static void setDataAtual(DeclaracaoIRPF dec) {
        try {
            Date dataAtual = (Date)GuiUtil.executarTarefa((String)"Obtendo data atual...", (int)5, BarramentoIRPFService::obterDataServidor);
            dec.getIdentificadorDeclaracao().getDataCriacao().setConteudo(dataAtual);
        }
        catch (Exception e) {
            LogPPGD.erro((String)"Erro ao Obter Data de Criacao da Declaracao");
        }
    }

    public void salvarDeclaracao(DeclaracaoIRPF dec) {
        try {
            this.limparDeclaracao(dec);
            if (dec.getIdentificadorDeclaracao().getDataCriacao().isVazio()) {
                IRPFFacade.setDataAtual(dec);
            }
            this.repositorioXMLIRPF.salvarDeclaracao(dec);
            dec.getDataHoraSalvamento().setConteudo(DataUtil.obterDataAtual());
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    public void limparDeclaracao(DeclaracaoIRPF dec) {
        try {
            if ("E".equals(dec.getIdentificadorDeclaracao().getTipoDeclaracaoAES().naoFormatado())) {
                dec.getContribuinte().getTituloEleitor().clear();
                dec.getContribuinte().getOcupacaoPrincipal().clear();
            }
        }
        catch (Exception ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
    }

    public boolean existeDeclaracoes() {
        return IRPFFacade.getListaIdDeclaracoes().itens().size() > 0;
    }

    public DeclaracaoIRPF getDeclaracao() {
        return (DeclaracaoIRPF)IRPFFacade.getInstancia().repositorioXMLIRPF.getDeclaracaoAberta();
    }

    public void verificarIdDeclaracoes() {
        IRPFFacade.getInstancia().repositorioXMLIRPF.verificaIdDeclaracoes();
    }

    public boolean isTotalRendimentosMenorQueTotalDeducoes() {
        DeclaracaoIRPF dec = this.getDeclaracao();
        Valor totalRendimentos = new Valor();
        totalRendimentos.append('+', dec.getResumo().getRendimentosTributaveisDeducoes().getTotalRendimentos());
        totalRendimentos.append('+', dec.getResumo().getOutrasInformacoes().getRendIsentosNaoTributaveis());
        totalRendimentos.append('+', dec.getResumo().getOutrasInformacoes().getRendIsentosTributacaoExclusiva());
        Valor totalDeducoes = dec.getResumo().getRendimentosTributaveisDeducoes().getTotalDeducoes();
        return totalRendimentos.comparacao("<", totalDeducoes);
    }

    public static List<IdentificadorDeclaracao> getListaDeclaracoesRecentes() {
        List lista = IRPFFacade.getListaIdDeclaracoes().itens();
        ArrayList<IdentificadorDeclaracao> listaOrdenada = new ArrayList<IdentificadorDeclaracao>();
        Collections.sort(lista, new Comparator<ObjetoNegocio>(){

            @Override
            public int compare(ObjetoNegocio o1, ObjetoNegocio o2) {
                IdentificadorDeclaracao i1 = (IdentificadorDeclaracao)o1;
                IdentificadorDeclaracao i2 = (IdentificadorDeclaracao)o2;
                Date d1 = i1.getDataUltimoAcesso().asDate();
                Date d2 = i2.getDataUltimoAcesso().asDate();
                if (d1 != null && d2 != null) {
                    return i2.getDataUltimoAcesso().asDate().compareTo(i1.getDataUltimoAcesso().asDate());
                }
                if (d1 == null && d2 == null) {
                    return 0;
                }
                if (d1 == null) {
                    return 1;
                }
                return -1;
            }
        });
        int cont = 0;
        for (ObjetoNegocio objetoNegocio : lista) {
            IdentificadorDeclaracao id = (IdentificadorDeclaracao)objetoNegocio;
            listaOrdenada.add(id);
            if (++cont < 10) continue;
            break;
        }
        return listaOrdenada;
    }

    public void setDeclaracaoEmGravacao(DeclaracaoIRPF declaracao) {
        this.declaracaoEmGravacao = declaracao != null ? new WeakReference<DeclaracaoIRPF>(declaracao) : null;
    }

    public DeclaracaoIRPF getDeclaracaoEmGravacao() {
        if (this.declaracaoEmGravacao != null) {
            return (DeclaracaoIRPF)((Object)this.declaracaoEmGravacao.get());
        }
        return null;
    }

    public static String calcularHashMD5(File arquivoXML) throws AplicacaoException {
        String output = "";
        try (FileInputStream is = new FileInputStream(arquivoXML);){
            MessageDigest digest = MessageDigest.getInstance(HASH_ALGORITMO_MD5);
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = ((InputStream)is).read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            output = bigInt.toString(16);
        }
        catch (IOException | NoSuchAlgorithmException exception) {
            // empty catch block
        }
        return output;
    }
}

