/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.DataUtil;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.IdDeclaracaoXMLTagHandler;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.DeclaracaoComIdentificador;
import serpro.ppgd.negocio.IdentificadorDeclaracaoXML;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.persistenciagenerica.BackupInexistenteException;
import serpro.ppgd.persistenciagenerica.DefaultTagHandler;
import serpro.ppgd.persistenciagenerica.RepositorioXML;
import serpro.ppgd.persistenciagenerica.RepositorioXMLListener;
import serpro.ppgd.persistenciagenerica.XMLSaxHandler;
import serpro.ppgd.repositorio.repositorioXML.RepositorioXMLException;

public class RepositorioXMLIRPF
extends RepositorioXML
implements RepositorioXMLListener {
    public RepositorioXMLIRPF() {
        this.addRepositorioXMLListener(this);
    }

    public void recuperouDeclaracao(DeclaracaoComIdentificador dec) {
        ((DeclaracaoIRPF)dec).adicionaObservadoresCalculosLate();
    }

    public void abriuDeclaracao(DeclaracaoComIdentificador dec) {
        ((DeclaracaoIRPF)dec).adicionaObservadoresCalculosLate();
    }

    public void criouDeclaracao(DeclaracaoComIdentificador dec) {
        if (IRPFUtil.getEstadoSistema() != 2) {
            ((DeclaracaoIRPF)dec).adicionaObservadoresCalculosLate();
        }
    }

    public void excluirDeclaracao(IdentificadorDeclaracaoXML id) {
        super.excluirDeclaracao(id);
        try {
            super.excluirBackup(id);
        }
        catch (BackupInexistenteException e1) {
            LogPPGD.erro((String)"Erro ao excluir backup (n\u00e3o existe)");
        }
        if (!new File(id.getPathArquivo()).getParentFile().delete()) {
            LogPPGD.erro((String)"Erro deletar arquivo.");
        }
    }

    protected void copiaIdentificador(IdentificadorDeclaracaoXML orig, IdentificadorDeclaracaoXML destin) {
        IdentificadorDeclaracao origem = (IdentificadorDeclaracao)orig;
        IdentificadorDeclaracao destino = (IdentificadorDeclaracao)destin;
        destino.getCpf().setConteudo(origem.getCpf().naoFormatado());
        destino.getDeclaracaoRetificadora().setConteudo(origem.getDeclaracaoRetificadora().naoFormatado());
        destino.getEnderecoDiferente().setConteudo(origem.getEnderecoDiferente().naoFormatado());
        destino.getExercicio().setConteudo(origem.getExercicio().naoFormatado());
        destino.getNome().setConteudo(origem.getNome().naoFormatado());
        destino.getNumReciboTransmitido().setConteudo(origem.getNumReciboTransmitido().naoFormatado());
        destino.getNumeroReciboDecAnterior().setConteudo(origem.getNumeroReciboDecAnterior().naoFormatado());
        destino.getNumReciboDecRetif().setConteudo(origem.getNumReciboDecRetif().naoFormatado());
        destino.getTipoDeclaracao().setConteudo(origem.getTipoDeclaracao().naoFormatado());
        destino.getTipoDeclaracaoAES().setConteudo(origem.getTipoDeclaracaoAES().naoFormatado());
        destino.getTransmitida().setConteudo(origem.getTransmitida().naoFormatado());
        destino.getDataUltimoAcesso().setConteudo(origem.getDataUltimoAcesso());
        destino.getDataCriacao().setConteudo(origem.getDataCriacao());
        destino.getResultadoDeclaracao().setConteudo(origem.getResultadoDeclaracao().naoFormatado());
        destino.getPrepreenchida().setConteudo(origem.getPrepreenchida().naoFormatado());
        destino.getVersaoBeta().setConteudo(origem.getVersaoBeta().naoFormatado());
        destino.getTpIniciada().setConteudo(origem.getTpIniciada().naoFormatado());
        destino.getInUtilizouPGD().setConteudo(origem.getInUtilizouPGD().naoFormatado());
        destino.getInUtilizouAPP().setConteudo(origem.getInUtilizouAPP().naoFormatado());
        destino.getInUtilizouOnLine().setConteudo(origem.getInUtilizouOnLine().naoFormatado());
        destino.getInUtilizouRascunho().setConteudo(origem.getInUtilizouRascunho().naoFormatado());
        destino.getInUtilizouAssistidaFontePagadora().setConteudo(origem.getInUtilizouAssistidaFontePagadora().naoFormatado());
        destino.getInUtilizouAssistidaPlanoSaude().setConteudo(origem.getInUtilizouAssistidaPlanoSaude().naoFormatado());
        destino.getInUtilizouSalvarRecuperarOnLine().setConteudo(origem.getInUtilizouSalvarRecuperarOnLine().naoFormatado());
    }

    protected Colecao criarListaIdDeclaracoes() {
        return new ColecaoIdDeclaracao();
    }

    protected boolean existeDeclaracao(IdentificadorDeclaracaoXML identificadorDeclaracao) {
        IdentificadorDeclaracao identificadorIRPF = (IdentificadorDeclaracao)identificadorDeclaracao;
        return ((ColecaoIdDeclaracao)this.getListaIdDeclaracoes()).itens().contains(identificadorDeclaracao);
    }

    protected DeclaracaoComIdentificador instanciarDeclaracao(IdentificadorDeclaracaoXML identificadorDeclaracao) {
        return new DeclaracaoIRPF((IdentificadorDeclaracao)identificadorDeclaracao);
    }

    protected IdentificadorDeclaracaoXML obterIdentificador(Colecao listaIdDeclaracoes, String numeroIdentificacao) {
        return ((ColecaoIdDeclaracao)listaIdDeclaracoes).getIdentificadorDeclaracao(numeroIdentificacao);
    }

    protected String obterNumeroIdentificacao(IdentificadorDeclaracaoXML identificadorDeclaracao) {
        return ((IdentificadorDeclaracao)identificadorDeclaracao).getCpf().naoFormatado() + "-" + ((IdentificadorDeclaracao)identificadorDeclaracao).getNumReciboTransmitido().naoFormatado();
    }

    protected String obterPathDados() {
        return IRPFUtil.DIR_DADOS;
    }

    protected String obterPathXmlIdsDeclaracoes() {
        return this.obterPathDados() + File.separator + "iddeclaracoes.xml";
    }

    protected DefaultTagHandler obterTagHandler() {
        return new IdDeclaracaoXMLTagHandler();
    }

    protected void parseXml(Colecao colecaoIds, SAXParser parser, DefaultTagHandler tagHandler, XMLSaxHandler xmlHandler, File[] decXml) {
        try {
            IdDeclaracaoXMLTagHandler idDeclaracaoXMLTagHandler = (IdDeclaracaoXMLTagHandler)tagHandler;
            idDeclaracaoXMLTagHandler.setIdDec(new IdentificadorDeclaracao());
            parser.parse(decXml[0], (DefaultHandler)xmlHandler);
            if (AplicacaoPropertiesUtil.getExercicio().equals(idDeclaracaoXMLTagHandler.getIdDec().getExercicio().naoFormatado())) {
                colecaoIds.itens().add(idDeclaracaoXMLTagHandler.getIdDec());
            }
        }
        catch (SAXException e) {
            LogPPGD.erro((String)e.getMessage());
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    protected void removerIdentificador(Colecao colecaoIdentificadores, IdentificadorDeclaracaoXML identificadorDeclaracao) {
        ((ColecaoIdDeclaracao)colecaoIdentificadores).removeCPF((IdentificadorDeclaracao)identificadorDeclaracao);
    }

    public String getXPathCopiaId() {
        return "/classe/copiaIdentificador";
    }

    protected String obterExpressaoRegularNomePasta() {
        return "(\\d){11}";
    }

    protected void antesDeSalvar(DeclaracaoComIdentificador aDec) {
        DeclaracaoIRPF dec = (DeclaracaoIRPF)aDec;
        IdentificadorDeclaracao copia = dec.getCopiaIdentificador();
        IdentificadorDeclaracaoXML origem = dec.getIdentificador();
        dec.getIdentificadorDeclaracao().getDataUltimoAcesso().setConteudo(DataUtil.obterDataAtual());
        this.copiaIdentificador(origem, copia);
    }

    public void verificaIdDeclaracoes() {
        Colecao colIds = this.getListaIdDeclaracoes();
        this.testaDiretorioDados();
        ArrayList<File> decs = new ArrayList<File>();
        try {
            File[] pastas;
            File dados = new File(this.obterPathDados());
            for (File pasta : pastas = dados.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && pathname.getName().matches(RepositorioXMLIRPF.this.obterExpressaoRegularNomePasta());
                }
            })) {
                File[] files = pasta.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isFile() && pathname.getName().matches("(\\d){11}\\-(\\d){10}\\.xml");
                    }
                });
                Collections.addAll(decs, files);
            }
        }
        catch (Exception e) {
            LogPPGD.erro((String)e.getMessage());
            return;
        }
        this.excluirIdentificadoresInvalidos((ColecaoIdDeclaracao)colIds);
        if (colIds == null || colIds.itens().size() != decs.size()) {
            this.restaurarListaIdDeclaracoes(colIds, decs);
            try {
                this.salvarColecaoId(colIds);
            }
            catch (RepositorioXMLException e) {
                LogPPGD.erro((String)e.getMessage());
            }
        }
    }

    private void excluirIdentificadoresInvalidos(ColecaoIdDeclaracao ids) {
        ArrayList<IdentificadorDeclaracao> idsExcluir = new ArrayList<IdentificadorDeclaracao>();
        if (ids != null) {
            for (IdentificadorDeclaracao id : ids.itens()) {
                if (AplicacaoPropertiesUtil.getExercicio().equals(id.getExercicio().naoFormatado())) continue;
                idsExcluir.add(id);
            }
            for (IdentificadorDeclaracao id : idsExcluir) {
                ids.remove(id);
            }
        }
    }

    protected void restaurarListaIdDeclaracoes(Colecao colIds, List<File> decs) {
        System.out.println("Recuperando Ids... total: " + decs.size());
        if (colIds == null) {
            colIds = this.criarListaIdDeclaracoes();
        } else {
            colIds.itens().clear();
        }
        DefaultTagHandler tagHandler = this.obterTagHandler();
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            XMLSaxHandler handler = new XMLSaxHandler();
            handler.addTagHandler(this.getXPathCopiaId(), tagHandler);
            for (int i = 0; i < decs.size(); ++i) {
                File dec = decs.get(i);
                try {
                    this.parseXml(colIds, parser, tagHandler, handler, new File[]{dec});
                    continue;
                }
                catch (Exception e) {
                    LogPPGD.erro((String)e.getMessage());
                }
            }
        }
        catch (ParserConfigurationException ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
        catch (SAXException ex) {
            LogPPGD.erro((String)ex.getMessage());
        }
    }
}

