/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf;

import java.util.StringTokenizer;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;

public class ValidadorNomeIRPF
extends ValidadorDefault {
    public ValidadorNomeIRPF() {
        super((byte)2);
    }

    public RetornoValidacao validarImplementado() {
        RetornoValidacao retorno = ValidadorNomeIRPF.validarNomeCompleto(this.getInformacao().naoFormatado());
        if (retorno != null) {
            this.setSeveridade(retorno.getSeveridade());
        }
        return retorno;
    }

    public static RetornoValidacao validarNomeCompleto(String nomeCompleto) {
        if (nomeCompleto == null || nomeCompleto.equals("")) {
            return new RetornoValidacao("Nome em branco.", 3);
        }
        if (nomeCompleto.length() > 60) {
            return new RetornoValidacao("Nome tem mais que 60 caracteres.", 3);
        }
        StringTokenizer testeNomeCompleto = new StringTokenizer(nomeCompleto);
        if (testeNomeCompleto.countTokens() > 15) {
            return new RetornoValidacao("Nome deve ter no m\u00e1ximo quinze partes.", 3);
        }
        RetornoValidacao rValidacao = null;
        RetornoValidacao ultimaValidacao = null;
        boolean primeiraVez = true;
        while (testeNomeCompleto.hasMoreTokens()) {
            String testeNome = testeNomeCompleto.nextToken();
            rValidacao = ValidadorNomeIRPF.validarNome(testeNome, !testeNomeCompleto.hasMoreTokens());
            if (rValidacao == null) continue;
            ultimaValidacao = rValidacao;
            if (rValidacao.getSeveridade() < 3) continue;
            break;
        }
        return ultimaValidacao;
    }

    private static RetornoValidacao validarNome(String parteNomeCompleto, boolean heUltimaParteNome) {
        RetornoValidacao retornoValidacaoAviso = null;
        if (parteNomeCompleto == null || parteNomeCompleto.equals("")) {
            return new RetornoValidacao("Nome em branco.", 3);
        }
        parteNomeCompleto = parteNomeCompleto.toUpperCase();
        int letrasRepetidas = 1;
        for (int j = 1; j < parteNomeCompleto.length(); ++j) {
            letrasRepetidas = parteNomeCompleto.charAt(j) == parteNomeCompleto.charAt(j - 1) ? ++letrasRepetidas : 1;
            if (letrasRepetidas == 3 && (!parteNomeCompleto.equals("III") || parteNomeCompleto.equals("III") && !heUltimaParteNome)) {
                retornoValidacaoAviso = new RetornoValidacao("O nome possui 3 caracteres iguais, digitados em sequ\u00eancia.", 2);
            }
            if (Character.isDigit(parteNomeCompleto.charAt(j - 1))) {
                return new RetornoValidacao("Nome n\u00e3o pode ter n\u00fameros.", 3);
            }
            if (Character.isLetter(parteNomeCompleto.charAt(j - 1))) continue;
            return new RetornoValidacao("Nome tem caracteres inv\u00e1lidos.", 3);
        }
        if (Character.isDigit(parteNomeCompleto.charAt(parteNomeCompleto.length() - 1))) {
            return new RetornoValidacao("Nome n\u00e3o pode ter n\u00fameros.", 3);
        }
        if (!Character.isLetter(parteNomeCompleto.charAt(parteNomeCompleto.length() - 1))) {
            return new RetornoValidacao("Nome tem caracteres inv\u00e1lidos.", 3);
        }
        if ("ESPOLIO".equals(parteNomeCompleto.toUpperCase()) || "ESP\u00d3LIO".equals(parteNomeCompleto.toUpperCase())) {
            return new RetornoValidacao("Deve ser informado o nome sem a palavra ESP\u00d3LIO.", 3);
        }
        if (retornoValidacaoAviso != null) {
            return retornoValidacaoAviso;
        }
        return null;
    }
}

