/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural;

import java.util.List;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.atividaderural.PainelBensARLista;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.ObjetoComChaveIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;

public class BemAR
extends ObjetoNegocio
implements ObjetoComChaveIRPF,
ObjetoFicha {
    public static String LABEL_VALOR_EXERCICIO_ANTERIOR = "Situa\u00e7\u00e3o Valor Anterior";
    public static String LABEL_VALOR_EXERCICIO_ATUAL = "Situa\u00e7\u00e3o Valor Atual";
    protected Codigo codigo = new Codigo((ObjetoNegocio)this, "C\u00f3digo", CadastroTabelasIRPF.recuperarTipoBensAR());
    protected Codigo pais = new Codigo((ObjetoNegocio)this, "Pa\u00eds", CadastroTabelasIRPF.recuperarPaises());
    protected Alfa nomePais = new Alfa((ObjetoNegocio)this, "Nome do Pa\u00eds");
    protected Alfa discriminacao = new Alfa((ObjetoNegocio)this, "Discrimina\u00e7\u00e3o", 512);
    protected ValorPositivo valorExercicioAnterior = new ValorPositivo(this, LABEL_VALOR_EXERCICIO_ANTERIOR);
    protected ValorPositivo valorExercicioAtual = new ValorPositivo(this, LABEL_VALOR_EXERCICIO_ATUAL);
    private Alfa indice = new Alfa((ObjetoNegocio)this, "Indice");

    public BemAR() {
        this.getCodigo().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_bem_codigo_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (BemAR.this.isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getCodigo().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("ar_bem_codigo_branco")));
        this.getDiscriminacao().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_bem_discriminacao")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (BemAR.this.getCodigo().isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getPais().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_bem_pais_branco")){

            @Override
            public RetornoValidacao validarImplementado() {
                if (BemAR.this.isVazio()) {
                    return null;
                }
                return super.validarImplementado();
            }
        });
        this.getPais().addValidador((ValidadorIf)new ValidadorCodigo(3, MensagemUtil.getMensagem("ar_bem_pais_branco")));
        this.getPais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                BemAR.this.nomePais.setConteudo(BemAR.this.getPais().getConteudoAtual(1));
            }
        });
        if (this.getPais().isVazio()) {
            this.getPais().setConteudo("105");
        }
    }

    public Codigo getCodigo() {
        return this.codigo;
    }

    public Alfa getDiscriminacao() {
        return this.discriminacao;
    }

    public ValorPositivo getValorExercicioAnterior() {
        return this.valorExercicioAnterior;
    }

    public ValorPositivo getValorExercicioAtual() {
        return this.valorExercicioAtual;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Alfa getNomePais() {
        return this.nomePais;
    }

    public boolean isVazio() {
        return this.codigo.isVazio() && this.discriminacao.isVazio() && this.valorExercicioAnterior.isVazio() && this.valorExercicioAtual.isVazio();
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    public String getChave() {
        return this.getCodigo().naoFormatado();
    }

    public int compareTo(Object o) {
        BemAR bem = (BemAR)o;
        int cod = bem.getCodigo().asInteger();
        return cod - this.getCodigo().asInteger();
    }

    @Override
    public Alfa getIndice() {
        return this.indice;
    }

    public String getClasseFicha() {
        return PainelBensARLista.class.getName();
    }

    public String getNomeAba() {
        return null;
    }

    public String getTituloFichaDashboard() {
        return "Bens da Atividade Rural";
    }

    public BemAR obterCopia() {
        BemAR copia = new BemAR();
        copia.getCodigo().setConteudo(this.getCodigo());
        copia.getPais().setConteudo(this.getPais());
        copia.getNomePais().setConteudo(this.getNomePais());
        copia.getDiscriminacao().setConteudo(this.getDiscriminacao());
        copia.getValorExercicioAnterior().setConteudo(this.getValorExercicioAnterior());
        copia.getValorExercicioAtual().setConteudo(this.getValorExercicioAtual());
        return copia;
    }

    public void addObservador(Observador obj) {
        this.valorExercicioAnterior.addObservador(obj);
        this.valorExercicioAtual.addObservador(obj);
    }

    public void removeObservador(Observador obj) {
        this.valorExercicioAnterior.removeObservador(obj);
        this.valorExercicioAtual.removeObservador(obj);
    }
}

