/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural.exterior;

import java.util.List;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.atividaderural.PainelApuracaoResultado;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class ApuracaoResultadoExterior
extends ObjetoNegocio
implements ObjetoFicha {
    public static final String NOME_CAMPO_RESULTADO_TRIBUTAVEL_EXT = "Resultado Tribut\u00e1vel - Exterior";
    public static final String PELO_LIMITE_20_POR_CENTO = "1";
    public static final String PELO_RESULTADO = "2";
    private Valor resultadoI_EmDolar = new Valor((ObjetoNegocio)this, "Resultado I - D\u00f3lar");
    private Valor resultadoI_EmReais = new Valor((ObjetoNegocio)this, "Resultado I - Real");
    private ValorPositivo prejuizoExercicioAnterior = new ValorPositivo(this, "Preju\u00edzo Exerc\u00edcio Anterior");
    private ValorPositivo compensacaoPrejuizoExerciciosAnteriores = new ValorPositivo(this, "Compensa\u00e7\u00e3o de Preju\u00edzo(s) de Exerc\u00edcio(s) Anterior(es)");
    private ValorPositivo limiteVintePorCentoReceitaBruta = new ValorPositivo(this, "Limite de 20% sobre a Receita Bruta");
    private Alfa opcaoFormaApuracao = new Alfa((ObjetoNegocio)this, "Op\u00e7\u00e3o pela forma de apura\u00e7\u00e3o do resultado tribut\u00e1vel");
    private ValorPositivo resultadoTributavel = new ValorPositivo(this, "Resultado Tribut\u00e1vel - Exterior");
    private Valor prejuizoCompensar = new Valor((ObjetoNegocio)this, "Saldo Preju\u00edzo a Compensar");
    private ValorPositivo receitaRecebidaContaVenda = new ValorPositivo(this, "Receita Recebida Adiantamento");
    private ValorPositivo valorAdiantamento = new ValorPositivo(this, "Adiantamentos Recebidos por Venda Entrega Futura");
    private Valor resultadoNaoTributavel = new Valor((ObjetoNegocio)this, "Resultado N\u00e3o Tribut\u00e1vel");

    public ApuracaoResultadoExterior(IdentificadorDeclaracao identificadorDeclaracao) {
        this.setFicha("Apura\u00e7\u00e3o do Resultado Tribut\u00e1vel - EXTERIOR");
        this.resultadoI_EmDolar.setReadOnly(true);
        if (!identificadorDeclaracao.isEspolio() && !identificadorDeclaracao.isSaida()) {
            this.resultadoI_EmReais.setReadOnly(true);
        }
        this.compensacaoPrejuizoExerciciosAnteriores.setReadOnly(true);
        this.resultadoTributavel.setReadOnly(true);
        this.prejuizoCompensar.setReadOnly(true);
        this.resultadoNaoTributavel.setReadOnly(true);
        this.opcaoFormaApuracao.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!(ApuracaoResultadoExterior.this.prejuizoExercicioAnterior.isVazio() && ApuracaoResultadoExterior.this.resultadoI_EmReais.isVazio() || ApuracaoResultadoExterior.this.opcaoFormaApuracao.naoFormatado().equals(ApuracaoResultadoExterior.PELO_LIMITE_20_POR_CENTO) || ApuracaoResultadoExterior.this.opcaoFormaApuracao.naoFormatado().equals(ApuracaoResultadoExterior.PELO_RESULTADO))) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("msg_validador_nao_nulo", new String[]{this.getInformacao().getNomeCampo()}), this.getSeveridade());
                }
                return null;
            }
        });
        this.limiteVintePorCentoReceitaBruta.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(2){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ApuracaoResultadoExterior.this.opcaoFormaApuracao.naoFormatado().equals(ApuracaoResultadoExterior.PELO_LIMITE_20_POR_CENTO)) {
                    long resultadoTotalEmReais = ApuracaoResultadoExterior.this.getResultadoI_EmReais().getConteudo();
                    long limiteVintePorCentoReceitaBruta = ApuracaoResultadoExterior.this.getLimiteVintePorCentoReceitaBruta().getConteudo();
                    if (resultadoTotalEmReais > 0L && limiteVintePorCentoReceitaBruta == 0L) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("ar_apuracao_resultado_limite_20_vazio"), this.getSeveridade());
                    }
                }
                return null;
            }
        });
        this.compensacaoPrejuizoExerciciosAnteriores.addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (ApuracaoResultadoExterior.this.getCompensacaoPrejuizoExerciciosAnteriores().comparacao(">", "0,00") && ApuracaoResultadoExterior.this.getResultadoI_EmReais().comparacao(">", "0,00")) {
                    if (ApuracaoResultadoExterior.this.getCompensacaoPrejuizoExerciciosAnteriores().comparacao(">", ApuracaoResultadoExterior.this.getResultadoI_EmReais())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("ar_apuracao_comp_prejuizo_excede_resultado_ex"), 3);
                    }
                    if (ApuracaoResultadoExterior.this.getCompensacaoPrejuizoExerciciosAnteriores().comparacao(">", ApuracaoResultadoExterior.this.getPrejuizoExercicioAnterior())) {
                        return new RetornoValidacao(MensagemUtil.getMensagem("ar_apuracao_comp_prejuizo_excede_saldo_prejuizo_ex"), 3);
                    }
                }
                return null;
            }
        });
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List listaCamposPendencia = super.recuperarListaCamposPendencia();
        listaCamposPendencia.add(this.limiteVintePorCentoReceitaBruta);
        listaCamposPendencia.add(this.opcaoFormaApuracao);
        listaCamposPendencia.add(this.compensacaoPrejuizoExerciciosAnteriores);
        listaCamposPendencia.add(this.resultadoTributavel);
        listaCamposPendencia.add(this.resultadoNaoTributavel);
        return listaCamposPendencia;
    }

    public boolean isVazio() {
        return this.resultadoI_EmDolar.isVazio() && this.resultadoI_EmReais.isVazio() && this.prejuizoExercicioAnterior.isVazio() && this.compensacaoPrejuizoExerciciosAnteriores.isVazio() && this.limiteVintePorCentoReceitaBruta.isVazio() && this.resultadoTributavel.isVazio() && this.prejuizoCompensar.isVazio() && this.receitaRecebidaContaVenda.isVazio() && this.valorAdiantamento.isVazio() && this.resultadoNaoTributavel.isVazio();
    }

    public ValorPositivo getLimiteVintePorCentoReceitaBruta() {
        return this.limiteVintePorCentoReceitaBruta;
    }

    public Alfa getOpcaoFormaApuracao() {
        return this.opcaoFormaApuracao;
    }

    public Valor getPrejuizoCompensar() {
        return this.prejuizoCompensar;
    }

    public ValorPositivo getPrejuizoExercicioAnterior() {
        return this.prejuizoExercicioAnterior;
    }

    public ValorPositivo getReceitaRecebidaContaVenda() {
        return this.receitaRecebidaContaVenda;
    }

    public ValorPositivo getCompensacaoPrejuizoExerciciosAnteriores() {
        return this.compensacaoPrejuizoExerciciosAnteriores;
    }

    public Valor getResultadoI_EmReais() {
        return this.resultadoI_EmReais;
    }

    public Valor getResultadoI_EmDolar() {
        return this.resultadoI_EmDolar;
    }

    public Valor getResultadoNaoTributavel() {
        return this.resultadoNaoTributavel;
    }

    public ValorPositivo getResultadoTributavel() {
        return this.resultadoTributavel;
    }

    public ValorPositivo getValorAdiantamento() {
        return this.valorAdiantamento;
    }

    public String getClasseFicha() {
        return PainelApuracaoResultado.class.getName();
    }

    public String getNomeAba() {
        return "Exterior";
    }

    public String getTituloFichaDashboard() {
        return "Apura\u00e7\u00e3o do Resultado Tribut\u00e1vel - EXTERIOR";
    }
}

