/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.atividaderural.exterior;

import java.util.List;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gui.atividaderural.PainelReceitasDespesas;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCodigo;

public class ReceitaDespesa
extends ObjetoNegocio
implements ObjetoFicha {
    private Codigo pais = new Codigo((ObjetoNegocio)this, "C\u00f3digo do Pa\u00eds", CadastroTabelasIRPF.recuperarPaisesExterior());
    private Alfa descricaoPais = new Alfa((ObjetoNegocio)this, "");
    private ValorPositivo receitaBruta = new ValorPositivo(this, "Receita Bruta Total - Moeda Original");
    private ValorPositivo despesaCusteio = new ValorPositivo(this, "Despesas de Custeio e Investimento Total - Moeda Original");
    private Valor resultadoIMoedaOriginal = new Valor((ObjetoNegocio)this, "Resultado I - Moeda Original");
    private Valor resultadoI_EmDolar = new Valor((ObjetoNegocio)this, "Resultado I - US$");

    public ReceitaDespesa() {
        this.resultadoIMoedaOriginal.setReadOnly(true);
        this.receitaBruta.addObservador((Observador)this);
        this.despesaCusteio.addObservador((Observador)this);
        this.getPais().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                ReceitaDespesa.this.descricaoPais.setConteudo(ReceitaDespesa.this.getPais().getConteudoAtual(2));
            }
        });
        this.getPais().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3));
        this.getPais().addValidador((ValidadorIf)new ValidadorCodigo(3, "\"" + this.getPais().getNomeCampo() + "\" inv\u00e1lido."));
        this.getResultadoI_EmDolar().addValidador((ValidadorIf)new ValidadorNaoNuloIRPF(3, MensagemUtil.getMensagem("ar_receita_despesa_resultado_branco")));
        this.getResultadoI_EmDolar().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (ReceitaDespesa.this.getResultadoIMoedaOriginal().getConteudo() > 0L && ReceitaDespesa.this.getResultadoI_EmDolar().getConteudo() < 0L || ReceitaDespesa.this.getResultadoIMoedaOriginal().getConteudo() < 0L && ReceitaDespesa.this.getResultadoI_EmDolar().getConteudo() > 0L) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("ar_receita_despesa_resultado_sinal_invalido"), 3);
                }
                return null;
            }
        });
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.resultadoIMoedaOriginal.setConteudo(this.receitaBruta.operacao('-', this.despesaCusteio));
    }

    public Valor getDespesaCusteio() {
        return this.despesaCusteio;
    }

    public Codigo getPais() {
        return this.pais;
    }

    public Valor getReceitaBruta() {
        return this.receitaBruta;
    }

    public Valor getResultadoIMoedaOriginal() {
        return this.resultadoIMoedaOriginal;
    }

    public Valor getResultadoI_EmDolar() {
        return this.resultadoI_EmDolar;
    }

    public boolean isVazio() {
        for (Informacao informacao : this.recuperarListaCamposPendencia()) {
            if (informacao.isVazio()) continue;
            return false;
        }
        return true;
    }

    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    public String getClasseFicha() {
        return PainelReceitasDespesas.class.getName();
    }

    public String getNomeAba() {
        return "Exterior";
    }

    public String getTituloFichaDashboard() {
        return null;
    }

    public ReceitaDespesa obterCopia() {
        ReceitaDespesa copia = new ReceitaDespesa();
        copia.getPais().setConteudo(this.getPais());
        copia.descricaoPais.setConteudo(this.getPais().getConteudoAtual(2));
        copia.getReceitaBruta().setConteudo(this.getReceitaBruta());
        copia.getDespesaCusteio().setConteudo(this.getDespesaCusteio());
        copia.getResultadoIMoedaOriginal().setConteudo(this.getResultadoIMoedaOriginal());
        copia.getResultadoI_EmDolar().setConteudo(this.getResultadoI_EmDolar());
        return copia;
    }
}

