/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import java.util.Iterator;
import serpro.ppgd.irpf.bens.ItemPercentualParticipacaoInventario;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.Valor;

public class ColecaoItemPercentualParticipacaoInventario
extends Colecao<ItemPercentualParticipacaoInventario> {
    private Valor totalPercentual = new Valor((ObjetoNegocio)this, "Totais");

    public ColecaoItemPercentualParticipacaoInventario() {
        this.getTotais().setReadOnly(true);
    }

    public Valor getTotais() {
        return this.totalPercentual;
    }

    public void objetoInserido(ItemPercentualParticipacaoInventario itemPercentualParticipacaoInventario) {
        itemPercentualParticipacaoInventario.getPercentual().addObservador((Observador)this);
        this.calculaTotal();
        itemPercentualParticipacaoInventario.getNi().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                if (ColecaoItemPercentualParticipacaoInventario.this.isHerdeiroDuplicado(this.getInformacao().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("bem_participacao_duplicada"), 3);
                }
                return null;
            }
        });
    }

    public void objetoRemovido(Object o) {
        ((ItemPercentualParticipacaoInventario)((Object)o)).getPercentual().removeObservador((Observador)this);
        this.calculaTotal();
    }

    private void calculaTotal() {
        Iterator it = this.itens().iterator();
        this.totalPercentual.clear();
        while (it.hasNext()) {
            ItemPercentualParticipacaoInventario item = (ItemPercentualParticipacaoInventario)((Object)it.next());
            this.totalPercentual.append('+', (Valor)item.getPercentual());
        }
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.calculaTotal();
    }

    public boolean existeHerdeiro(String niHerdeiro) {
        for (ItemPercentualParticipacaoInventario participacao : this.itens()) {
            if (participacao.getNi().naoFormatado().isEmpty() || !participacao.getNi().naoFormatado().equals(niHerdeiro)) continue;
            return true;
        }
        return false;
    }

    public boolean isHerdeiroDuplicado(String niHerdeiro) {
        Iterator it = this.itens().iterator();
        int count = 0;
        while (it.hasNext()) {
            ItemPercentualParticipacaoInventario participacao = (ItemPercentualParticipacaoInventario)((Object)it.next());
            if (participacao.getNi().naoFormatado().isEmpty() || !participacao.getNi().naoFormatado().equals(niHerdeiro)) continue;
            if (count > 0) {
                return true;
            }
            ++count;
        }
        return false;
    }

    public void excluirHerdeiro(String niHerdeiro) {
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            ItemPercentualParticipacaoInventario participacao = (ItemPercentualParticipacaoInventario)((Object)it.next());
            if (participacao.getNi().naoFormatado().isEmpty() || !participacao.getNi().naoFormatado().equals(niHerdeiro)) continue;
            it.remove();
        }
    }
}

