/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.bens;

import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;

public class ValidadorRenavam
extends ValidadorDefault {
    private Bem bem;
    private IdentificadorDeclaracao idDec;

    public ValidadorRenavam(byte severidade, IdentificadorDeclaracao idDec, Bem bem) {
        super(severidade);
        this.idDec = idDec;
        this.bem = bem;
    }

    public RetornoValidacao validarImplementado() {
        if (this.bem.isBemRegistravel() && this.bem.getPais().naoFormatado().equals("105") && "02".equals(this.bem.getGrupo().naoFormatado()) && this.bem.getCodigo().naoFormatado().equals("01") && !this.validaRenavam(this.bem.getRegistroBem().naoFormatado())) {
            return new RetornoValidacao(MensagemUtil.getMensagem("bem_renavam_invalido"));
        }
        return new RetornoValidacao(0);
    }

    public boolean validaRenavam(String renavam) {
        int digitoRealInformado;
        if (((String)renavam).matches("^([0-9]{9})$")) {
            renavam = "00" + (String)renavam;
        }
        if (!((String)renavam).matches("[0-9]{11}")) {
            return false;
        }
        String renavamSemDigito = ((String)renavam).substring(0, 10);
        String renavamReversoSemDigito = new StringBuffer(renavamSemDigito).reverse().toString();
        int soma = 0;
        for (int i = 0; i < 8; ++i) {
            Integer algarismo = Integer.parseInt(renavamReversoSemDigito.substring(i, i + 1));
            Integer multiplicador = i + 2;
            soma += algarismo * multiplicador;
        }
        soma += Character.getNumericValue(renavamReversoSemDigito.charAt(8)) * 2;
        int mod11 = (soma += Character.getNumericValue(renavamReversoSemDigito.charAt(9)) * 3) % 11;
        int ultimoDigitoCalculado = 11 - mod11;
        ultimoDigitoCalculado = ultimoDigitoCalculado >= 10 ? 0 : ultimoDigitoCalculado;
        return ultimoDigitoCalculado == (digitoRealInformado = Integer.valueOf(((String)renavam).substring(((String)renavam).length() - 1, ((String)renavam).length())).intValue());
    }
}

