/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.declaracao.assistida.informeplanosaude;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileFilter;
import serpro.ppgd.irpf.declaracao.assistida.informeplanosaude.InformePagamentosPlanoSaude;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.declaracao.assistida.informeplanosaude.PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude;
import serpro.ppgd.irpf.gui.declaracao.assistida.informerendimentos.PainelPrevisualizadorDeclaracaoAssistidaInformeRendimentos;
import serpro.ppgd.irpf.gui.dialogs.PainelMensagemDetalhada;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.txt.importacao.informerendimentospj.RepositorioXMLDadosInformes;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.Validador;

public class ProcessoImportacaoInformePlanoSaude {
    private boolean importacao = true;

    public ProcessoImportacaoInformePlanoSaude() {
    }

    public ProcessoImportacaoInformePlanoSaude(boolean importacao) {
        this.importacao = importacao;
    }

    public void importar() {
        PainelDemonstrativoIf painel = ControladorGui.getPainelAtualmenteExibido();
        if (painel == null || !painel.getClass().isAssignableFrom(PainelPrevisualizadorDeclaracaoAssistidaInformeRendimentos.class) && !painel.getClass().isAssignableFrom(PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude.class)) {
            this.importar(this.escolherArquivo());
        }
    }

    public void importar(String arquivoImportacao) {
        PainelDemonstrativoIf painel = ControladorGui.getPainelAtualmenteExibido();
        if (painel == null || !painel.getClass().isAssignableFrom(PainelPrevisualizadorDeclaracaoAssistidaInformeRendimentos.class) && !painel.getClass().isAssignableFrom(PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude.class)) {
            if (arquivoImportacao != null) {
                List<Object> erros = new ArrayList<Exception>();
                try {
                    erros = this.validarFormatoArquivoXML("informe_planos_saude.xsd", arquivoImportacao);
                }
                catch (Exception ex) {
                    erros.add(ex);
                }
                try {
                    if (erros.size() == 0) {
                        InformePagamentosPlanoSaude informePlanoSaude = new InformePagamentosPlanoSaude(ControladorGui.getDemonstrativoAberto());
                        new RepositorioXMLDadosInformes().importaDados(new File(arquivoImportacao), (ObjetoNegocio)informePlanoSaude);
                        if (!informePlanoSaude.getHeader().getAnoExercicio().naoFormatado().equals(ConstantesGlobais.EXERCICIO)) {
                            GuiUtil.mostrarErro((String)"importar_informe_rendimentos_ano_invalido", (String[])new String[]{"Exerc\u00edcio"});
                        } else if (!informePlanoSaude.getHeader().getAnoCalendario().naoFormatado().equals(ConstantesGlobais.ANO_BASE)) {
                            GuiUtil.mostrarErro((String)"importar_informe_rendimentos_ano_invalido", (String[])new String[]{"Ano-Calend\u00e1rio"});
                        } else {
                            if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().getCpf().naoFormatado().equals(informePlanoSaude.getHeader().getCpfContribuinte().naoFormatado())) {
                                informePlanoSaude.setTipoInforme(1);
                            } else if (ControladorGui.getDemonstrativoAberto().getDependentes().isExisteCpf(informePlanoSaude.getHeader().getCpfContribuinte().naoFormatado())) {
                                informePlanoSaude.setTipoInforme(2);
                            }
                            if (informePlanoSaude.getTipoInforme() == 1 || informePlanoSaude.getTipoInforme() == 2) {
                                this.preVisualizar(informePlanoSaude);
                            } else {
                                GuiUtil.mostrarAviso((String)"importar_informe_cpf_incorreto", (String[])new String[]{"Plano de Sa\u00fade", informePlanoSaude.getHeader().getCpfContribuinte().formatado()});
                            }
                        }
                    }
                }
                catch (ParserConfigurationException ex) {
                    GuiUtil.mostrarErro((String)"importar_informe_rendimentos_arquivo_erro");
                }
                catch (IOException ex) {
                    GuiUtil.mostrarErro((String)"importar_informe_rendimentos_arquivo_erro");
                }
                catch (SAXException ex) {
                    erros.add(ex);
                }
                if (erros.size() > 0) {
                    StringBuilder mensagemErroCompleta = new StringBuilder();
                    String nomeArquivo = new File(arquivoImportacao).getName();
                    for (Exception exception : erros) {
                        Object complemento = "";
                        if (exception instanceof SAXParseException) {
                            SAXParseException e = (SAXParseException)exception;
                            complemento = "(Linha " + e.getLineNumber() + ", Coluna " + e.getColumnNumber() + " do informe do Plano de Sa\u00fade) ";
                        }
                        mensagemErroCompleta.append((String)complemento + exception.getLocalizedMessage() + "\n");
                    }
                    PainelMensagemDetalhada painelMensagemDetalhada = new PainelMensagemDetalhada("Falha na Importa\u00e7\u00e3o do Informe de Plano de Sa\u00fade", MensagemUtil.getMensagem("importar_informe_plano_saude_arquivo_invalido_sem_parametro"), mensagemErroCompleta.toString(), nomeArquivo);
                    GuiUtil.exibeDialog((JComponent)painelMensagemDetalhada, (boolean)true, (String)"Importa\u00e7\u00e3o de Informe de Plano de Sa\u00fade", (boolean)false);
                }
            }
        } else {
            GuiUtil.mostrarAviso((String)"acao_cancelar_acao_atual");
        }
    }

    private void preVisualizar(InformePagamentosPlanoSaude informePagamentosPlanoSaude) {
        PainelDemonstrativoIf painelAtualmenteExibido = ControladorGui.getPainelAtualmenteExibido();
        PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude painelPreVisualizacaoInformePlanoSaude = new PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude(informePagamentosPlanoSaude, painelAtualmenteExibido);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painelPreVisualizacaoInformePlanoSaude);
    }

    public List<Exception> validarFormatoArquivoXML(String xsdFullFilename, String xmlFullFilename) throws SAXException, IOException {
        Source xmlFile = null;
        Object xsdFile = null;
        final ArrayList<Exception> erros = new ArrayList<Exception>();
        try {
            xmlFile = new StreamSource(new File(xmlFullFilename));
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(ProcessoImportacaoInformePlanoSaude.class.getResource("/" + xsdFullFilename));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    erros.add(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    erros.add(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    erros.add(exception);
                }
            });
            validator.validate(xmlFile);
        }
        catch (SAXException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid");
            System.out.println("Reason: " + e.getLocalizedMessage());
            throw e;
        }
        catch (IOException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid");
            System.out.println("Reason: " + e.getLocalizedMessage());
            throw e;
        }
        return erros;
    }

    public String escolherArquivo() {
        String importacaoOuImpressao = this.importacao ? "Importa\u00e7\u00e3o" : "Impress\u00e3o";
        String imprimeOuImporta = this.importacao ? "Importa" : "Imprime";
        FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
        fc.setDialogTitle(importacaoOuImpressao + " de Informe de Plano de Sa\u00fade para o IRPF " + ConstantesGlobais.EXERCICIO);
        fc.setApproveButtonText("OK");
        fc.setApproveButtonToolTipText(imprimeOuImporta + " dados de Informe de Plano de Sa\u00fade do IRPF " + ConstantesGlobais.EXERCICIO);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter((FileFilter)new FiltroArquivoInformeRendimentos());
        fc.setMultiSelectionEnabled(false);
        FileChooserResponse ret = fc.showOpenDialog((Component)ControladorGui.getJanelaPrincipal());
        if (ret == FileChooserResponse.APPROVE_OPTION) {
            return fc.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    private boolean verficarProprietarioInforme(String arquivoImportacao) {
        String cpfArquivo = new File(arquivoImportacao).getName().split("-")[0];
        if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().getCpf().naoFormatado().equals(cpfArquivo)) {
            return true;
        }
        Iterator itDependentes = ControladorGui.getDemonstrativoAberto().getDependentes().itens().iterator();
        while (itDependentes.hasNext()) {
            if (!((Dependente)((Object)itDependentes.next())).getCpfDependente().naoFormatado().equals(cpfArquivo)) continue;
            return true;
        }
        return false;
    }

    class FiltroArquivoInformeRendimentos
    implements FileFilter {
        private final String padraoNomeArquivoInformePlanoSaude = "(?i)(.*)\\.xml";

        FiltroArquivoInformeRendimentos() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return Validador.validarString((String)f.getName(), (String)"(?i)(.*)\\.xml");
        }

        public String getDescription() {
            return "Arquivos de Informe de Plano de Sa\u00fade IRPF-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.EXERCICIO_ANTERIOR;
        }
    }
}

