/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.declaracao.assistida.informerendimentos;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileFilter;
import serpro.ppgd.irpf.declaracao.assistida.informerendimentos.InformeRendimentosPJ;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.declaracao.assistida.informeplanosaude.PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude;
import serpro.ppgd.irpf.gui.declaracao.assistida.informerendimentos.PainelPrevisualizadorDeclaracaoAssistidaInformeRendimentos;
import serpro.ppgd.irpf.gui.dialogs.PainelMensagemDetalhada;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.txt.importacao.informerendimentospj.RepositorioXMLDadosInformes;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.Validador;

public class ProcessoImportacaoInformeRendimentos {
    private boolean importacao = true;

    public ProcessoImportacaoInformeRendimentos() {
    }

    public ProcessoImportacaoInformeRendimentos(boolean importacao) {
        this.importacao = importacao;
    }

    public String escolherArquivo() {
        String importacaoOuImpressao = this.importacao ? "Importa\u00e7\u00e3o" : "Impress\u00e3o";
        String imprimeOuImporta = this.importacao ? "Importa" : "Imprime";
        FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
        fc.setDialogTitle(importacaoOuImpressao + " de Informe de Rendimentos para o IRPF " + ConstantesGlobais.EXERCICIO);
        fc.setApproveButtonText("OK");
        fc.setApproveButtonToolTipText(imprimeOuImporta + " dados de Informe de Rendimentos do IRPF " + ConstantesGlobais.EXERCICIO);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter((FileFilter)new FiltroArquivoInformeRendimentos());
        fc.setMultiSelectionEnabled(false);
        FileChooserResponse ret = fc.showOpenDialog((Component)ControladorGui.getJanelaPrincipal());
        if (ret == FileChooserResponse.APPROVE_OPTION) {
            return fc.getSelectedFile().getAbsolutePath();
        }
        return null;
    }

    public List<Exception> validarFormatoArquivoXML(String xsdFullFilename, String xmlFullFilename) throws SAXException, IOException {
        Source xmlFile = null;
        final ArrayList<Exception> erros = new ArrayList<Exception>();
        try {
            xmlFile = new StreamSource(new File(xmlFullFilename));
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(ProcessoImportacaoInformeRendimentos.class.getResource("/" + xsdFullFilename));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    erros.add(exception);
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    erros.add(exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    erros.add(exception);
                }
            });
            validator.validate(xmlFile);
        }
        catch (SAXException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid");
            System.out.println("Reason: " + e.getLocalizedMessage());
            throw e;
        }
        catch (IOException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid");
            System.out.println("Reason: " + e.getLocalizedMessage());
            throw e;
        }
        return erros;
    }

    private void preVisualizar(InformeRendimentosPJ informeRendimentos) {
        PainelDemonstrativoIf painelAtualmenteExibido = ControladorGui.getPainelAtualmenteExibido();
        PainelPrevisualizadorDeclaracaoAssistidaInformeRendimentos painelPreVisualizacaoInformeRendimentos = new PainelPrevisualizadorDeclaracaoAssistidaInformeRendimentos(informeRendimentos, painelAtualmenteExibido);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painelPreVisualizacaoInformeRendimentos);
    }

    public void importar() {
        PainelDemonstrativoIf painel = ControladorGui.getPainelAtualmenteExibido();
        if (painel == null || !painel.getClass().isAssignableFrom(PainelPrevisualizadorDeclaracaoAssistidaInformeRendimentos.class) && !painel.getClass().isAssignableFrom(PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude.class)) {
            this.importar(this.escolherArquivo());
        }
    }

    public void importar(String arquivoImportacao) {
        PainelDemonstrativoIf painel = ControladorGui.getPainelAtualmenteExibido();
        if (painel == null || !painel.getClass().isAssignableFrom(PainelPrevisualizadorDeclaracaoAssistidaInformeRendimentos.class) && !painel.getClass().isAssignableFrom(PainelPrevisualizadorDeclaracaoAssistidaInformePlanoSaude.class)) {
            if (arquivoImportacao != null) {
                List<Object> erros = new ArrayList<Exception>();
                try {
                    erros = this.validarFormatoArquivoXML("informe_fontes_pagadoras.xsd", arquivoImportacao);
                }
                catch (Exception ex) {
                    erros.add(ex);
                }
                try {
                    if (erros.size() == 0) {
                        InformeRendimentosPJ informeRendimentos = new InformeRendimentosPJ();
                        new RepositorioXMLDadosInformes().importaDados(new File(arquivoImportacao), (ObjetoNegocio)informeRendimentos);
                        informeRendimentos.ajustar13PensoesAlimenticias();
                        if (!informeRendimentos.getHeader().getAnoExercicio().naoFormatado().equals(ConstantesGlobais.EXERCICIO)) {
                            GuiUtil.mostrarAviso((String)"importar_informe_rendimentos_ano_invalido", (String[])new String[]{"Exerc\u00edcio"});
                        } else if (!informeRendimentos.getHeader().getAnoCalendario().naoFormatado().equals(ConstantesGlobais.ANO_BASE)) {
                            GuiUtil.mostrarAviso((String)"importar_informe_rendimentos_ano_invalido", (String[])new String[]{"Ano-Calend\u00e1rio"});
                        } else {
                            if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().getCpf().naoFormatado().equals(informeRendimentos.getHeader().getCpfeBeneficiario().naoFormatado())) {
                                informeRendimentos.setTipoInforme(1);
                            } else if (ControladorGui.getDemonstrativoAberto().getDependentes().isExisteCpf(informeRendimentos.getHeader().getCpfeBeneficiario().naoFormatado())) {
                                informeRendimentos.setTipoInforme(2);
                            }
                            if (informeRendimentos.getTipoInforme() == 1 || informeRendimentos.getTipoInforme() == 2) {
                                this.preVisualizar(informeRendimentos);
                            } else {
                                GuiUtil.mostrarAviso((String)"importar_informe_cpf_incorreto", (String[])new String[]{"Rendimentos", informeRendimentos.getHeader().getCpfeBeneficiario().formatado()});
                            }
                        }
                    }
                }
                catch (SAXException ex) {
                    erros.add(ex);
                }
                catch (IOException ex) {
                    GuiUtil.mostrarErro((String)"importar_informe_rendimentos_arquivo_erro");
                }
                catch (ParserConfigurationException ex) {
                    GuiUtil.mostrarErro((String)"importar_informe_rendimentos_arquivo_erro");
                }
                if (erros.size() > 0) {
                    StringBuilder mensagemErroCompleta = new StringBuilder();
                    String nomeArquivo = new File(arquivoImportacao).getName();
                    for (Exception exception : erros) {
                        Object complemento = "";
                        if (exception instanceof SAXParseException) {
                            SAXParseException e = (SAXParseException)exception;
                            complemento = "(Linha " + e.getLineNumber() + ", Coluna " + e.getColumnNumber() + " do informe de rendimentos) ";
                        }
                        mensagemErroCompleta.append((String)complemento + exception.getLocalizedMessage() + "\n");
                    }
                    PainelMensagemDetalhada painelMensagemDetalhada = new PainelMensagemDetalhada("Falha na Importa\u00e7\u00e3o do Informe de Rendimentos", MensagemUtil.getMensagem("importar_informe_rendimentos_arquivo_invalido_sem_parametro"), mensagemErroCompleta.toString(), nomeArquivo);
                    GuiUtil.exibeDialog((JComponent)painelMensagemDetalhada, (boolean)true, (String)"Importa\u00e7\u00e3o de Informe de Rendimentos", (boolean)false);
                }
            }
        } else {
            GuiUtil.mostrarAviso((String)"acao_cancelar_acao_atual");
        }
    }

    class FiltroArquivoInformeRendimentos
    implements FileFilter {
        private final String padraoNomeArquivoInformeRendimentos = "(?i)(.*)\\.xml";

        FiltroArquivoInformeRendimentos() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return Validador.validarString((String)f.getName(), (String)"(?i)(.*)\\.xml");
        }

        public String getDescription() {
            return "Arquivos de Informe de Rendimentos IRPF-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.EXERCICIO_ANTERIOR;
        }
    }
}

