/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.dependentes;

import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.dependentes.ObservadorTotalizaDependentes;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.UtilitariosString;

public class Dependentes
extends Colecao<Dependente> {
    private transient Valor totalDeducaoDependentes = new Valor((ObjetoNegocio)this, "Total de Dedu\u00e7\u00e3o com Dependentes");
    private ObservadorTotalizaDependentes obsTotalizaDep;
    private WeakReference<DeclaracaoIRPF> weakDec = null;

    public Dependentes(DeclaracaoIRPF dec) {
        this.weakDec = new WeakReference<DeclaracaoIRPF>(dec);
        this.setFicha("Dependentes");
        this.totalDeducaoDependentes.setReadOnly(true);
        this.totalDeducaoDependentes.setFicha(this.getFicha());
        this.totalDeducaoDependentes.setAtributoPersistente(false);
        this.obsTotalizaDep = new ObservadorTotalizaDependentes(this);
        this.addObservador(this.obsTotalizaDep);
    }

    public Valor getTotalDeducaoDependentes() {
        return this.totalDeducaoDependentes;
    }

    public void objetoInserido(Dependente dependente) {
        dependente.addObservador(this.obsTotalizaDep);
        dependente.getCpfDependente().addObservador(dependente.getCpfDependente().getNomeCampo(), new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                String cpfAnterior;
                String nomeCampo;
                if (observado instanceof Informacao && (nomeCampo = ((Informacao)observado).getNomeCampo()) != null && nomeCampo.equals(nomePropriedade) && !(cpfAnterior = (String)valorAntigo).isEmpty()) {
                    ((DeclaracaoIRPF)((Object)Dependentes.this.weakDec.get())).getBens().limparDependente(cpfAnterior);
                }
            }
        });
    }

    public void objetoRemovido(Object o) {
        Dependente dependente = (Dependente)((Object)o);
        dependente.removeObservador(this.obsTotalizaDep);
        ((DeclaracaoIRPF)((Object)this.weakDec.get())).getBens().limparDependente(dependente.getCpfDependente().naoFormatado());
    }

    public String getNomeDependenteByChave(String chave) {
        for (Dependente d : this.itens()) {
            if (!d.getChave().equals(chave)) continue;
            return d.getNome().formatado();
        }
        return null;
    }

    public boolean isCpfDuplicado(String cpf, String Chave2) {
        int counter = 0;
        for (Dependente d : this.itens()) {
            if (!d.getCpfDependente().naoFormatado().equals(cpf)) continue;
            ++counter;
        }
        return counter > 1;
    }

    public boolean isExisteCpf(String cpf) {
        for (Dependente d : this.itens()) {
            if (!d.getCpfDependente().naoFormatado().equals(cpf)) continue;
            return true;
        }
        return false;
    }

    public int countCpf(String cpf) {
        int cont = 0;
        Iterator it = this.itens().iterator();
        while (it.hasNext()) {
            String d = ((Dependente)((Object)it.next())).getCpfDependente().naoFormatado();
            if (d.trim().length() <= 0 || !d.equals(cpf)) continue;
            ++cont;
        }
        return cont;
    }

    public boolean isExisteNome(String nome) {
        for (Dependente d : this.itens()) {
            if (!d.getNome().naoFormatado().equals(nome)) continue;
            return true;
        }
        return false;
    }

    public Dependente getDependenteByNome(String nome) {
        if (nome != null) {
            nome = nome.trim().toUpperCase();
            for (Dependente d : this.itens()) {
                if (!d.getNome().naoFormatado().toUpperCase().equals(nome)) continue;
                return d;
            }
        }
        return null;
    }

    public Dependente getDependenteByCpf(String cpf) {
        for (Dependente d : this.itens()) {
            if (!d.getCpfDependente().naoFormatado().equals(cpf)) continue;
            return d;
        }
        return null;
    }

    public Dependente instanciaNovoObjeto() {
        return new Dependente((DeclaracaoIRPF)((Object)this.weakDec.get()));
    }

    public boolean confirmaExclusaoImportacoesDependente(String nomeDep, String cpfDep, boolean exclusao) {
        boolean achouAlimentando = false;
        boolean achouPagamentos = false;
        boolean achouRendPJ = false;
        boolean achouRendPF = false;
        boolean achouGC = false;
        boolean achouRendaVar = false;
        boolean achouFII = false;
        boolean achouRendPJExigSusp = false;
        boolean achouRendAcm = false;
        boolean achouRendIsentos = false;
        boolean achouRendTribExclusiva = false;
        boolean achouBensDireitos = false;
        int qtdFichasUsam = 0;
        IRPFFacade facade = IRPFFacade.getInstancia();
        if (facade.getAlimentandos().possuiDependenteComCPF(cpfDep)) {
            achouAlimentando = true;
            ++qtdFichasUsam;
        }
        if (facade.getBens().possuiDependenteComCPF(cpfDep) && !cpfDep.isEmpty()) {
            achouBensDireitos = true;
            ++qtdFichasUsam;
        }
        if (facade.getPagamentos().possuiDependente(nomeDep) && !cpfDep.isEmpty()) {
            achouPagamentos = true;
            ++qtdFichasUsam;
        }
        if (facade.getColecaoRendPJDependente().possuiDependenteComCPF(cpfDep)) {
            achouRendPJ = true;
            ++qtdFichasUsam;
        }
        if (facade.getRendPFDependente().possuiDependenteComCPF(cpfDep)) {
            achouRendPF = true;
            ++qtdFichasUsam;
        }
        if (facade.getRendIsentos().possuiDependenteComCPF(cpfDep)) {
            achouRendIsentos = true;
            ++qtdFichasUsam;
        }
        if (facade.getRendTributacaoExclusiva().possuiDependenteComCPF(cpfDep)) {
            achouRendTribExclusiva = true;
            ++qtdFichasUsam;
        }
        if (!IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado().equals(cpfDep)) {
            if (facade.getGCAP().existeDemonstrativoParaCPF(cpfDep)) {
                achouGC = true;
                ++qtdFichasUsam;
            }
            if (facade.getRendaVariavelDependente().possuiDependenteComCPF(cpfDep)) {
                achouRendaVar = true;
                ++qtdFichasUsam;
            }
            if (facade.getFundosInvestimentosDependente().possuiDependenteComCPF(cpfDep)) {
                achouFII = true;
                ++qtdFichasUsam;
            }
        }
        if (facade.getColecaoRendPJComExigibilidadeDependente().possuiDependenteComCPF(cpfDep)) {
            achouRendPJExigSusp = true;
            ++qtdFichasUsam;
        }
        if (facade.getColecaoRendAcmDependente().possuiDependenteComCPF(cpfDep)) {
            achouRendAcm = true;
            ++qtdFichasUsam;
        }
        String msgExcluirCascata = "Este dependente (CPF: " + UtilitariosString.formataCPF((String)cpfDep) + ") \u00e9 utilizado na(s) ficha(s): \n";
        if (achouAlimentando) {
            msgExcluirCascata = msgExcluirCascata + "- Alimentandos \n";
        }
        if (achouPagamentos) {
            msgExcluirCascata = msgExcluirCascata + "- Pagamentos \n";
        }
        if (achouRendPJ) {
            msgExcluirCascata = msgExcluirCascata + "- Rend. Trib. Receb. de PJ \n";
        }
        if (achouRendPF) {
            msgExcluirCascata = msgExcluirCascata + "- Rend. Trib. Receb. de PF/Exterior \n";
        }
        if (achouRendIsentos) {
            msgExcluirCascata = msgExcluirCascata + "- Rend. Isentos e N\u00e3o Tribut\u00e1veis \n";
        }
        if (achouRendTribExclusiva) {
            msgExcluirCascata = msgExcluirCascata + "- Rend. Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva \n";
        }
        if (achouRendPJExigSusp) {
            msgExcluirCascata = msgExcluirCascata + "- Rend. Trib. Receb. de PJ com Exigibilidade Suspensa \n";
        }
        if (achouRendAcm) {
            msgExcluirCascata = msgExcluirCascata + "- Rendimentos Recebidos Acumuladamente \n";
        }
        if (achouBensDireitos) {
            msgExcluirCascata = msgExcluirCascata + "- Bens e Direitos \n";
        }
        if (achouGC) {
            msgExcluirCascata = msgExcluirCascata + "- Ganhos de Capital \n";
        }
        if (achouRendaVar) {
            msgExcluirCascata = msgExcluirCascata + "- Renda Vari\u00e1vel - Opera\u00e7\u00f5es Comuns/Day-Trade\n";
        }
        if (achouRendaVar) {
            msgExcluirCascata = msgExcluirCascata + "- Renda Vari\u00e1vel - Opera\u00e7\u00f5es de Fundos de Investimento Imobili\u00e1rio\n";
        }
        boolean achouAlgumEmCascata = achouPagamentos || achouRendPJ || achouRendPF || achouRendIsentos || achouRendTribExclusiva || achouGC || achouRendaVar || achouFII || achouRendPJExigSusp || achouRendAcm || achouBensDireitos;
        msgExcluirCascata = exclusao ? msgExcluirCascata + "\nDeseja excluir mesmo assim?" : msgExcluirCascata + "\nOs dados deste dependente na(s) ficha(s) acima ser\u00e3o exclu\u00eddos.\nDeseja alterar o CPF mesmo assim?";
        if (!achouAlgumEmCascata) {
            return true;
        }
        if (GuiUtil.mostrarConfirma((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal(), (String)msgExcluirCascata)) {
            if (achouAlimentando) {
                facade.getAlimentandos().excluirAlimentandosComDependente(cpfDep);
            }
            if (achouPagamentos) {
                facade.getPagamentos().excluirPagamentosComDependente(nomeDep);
            }
            if (achouRendPJ) {
                facade.getColecaoRendPJDependente().excluirDependentesComCPF(cpfDep);
            }
            if (achouRendPJExigSusp) {
                facade.getColecaoRendPJComExigibilidadeDependente().excluirDependentesComCPF(cpfDep);
            }
            if (achouRendAcm) {
                facade.getColecaoRendAcmDependente().excluirDependentesComCPF(cpfDep);
            }
            if (achouRendPF) {
                facade.getRendPFDependente().excluirDependentesComCPF(cpfDep);
            }
            if (achouRendIsentos) {
                facade.getRendIsentos().excluirDependentesComCPF(cpfDep);
            }
            if (achouRendTribExclusiva) {
                facade.getRendTributacaoExclusiva().excluirDependentesComCPF(cpfDep);
            }
            if (achouGC) {
                facade.getGCAP().removerDemonstrativosPorCPF(cpfDep);
            }
            if (achouRendaVar) {
                facade.getRendaVariavelDependente().excluirDependentesComCPF(cpfDep);
            }
            if (achouFII) {
                facade.getFundosInvestimentosDependente().excluirDependentesComCPF(cpfDep);
            }
            if (achouBensDireitos) {
                facade.getBens().excluirDependentesComCPF(cpfDep);
            }
            return true;
        }
        return false;
    }

    public Valor obterTotalRendimentosPorDependenteDeficiente(CPF cpfDependente) {
        Valor total = new Valor();
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPJ().getColecaoRendPJDependente().obterRendimentosRecebidosPJPorDependente(cpfDependente));
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPFDependente().obterRendimentosRecebidosPorDependente(cpfDependente));
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendAcm().getColecaoRendAcmDependente().obterRendimentosRecebidosPorDependente(cpfDependente));
        return total;
    }

    public Valor obterTotalDeducoesPorDependenteDeficiente(CPF cpfDependente, Valor rendimentos) {
        Valor total = new Valor();
        if (((DeclaracaoIRPF)((Object)this.weakDec.get())).getIdentificadorDeclaracao().isCompleta()) {
            total.append('+', TabelaAliquotasIRPF.ConstantesAliquotas.deducaoDependente.getValor());
            total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPJ().getColecaoRendPJDependente().obterTotalPrevidenciaPorDependente(cpfDependente));
            total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPFDependente().obterPrevidenciaPorDependente(cpfDependente));
            total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPFDependente().obterLivroCaixaPorDependente(cpfDependente));
            total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendAcm().getColecaoRendAcmDependente().obterPrevidenciaAjustePorDependente(cpfDependente));
            total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getPagamentos().obterTotalDedutivelInstrucaoPorDependente(cpfDependente));
            total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getPagamentos().obterTotalDedutivelDespesasMedicasPorDependente(cpfDependente));
            total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getPagamentos().obterTotalDedutivelPrevidenciaPorDependente(cpfDependente, rendimentos));
            total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getPagamentos().obterTotalPensaoAlimenticiaPorDependente(cpfDependente));
            total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendAcm().getColecaoRendAcmDependente().obterPensaoAlimenticiaPorDependente(cpfDependente));
        } else {
            total.setConteudo("0,00");
        }
        return total;
    }

    public Valor obterTotalRendimentosPorDependente(CPF cpfDependente) {
        Valor total = new Valor();
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPJ().getColecaoRendPJDependente().obterRendimentosRecebidosPorDependente(cpfDependente));
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPFDependente().obterRendimentosRecebidosPorDependente(cpfDependente));
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeDependente().obterRendimentosRecebidosPorDependente(cpfDependente));
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendAcm().getColecaoRendAcmDependente().obterRendimentosRecebidosPorDependente(cpfDependente));
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendIsentos().recuperarTotalPorBeneficiario(cpfDependente));
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendTributacaoExclusiva().recuperarTotalPorBeneficiario(cpfDependente));
        total.append('+', (Valor)((DeclaracaoIRPF)((Object)this.weakDec.get())).getGCAP().obterSomatorioGanhoCapital1AlienacoesGCAP(cpfDependente.naoFormatado()));
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getRendaVariavelDependente().recuperarTotalRendimentosPorBeneficiario(cpfDependente));
        total.append('+', ((DeclaracaoIRPF)((Object)this.weakDec.get())).getFundosInvestimentosDependente().recuperarTotalRendimentosPorBeneficiario(cpfDependente));
        return total;
    }

    public ArrayList<String> getCPFDependenteConjuge() {
        ArrayList<String> esposas = new ArrayList<String>();
        for (Dependente d : this.itens()) {
            if (!d.getCodigo().formatado().equals("11")) continue;
            esposas.add(d.getCpfDependente().naoFormatado());
        }
        return esposas;
    }

    public void excluirDependentesCadastradosComoAlimentando(DeclaracaoIRPF dec) {
        ArrayList<Dependente> dependentes = new ArrayList<Dependente>();
        for (Dependente dependente : this.itens()) {
            if (!dec.getAlimentandos().isExisteCPF(dependente.getCpfDependente().naoFormatado())) continue;
            dependentes.add(dependente);
        }
        for (Dependente dependente : dependentes) {
            this.excluirDependenteEmCascata(dec, dependente, true);
        }
    }

    public void excluirDependenteEmCascata(DeclaracaoIRPF dec, Dependente dependente, boolean manterAlimentando) {
        if (!manterAlimentando) {
            dec.getAlimentandos().excluirAlimentandosComDependente(dependente.getCpfDependente().naoFormatado());
        }
        dec.getPagamentos().excluirPagamentosComDependente(dependente.getNome().naoFormatado());
        dec.getColecaoRendPJDependente().excluirDependentesComCPF(dependente.getCpfDependente().naoFormatado());
        dec.getColecaoRendPJComExigibilidadeDependente().excluirDependentesComCPF(dependente.getCpfDependente().naoFormatado());
        dec.getColecaoRendAcmDependente().excluirDependentesComCPF(dependente.getCpfDependente().naoFormatado());
        dec.getRendPFDependente().excluirDependentesComCPF(dependente.getCpfDependente().naoFormatado());
        dec.getRendIsentos().excluirDependentesComCPF(dependente.getCpfDependente().naoFormatado());
        dec.getRendTributacaoExclusiva().excluirDependentesComCPF(dependente.getCpfDependente().naoFormatado());
        dec.getGCAP().removerDemonstrativosPorCPF(dependente.getCpfDependente().naoFormatado());
        dec.getRendaVariavelDependente().excluirDependentesComCPF(dependente.getCpfDependente().naoFormatado());
        dec.getFundosInvestimentosDependente().excluirDependentesComCPF(dependente.getCpfDependente().naoFormatado());
        dec.getBens().excluirDependentesComCPF(dependente.getCpfDependente().naoFormatado());
        dec.getDependentes().itens().remove((Object)dependente);
    }
}

